/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.olap.common;

import com.cognos.xqe.data.olap.common.MSASCommonFormatInfo;
import com.cognos.xqe.data.olap.common.MSASCommonFormatter;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.FormatServiceUtils;
import com.cognos.xqe.format.XQEFormatService;
import com.cognos.xqe.format.string.FormatParserType;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.format.string.IFormatParser;
import com.cognos.xqe.trace.LogLevel;
import java.util.Locale;

public class MSASCommonFormatParser
implements IFormatParser {
    private final FormatService mService;

    public MSASCommonFormatParser(FormatService service) {
        this.mService = service;
    }

    public Object getFormatCacheKey(IFormatInfo formatInfo, Locale locale) {
        return FormatServiceUtils.generateFormatCacheKey((FormatParserType)FormatParserType.MSAS, (boolean)this.isFormatInfoValid(formatInfo), (IFormatInfo)formatInfo, (Locale)locale);
    }

    private boolean isFormatInfoValid(IFormatInfo info) {
        if (null == info) {
            return false;
        }
        MSASCommonFormatInfo msasInfo = (MSASCommonFormatInfo)info;
        if (null == msasInfo.getFormatString()) {
            return false;
        }
        if (null == msasInfo.getTypeGroupEnum()) {
            return false;
        }
        if (null == msasInfo.getUnknownCurrency()) {
            return false;
        }
        if (XQEFormatService.FSLOGGER_STRING_PARSING.isOn(LogLevel.TRACE)) {
            XQEFormatService.FSLOGGER_STRING_PARSING.log(LogLevel.TRACE, "MSASFormatString:" + msasInfo.getFormatString());
        }
        return true;
    }

    public FormatPropertySet parseFormat(IFormatInfo info, Locale locale) throws Exception {
        if (null == info) {
            return null;
        }
        MSASCommonFormatInfo msasInfo = (MSASCommonFormatInfo)info;
        MSASCommonFormatter commonFormatter = new MSASCommonFormatter(locale, msasInfo.getUnknownCurrency());
        FormatPropertySet set = commonFormatter.constructFormatString(msasInfo.getTypeGroupEnum(), msasInfo.getIncludeCurrency(), msasInfo.getFormatString(), msasInfo.getLanguage());
        if (null == set) {
            return null;
        }
        return set;
    }
}

