/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.olap.common;

import com.cognos.xqe.data.olap.common.CommonMessageKeys;
import com.cognos.xqe.data.olap.common.CommonRuntimeException;
import com.cognos.xqe.data.olap.common.MSASTypeGroupEnum;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.util.LocaleConverter;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MSASCommonFormatter {
    private String unknownCurrency;
    private String formatString;
    private final FormatPropertySet propertySet;
    private final FormatService formatService;
    private int scale;
    private static final String FORMAT_STRING_STANDARD = "Standard";
    private static final String FORMAT_STRING_CURRENCY = "Currency";
    private static final String FORMAT_STRING_PERCENT = "Percent";
    private static final String FORMAT_STRING_SHORT_TIME = "Short Time";
    private static final String FORMAT_STRING_SHORT_DATE = "Short Date";
    private static final String MSAS_REGX = "(([#]{1,3}([,|\\s|\\u00A0][#]{1,3})?)+)([0]?[.]?0+)?";
    public static final String DEFAULT_EMPTY_FORMAT = "";
    private static final String XML_STRING_FORMAT = "stringFormat";
    private static final String XML_FALSE = "false";
    private static final String XML_TRUE = "true";
    private static final String XML_TWO = "2";
    private static final String XML_NON_BREAKING_SPACE = "&amp;#160;";
    private static final String ONE_DIGIT = "1-digit";
    private static final String TWO_DIGITS = "2-digits";
    private static final String SHORT_NAME = "shortName";
    private static final String FULL_NAME = "fullName";
    private static final int LENGTH_3 = 3;
    private static final int LENGTH_4 = 4;
    private static final String PATTERN = "pattern";
    private static final String WHEN_ZERO = "whenZero";
    private static final String WHEN_MISSING = "whenMissing";
    private static final String APOS = "'";
    private static final String BACKSLASH = "\\";
    private static final String PERCENT = "%";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String NON_BREAKING_SPACE = "\u00a0";
    private static final String GROUPSEPARATOR = ",";
    private static final char GROUP_SEPARATOR = ',';
    private static final String DECIMAL_SEPARATOR = ".";
    private static final char POUND = '#';
    private static final char ZERO = '0';
    private static final String TWO_DECIMALS = ".00";
    private static final int GROUP_SIZE = 3;
    protected int defaultGroupingSize = -1;
    protected String localizedDecimalSeparator = null;
    protected String localizedGroupingSeparator = null;
    private final Locale formatLocale;
    private final Map<Integer, String> languageMap = new TreeMap<Integer, String>();

    public MSASCommonFormatter(Locale locale, String unknownCurr) {
        this.formatLocale = locale;
        this.unknownCurrency = unknownCurr;
        this.formatService = FormatService.getInstance();
        this.propertySet = new FormatPropertySet(this.formatService);
    }

    public int getGroupingSize() {
        if (this.defaultGroupingSize == -1) {
            this.defaultGroupingSize = 3;
            NumberFormat dec = DecimalFormat.getInstance((Locale)this.formatLocale);
            if (dec instanceof DecimalFormat) {
                this.defaultGroupingSize = ((DecimalFormat)dec).getGroupingSize();
            }
        }
        return this.defaultGroupingSize;
    }

    public String getDecimalSeparator() {
        if (this.localizedDecimalSeparator == null) {
            NumberFormat dec = DecimalFormat.getInstance((Locale)this.formatLocale);
            this.localizedDecimalSeparator = dec instanceof DecimalFormat ? Character.toString(((DecimalFormat)dec).getDecimalFormatSymbols().getDecimalSeparator()) : DECIMAL_SEPARATOR;
        }
        return this.localizedDecimalSeparator;
    }

    public String getGroupingSeparator() {
        if (this.localizedGroupingSeparator == null) {
            NumberFormat dec = DecimalFormat.getInstance((Locale)this.formatLocale);
            this.localizedGroupingSeparator = dec instanceof DecimalFormat ? Character.toString(((DecimalFormat)dec).getDecimalFormatSymbols().getGroupingSeparator()) : GROUPSEPARATOR;
        }
        return this.localizedGroupingSeparator;
    }

    private boolean patternMatch(String patternStr, MSASTypeGroupEnum formatType) {
        Pattern pattern = Pattern.compile(MSAS_REGX);
        Matcher m = pattern.matcher(patternStr);
        boolean hasMatch = m.matches();
        if (hasMatch) {
            int groupIndex;
            int decIndex = patternStr.indexOf(DECIMAL_SEPARATOR);
            int decSize = 0;
            if (decIndex != -1) {
                decSize = patternStr.length() - patternStr.indexOf(DECIMAL_SEPARATOR) - 1;
            }
            int minidigits = 0;
            if (decIndex != -1) {
                minidigits = 1;
            }
            if ((groupIndex = patternStr.indexOf(SPACE) & patternStr.indexOf(NON_BREAKING_SPACE)) != -1) {
                this.convertPoundSpace(decSize, minidigits);
            } else if (groupIndex == -1) {
                groupIndex = patternStr.indexOf(GROUPSEPARATOR);
                if (MSASTypeGroupEnum.TYPE_GROUP_STRING == formatType) {
                    this.convertPredefinedFormat(XML_STRING_FORMAT);
                } else if (groupIndex != -1) {
                    this.convertPound(XML_TRUE, XML_FALSE, String.valueOf(decSize));
                } else {
                    this.convertPound(XML_FALSE, XML_FALSE, String.valueOf(decSize));
                }
            }
        }
        return hasMatch;
    }

    public FormatPropertySet constructFormatString(MSASTypeGroupEnum formatType, boolean includeCurrencyUnit, String cellFormatString, int language) {
        this.formatString = cellFormatString;
        if (MSASTypeGroupEnum.TYPE_GROUP_UNKNOWN == formatType || this.formatString == null) {
            return this.propertySet;
        }
        if (this.patternMatch(cellFormatString, formatType)) {
            return this.propertySet;
        }
        if (this.formatString.equals(FORMAT_STRING_PERCENT) || MSASTypeGroupEnum.TYPE_GROUP_NUMERIC == formatType && this.formatString.endsWith(PERCENT) && this.formatString.contains(TWO_DECIMALS)) {
            if (MSASTypeGroupEnum.TYPE_GROUP_STRING != formatType) {
                this.convertPredefinedFormat("percentFormat");
            }
        } else if (this.formatString.equals(FORMAT_STRING_SHORT_TIME)) {
            if (MSASTypeGroupEnum.TYPE_GROUP_STRING == formatType) {
                this.convertPredefinedFormat(XML_STRING_FORMAT);
            } else {
                this.convertPredefinedFormat("timeFormat");
            }
        } else if (this.formatString.equals(FORMAT_STRING_SHORT_DATE)) {
            if (MSASTypeGroupEnum.TYPE_GROUP_STRING == formatType) {
                this.convertPredefinedFormat(XML_STRING_FORMAT);
            } else {
                this.convertPredefinedFormat("dateFormat");
            }
        } else if (this.formatString.equals(FORMAT_STRING_CURRENCY)) {
            if (MSASTypeGroupEnum.TYPE_GROUP_NUMERIC == formatType || MSASTypeGroupEnum.TYPE_GROUP_CURRENCY == formatType) {
                this.convertPredefinedFormat("currencyFormat");
                if (includeCurrencyUnit) {
                    this.propertySet.setCurrencyCode(this.getCurrencyCode(language));
                }
            } else if (MSASTypeGroupEnum.TYPE_GROUP_STRING == formatType) {
                this.convertPredefinedFormat(XML_STRING_FORMAT);
            } else {
                this.convertPredefinedFormat("currencyFormat");
            }
        } else if (this.formatString.equals(FORMAT_STRING_STANDARD)) {
            if (MSASTypeGroupEnum.TYPE_GROUP_NUMERIC == formatType) {
                this.convertPredefinedFormat("numberFormat");
            } else if (MSASTypeGroupEnum.TYPE_GROUP_CURRENCY == formatType) {
                this.convertPredefinedFormat("currencyFormat");
                if (includeCurrencyUnit) {
                    this.propertySet.setCurrencyCode(this.getCurrencyCode(language));
                }
            } else if (MSASTypeGroupEnum.TYPE_GROUP_DATE == formatType) {
                this.convertPredefinedFormat("dateTimeFormat");
            } else if (MSASTypeGroupEnum.TYPE_GROUP_STRING == formatType) {
                this.convertPredefinedFormat(XML_STRING_FORMAT);
            }
        } else if (MSASTypeGroupEnum.TYPE_GROUP_NUMERIC == formatType || MSASTypeGroupEnum.TYPE_GROUP_CURRENCY == formatType) {
            this.convertNumericFormat(formatType);
        } else if (MSASTypeGroupEnum.TYPE_GROUP_DATE == formatType) {
            this.convertDateTimeFormat();
        } else if (MSASTypeGroupEnum.TYPE_GROUP_STRING == formatType) {
            this.convertStringFormat();
        }
        return this.propertySet;
    }

    private String getCurrencyCode(int language) {
        if (this.languageMap.containsKey(language)) {
            return this.languageMap.get(language);
        }
        String currencyCode = LocaleConverter.toCurrCode((Integer)language, (String)this.unknownCurrency);
        this.languageMap.put(language, currencyCode);
        return currencyCode;
    }

    private void convertStringFormat() {
        StringTokenizer st = new StringTokenizer(this.formatString, SEMICOLON);
        try {
            this.propertySet.setFormatType(XML_STRING_FORMAT);
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("xml:lang", LocaleConverter.localeToStr((Locale)this.formatLocale)));
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue(WHEN_MISSING, st.nextToken()));
            }
        }
        catch (Exception ex) {
            throw new CommonRuntimeException(CommonMessageKeys.GEN_INTERNAL_ERROR, ex, "convertStringFormat");
        }
    }

    private void convertNumericFormat(MSASTypeGroupEnum formatType) {
        StringTokenizer st = new StringTokenizer(this.formatString, SEMICOLON);
        String positivePart = new String();
        String negativePart = new String();
        try {
            this.scale = 0;
            StringBuilder patternStr = new StringBuilder();
            if (st.hasMoreTokens()) {
                positivePart = st.nextToken();
                this.parsePattern(positivePart, patternStr, true);
            }
            if (st.hasMoreTokens()) {
                patternStr.append(SEMICOLON);
                negativePart = st.nextToken();
                this.parsePattern(negativePart, patternStr, false);
            }
            if (MSASTypeGroupEnum.TYPE_GROUP_NUMERIC == formatType) {
                if (!st.hasMoreTokens() && !positivePart.isEmpty() && positivePart.length() == negativePart.length() - 1 && positivePart.equals(negativePart.substring(1)) && this.patternMatch(positivePart, formatType)) {
                    return;
                }
                this.propertySet.setFormatType("numberFormat");
            } else if (MSASTypeGroupEnum.TYPE_GROUP_CURRENCY == formatType) {
                this.propertySet.setFormatType("currencyFormat");
            }
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("xml:lang", LocaleConverter.localeToStr((Locale)this.formatLocale)));
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue(PATTERN, patternStr.toString()));
            if (this.scale < 0) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("scale", Integer.toString(this.scale)));
            }
            if (st.hasMoreTokens()) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue(WHEN_ZERO, this.getLiteralCharacters(st.nextToken())));
            }
            if (st.hasMoreTokens()) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue(WHEN_MISSING, this.getLiteralCharacters(st.nextToken())));
            }
        }
        catch (Exception ex) {
            throw new CommonRuntimeException(CommonMessageKeys.GEN_INTERNAL_ERROR, ex, "convertNumericFormat");
        }
    }

    private int calculateScale(String inStr) {
        String leftStr;
        int numPlaceHolders = 0;
        int index = inStr.lastIndexOf(DECIMAL_SEPARATOR);
        int groupSepIndex = inStr.lastIndexOf(44);
        boolean foundDigit = false;
        if (groupSepIndex == inStr.length() - 1 && index < inStr.length() - 1) {
            index = inStr.length();
        }
        if (index != -1 && (leftStr = inStr.substring(0, index)).charAt(leftStr.length() - 1) == ',') {
            --index;
            while (index != -1) {
                if (leftStr.charAt(index) == ',') {
                    ++numPlaceHolders;
                } else {
                    if (leftStr.charAt(index) == '#' || leftStr.charAt(index) == '0') {
                        foundDigit = true;
                        break;
                    }
                    if (leftStr.charAt(index) != '.') {
                        numPlaceHolders = 0;
                    }
                }
                --index;
            }
            if (!foundDigit) {
                numPlaceHolders = 0;
            }
        }
        return numPlaceHolders * 3 * -1;
    }

    private void parsePattern(String posStr, StringBuilder resultStr, boolean positive) {
        StringTokenizer tkzr = new StringTokenizer(posStr);
        while (tkzr.hasMoreTokens()) {
            String tmpStr = tkzr.nextToken();
            int index = tmpStr.indexOf(BACKSLASH);
            if (index != -1) {
                resultStr.append(APOS);
                resultStr.append(this.getLiteralCharacters(tmpStr));
                resultStr.append(APOS);
            } else {
                if (positive) {
                    this.scale = this.calculateScale(tmpStr);
                }
                resultStr.append(this.getNumericCharacters(tmpStr));
            }
            if (!tkzr.hasMoreTokens()) continue;
            resultStr.append(SPACE);
        }
    }

    private String removeGroupSeparator(String inputString, int groupSeparatorPos) {
        StringBuilder str = new StringBuilder(inputString.substring(0, groupSeparatorPos));
        str.append(inputString.substring(groupSeparatorPos + 1));
        return str.toString();
    }

    private String replacePoundWithZero(String inputString, int decPos, int count) {
        StringBuilder str = new StringBuilder(inputString.substring(0, decPos + 1));
        for (int i = 0; i < count; ++i) {
            str.append('0');
        }
        str.append(inputString.substring(decPos + count + 1));
        return str.toString();
    }

    private String substitution(String theString, int decPos, int zeroPos) {
        int theLength = zeroPos - decPos - 1;
        if (theLength > 0) {
            int groupingSepPos = theString.indexOf(GROUPSEPARATOR, decPos + 1);
            while (groupingSepPos > 0 && groupingSepPos < zeroPos) {
                theString = this.removeGroupSeparator(theString, groupingSepPos);
                --theLength;
                groupingSepPos = theString.indexOf(GROUPSEPARATOR, groupingSepPos);
            }
            theString = this.replacePoundWithZero(theString, decPos, theLength);
        }
        return theString;
    }

    private String getNumericCharacters(String inStr) {
        StringBuilder resultStr;
        int index;
        if (inStr.equals(",,.")) {
            return "',,'##0.;',,'-##0.";
        }
        int decPos = inStr.indexOf(DECIMAL_SEPARATOR, 0);
        int groupSepIndex = inStr.lastIndexOf(44);
        if (decPos == -1 && groupSepIndex == inStr.length() - 1) {
            decPos = inStr.length();
        }
        if (decPos > 0) {
            int semicolonPos = inStr.indexOf(SEMICOLON, decPos + 1);
            int decToZeroPos = 0;
            if (semicolonPos < 0) {
                decToZeroPos = inStr.lastIndexOf(48);
                inStr = this.substitution(inStr, decPos, decToZeroPos);
            } else {
                decToZeroPos = inStr.lastIndexOf(48, semicolonPos);
                if ((decPos = (inStr = this.substitution(inStr, decPos, decToZeroPos)).indexOf(DECIMAL_SEPARATOR, semicolonPos + 1)) > 0) {
                    decToZeroPos = inStr.indexOf(48);
                    inStr = this.substitution(inStr, decPos, decToZeroPos);
                }
            }
        }
        if ((index = (resultStr = new StringBuilder(inStr)).lastIndexOf(GROUPSEPARATOR)) != -1) {
            String leftStr;
            int numOfPlaceHolder = 0;
            if (index < resultStr.length() - 1) {
                char ch = resultStr.charAt(index + 1);
                while ((ch == '#' || ch == '0') && resultStr.length() - 1 > index + ++numOfPlaceHolder) {
                    ch = resultStr.charAt(index + 1 + numOfPlaceHolder);
                }
            }
            if (numOfPlaceHolder > 0 && numOfPlaceHolder < this.getGroupingSize()) {
                for (int i = numOfPlaceHolder; i < this.defaultGroupingSize; ++i) {
                    resultStr.insert(index + 1, '#');
                }
            }
            int indexDot = resultStr.lastIndexOf(DECIMAL_SEPARATOR);
            int groupIndex = resultStr.lastIndexOf(GROUPSEPARATOR);
            if (indexDot < resultStr.length() - 1 && groupIndex == resultStr.length() - 1) {
                indexDot = resultStr.length();
            }
            if (indexDot != -1 && (leftStr = inStr.substring(0, indexDot)).charAt(leftStr.length() - 1) == ',') {
                --indexDot;
                while (indexDot != -1 && leftStr.charAt(indexDot) == ',') {
                    resultStr = resultStr.deleteCharAt(indexDot);
                    --indexDot;
                }
            }
        }
        ArrayList<Integer> decimalSeparatorIndices = new ArrayList<Integer>();
        int dsInx = resultStr.indexOf(DECIMAL_SEPARATOR);
        while (dsInx > -1) {
            decimalSeparatorIndices.add(dsInx);
            resultStr.replace(dsInx, dsInx + 1, this.getDecimalSeparator());
            dsInx = resultStr.indexOf(DECIMAL_SEPARATOR, dsInx + 1);
        }
        int gsInx = resultStr.indexOf(GROUPSEPARATOR);
        while (gsInx > -1) {
            if (!decimalSeparatorIndices.contains(gsInx)) {
                resultStr.replace(gsInx, gsInx + 1, this.getGroupingSeparator());
            }
            gsInx = resultStr.indexOf(GROUPSEPARATOR, gsInx + 1);
        }
        return resultStr.toString();
    }

    private String getLiteralCharacters(String inStr) {
        StringTokenizer zr = new StringTokenizer(inStr, BACKSLASH);
        StringBuilder resultStr = new StringBuilder();
        while (zr.hasMoreTokens()) {
            resultStr.append(zr.nextToken());
        }
        return resultStr.toString();
    }

    private void convertDateTimeFormat() {
        String tempStr = this.convertMinuteMMtoNN(this.formatString);
        try {
            this.propertySet.setFormatType("dateTimeFormat");
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("xml:lang", LocaleConverter.localeToStr((Locale)this.formatLocale)));
            String expString = DEFAULT_EMPTY_FORMAT;
            int index = tempStr.indexOf(121);
            boolean addedShowDays = false;
            boolean julian = false;
            if (index != -1) {
                expString = tempStr.substring(index, tempStr.lastIndexOf(121) + 1);
            }
            if (1 == expString.length()) {
                julian = true;
                if (!addedShowDays) {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showDays", "Julian"));
                    addedShowDays = true;
                }
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showYears", XML_FALSE));
            } else if (2 == expString.length()) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showYears", "hideCentury"));
            } else if (expString.length() >= 4) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showYears", "showCentury"));
            } else {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showYears", XML_FALSE));
            }
            expString = DEFAULT_EMPTY_FORMAT;
            index = tempStr.indexOf(100);
            if (index != -1) {
                expString = tempStr.substring(index, tempStr.lastIndexOf(100) + 1);
            }
            if (expString.length() == 1) {
                if (!addedShowDays) {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showDays", XML_TRUE));
                    addedShowDays = true;
                }
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showWeekday", XML_FALSE));
            } else if (expString.length() == 2) {
                if (!addedShowDays) {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showDays", TWO_DIGITS));
                    addedShowDays = true;
                }
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showWeekday", XML_FALSE));
            } else if (expString.length() == 3) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showWeekday", SHORT_NAME));
                if (!addedShowDays) {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showDays", XML_FALSE));
                    addedShowDays = true;
                }
            } else if (expString.length() >= 4) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showWeekday", FULL_NAME));
                if (!addedShowDays) {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showDays", XML_FALSE));
                    addedShowDays = true;
                }
            } else {
                if (!julian && !addedShowDays) {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showDays", XML_FALSE));
                    addedShowDays = true;
                }
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showWeekday", XML_FALSE));
            }
            expString = DEFAULT_EMPTY_FORMAT;
            index = tempStr.indexOf(109);
            if (index != -1) {
                expString = tempStr.substring(index, tempStr.lastIndexOf(109) + 1);
            }
            if (expString.length() == 1) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMonths", ONE_DIGIT));
            } else if (expString.length() == 2) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMonths", TWO_DIGITS));
            } else if (expString.length() == 3) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMonths", SHORT_NAME));
            } else if (expString.length() >= 4) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMonths", FULL_NAME));
            } else {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMonths", XML_FALSE));
            }
            expString = DEFAULT_EMPTY_FORMAT;
            index = tempStr.indexOf(104);
            if (index != -1) {
                expString = tempStr.substring(index, tempStr.lastIndexOf(104) + 1);
            }
            if (1 == expString.length()) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showHours", XML_TRUE));
            } else if (expString.length() > 0) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showHours", TWO_DIGITS));
            } else {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showHours", XML_FALSE));
            }
            expString = DEFAULT_EMPTY_FORMAT;
            index = tempStr.indexOf(110);
            if (index != -1) {
                expString = tempStr.substring(index, tempStr.lastIndexOf(110) + 1);
            }
            switch (expString.length()) {
                case 1: {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMinutes", ONE_DIGIT));
                    break;
                }
                case 2: {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMinutes", TWO_DIGITS));
                    break;
                }
                default: {
                    this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMinutes", XML_FALSE));
                }
            }
            expString = DEFAULT_EMPTY_FORMAT;
            index = tempStr.indexOf(115);
            if (index != -1) {
                expString = tempStr.substring(index, tempStr.lastIndexOf(115) + 1);
            }
            if (1 == expString.length()) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showSeconds", XML_TRUE));
            } else if (expString.length() > 0) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showSeconds", TWO_DIGITS));
            } else {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showSeconds", XML_FALSE));
            }
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showMilliseconds", XML_FALSE));
            expString = DEFAULT_EMPTY_FORMAT;
            int indexA = tempStr.indexOf(97);
            int indexa = tempStr.indexOf(65);
            int indexp = tempStr.indexOf(112);
            int indexP = tempStr.indexOf(80);
            if (indexa != -1 || indexA != -1 || indexp != -1 || indexP != -1) {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showAmPm", XML_TRUE));
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("clock", "12-hour"));
            } else {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("showAmPm", XML_FALSE));
            }
        }
        catch (Exception ex) {
            throw new CommonRuntimeException(CommonMessageKeys.GEN_INTERNAL_ERROR, ex, "convertDateTimeFormat");
        }
    }

    private String convertMinuteMMtoNN(String inString) {
        int mIndex;
        StringBuilder resultStr = new StringBuilder(inString);
        int hIndex = resultStr.indexOf("h");
        if (hIndex != -1 && (mIndex = resultStr.indexOf("m", hIndex + 1)) != -1) {
            int numConverted = 0;
            while (mIndex < resultStr.length() && resultStr.charAt(mIndex) == 'm') {
                if (numConverted < 2) {
                    resultStr.setCharAt(mIndex, 'n');
                    ++numConverted;
                } else {
                    resultStr.setCharAt(mIndex, ' ');
                }
                ++mIndex;
            }
        }
        if ((hIndex = resultStr.indexOf("am")) != -1) {
            resultStr.setCharAt(hIndex + 1, 'f');
        }
        if ((hIndex = resultStr.indexOf("AM")) != -1) {
            resultStr.replace(hIndex, hIndex + 2, "af");
        }
        if ((hIndex = resultStr.indexOf("pm")) != -1) {
            resultStr.setCharAt(hIndex + 1, 'f');
        }
        if ((hIndex = resultStr.indexOf("PM")) != -1) {
            resultStr.replace(hIndex, hIndex + 2, "pf");
        }
        return resultStr.toString();
    }

    private void convertPredefinedFormat(String formatName) {
        try {
            this.propertySet.setFormatType(formatName);
            if (formatName == "percentFormat") {
                this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("decimalSize", XML_TWO));
            }
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("xml:lang", LocaleConverter.localeToStr((Locale)this.formatLocale)));
        }
        catch (Exception ex) {
            throw new CommonRuntimeException(CommonMessageKeys.GEN_INTERNAL_ERROR, ex, "convertPredefinedFormat");
        }
    }

    private void convertPound(String group, String scientific, String decimal) {
        try {
            this.propertySet.setFormatType("numberFormat");
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("useGrouping", group));
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("useScientific", scientific));
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("decimalSize", decimal));
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("xml:lang", LocaleConverter.localeToStr((Locale)this.formatLocale)));
        }
        catch (Exception ex) {
            throw new CommonRuntimeException(CommonMessageKeys.GEN_INTERNAL_ERROR, ex, "convertPound");
        }
    }

    private void convertPoundSpace(int decimalsize, int miniDigits) {
        try {
            this.propertySet.setFormatType("numberFormat");
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("useGrouping", XML_TRUE));
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("useScientific", XML_FALSE));
            this.propertySet.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.formatService, (String)"decimalSize", (Object)decimalsize));
            this.propertySet.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.formatService, (String)"groupDelimiter", (Object)XML_NON_BREAKING_SPACE));
            this.propertySet.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.formatService, (String)"minDigits", (Object)miniDigits));
            this.propertySet.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.formatService, (String)"groupSize", (Object)3));
            this.propertySet.addPropertyValue(this.formatService.createFormatPropertyValue("xml:lang", LocaleConverter.localeToStr((Locale)this.formatLocale)));
        }
        catch (Exception ex) {
            throw new CommonRuntimeException(CommonMessageKeys.GEN_INTERNAL_ERROR, ex, "convertPoundSpace");
        }
    }
}

