/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge.relmd;

import com.cognos.xqe.data.providers.secbridge.relmd.CAMImpersonate;
import com.cognos.xqe.data.providers.secbridge.relmd.NativeException;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CAMImpersonationTask<T>
implements Callable<T> {
    private static final long SSO_HANDLE_LOCK_TIMEOUT = 30000L;
    private static final int MAX_NUMBER_OF_LOCK = 16;
    private static final Lock[] SSO_HANDLE_STRIPES = new Lock[16];
    private final Callable<T> task;
    private final String ssoDelegationHandle;
    private final int errorLocale;

    public CAMImpersonationTask(Callable<T> theTask, String thessoDelegationHandle, int theErrorLocale) {
        this.task = theTask;
        this.ssoDelegationHandle = thessoDelegationHandle;
        this.errorLocale = theErrorLocale;
    }

    public static boolean lockDelegationHandle(String ssoHandle) {
        boolean isLocked;
        int lockIndex = Math.abs(ssoHandle.hashCode() % SSO_HANDLE_STRIPES.length);
        Lock lock = SSO_HANDLE_STRIPES[lockIndex];
        try {
            isLocked = lock.tryLock(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            CAMImpersonationTask.logException(CAMImpersonationTask.class, "Got exception " + ex.getMessage() + " trying to lock for SSO.", Level.SEVERE);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.INTERNAL_ERROR, ex);
        }
        if (!isLocked) {
            CAMImpersonationTask.logException(CAMImpersonationTask.class, "Timed out while waiting to acquire a lock before performing a CAM impersonation.", Level.WARNING);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.INTERNAL_ERROR);
        }
        return isLocked;
    }

    public static void unlockDelegationHandle(String ssoHandle) {
        int lockIndex = Math.abs(ssoHandle.hashCode() % SSO_HANDLE_STRIPES.length);
        Lock lock = SSO_HANDLE_STRIPES[lockIndex];
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        T result = null;
        if (CAMImpersonationTask.lockDelegationHandle(this.ssoDelegationHandle)) {
            try {
                try {
                    CAMImpersonate.beginImpersonation(this.errorLocale, this.ssoDelegationHandle);
                }
                catch (NativeException ex) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.CAM_COULD_NOT_IMPERSONATE, ex);
                }
                boolean success = false;
                try {
                    result = this.task.call();
                    success = true;
                }
                finally {
                    try {
                        CAMImpersonate.revertImpersonation(this.errorLocale, this.ssoDelegationHandle);
                    }
                    catch (NativeException ex) {
                        if (success) {
                            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.CAM_COULD_NOT_REVERT, ex);
                        }
                        CAMImpersonationTask.logException(CAMImpersonationTask.class, "Error occurs during reverting Impersonation: " + ex.getMessage(), Level.WARNING);
                    }
                }
            }
            finally {
                CAMImpersonationTask.unlockDelegationHandle(this.ssoDelegationHandle);
            }
        }
        return result;
    }

    private static void logException(Object obj, String s, Level level) {
        String loggingClassName = obj.getClass().getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            Logger logger = RelmdLoggerFactory.get(loggingClassName);
            logger.log(level, s);
            RelmdLoggerFactory.flush(logger);
        }
    }

    static {
        for (int i = 0; i < SSO_HANDLE_STRIPES.length; ++i) {
            CAMImpersonationTask.SSO_HANDLE_STRIPES[i] = new ReentrantLock();
        }
    }
}

