/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge.relmd;

import com.cognos.xqe.data.providers.secbridge.relmd.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.relmd.NativeException;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.utilities.SingletonHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SecBridge {
    private static final boolean WINDOWS_PLATFORM = System.getProperty("os.name").indexOf("Windows") >= 0;
    private static SingletonHelper<SecBridge> singletonHelper = new SingletonHelper<SecBridge>(){

        @Override
        protected SecBridge newInstance() {
            return new SecBridge();
        }

        @Override
        protected void initializeImpl(SecBridge theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(SecBridge theInstance) {
            theInstance.terminate();
        }
    };

    private SecBridge() {
    }

    public static SecBridge getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private void initialize() {
        if (WINDOWS_PLATFORM) {
            this.logException(this, "Loading SecBridge DLL.", Level.INFO);
            try {
                System.loadLibrary("SecBridge");
            }
            catch (Throwable ex) {
                this.logException(this, "Unexpected exception caught from System.loadLibrary(): " + ex.getMessage(), Level.SEVERE);
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.BRIDGE_INIT_ERROR);
            }
        } else {
            this.logException(this, "Non-windows plaform, windows security bridge DLL not loaded.", Level.SEVERE);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.UNSUPPORTED_PLATFORM);
        }
        try {
            this.logException(this, "Initializing JNI for SecBridge.", Level.INFO);
            SecBridge.cInitialize();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            this.logException(this, "An error was returned from SecBridge.cInitialize: " + status.toString(), Level.SEVERE);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.BRIDGE_INIT_ERROR, ex);
        }
        catch (Throwable ex) {
            this.logException(this, "Unexpected exception caught in SecBridge.cInitialize: " + ex.getMessage(), Level.SEVERE);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.BRIDGE_INIT_ERROR);
        }
    }

    private void terminate() {
        try {
            SecBridge.cTerminate();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            this.logException(this, "An error was returned from SecBridge.cTerminate: " + status.getMessage(), Level.SEVERE);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.BRIDGE_TERM_ERROR, ex);
        }
        catch (Throwable ex) {
            this.logException(this, "Unexpected exception caught in SecBridge.cTerminate: " + ex.getMessage(), Level.SEVERE);
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.BRIDGE_TERM_ERROR);
        }
    }

    String getCurrentUserName(int errMsgLocale) throws NativeException {
        return SecBridge.cGetCurrentUserName(errMsgLocale);
    }

    boolean canCurrentUserImpersonate(int errMsgLocale) throws NativeException {
        return SecBridge.cCanCurrentUserImpersonate(errMsgLocale);
    }

    long beginWinImpersonation(int errMsgLocale, String domain, String user, String password) throws NativeException {
        return SecBridge.cBeginImpersonation(errMsgLocale, domain, user, password);
    }

    void revertWinImpersonation(int errMsgLocale, long token) throws NativeException {
        SecBridge.cRevertImpersonation(errMsgLocale, token);
    }

    String impCAMUsrNegotiate(int errMsgLocale, String sSecurityBlob, String cryptoHandle) throws NativeException {
        return SecBridge.cCAMImpUsrNegotiate(errMsgLocale, sSecurityBlob, cryptoHandle);
    }

    void beginCAMImpersonation(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMBeginImpersonation(errMsgLocale, ssoDelegationHandle);
    }

    void revertCAMImpersonation(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMRevertImpersonation(errMsgLocale, ssoDelegationHandle);
    }

    void releaseCAMHandle(int errMsgLocale, String ssoDelegationHandle) throws NativeException {
        SecBridge.cCAMReleaseHandle(errMsgLocale, ssoDelegationHandle);
    }

    private static native void cInitialize() throws NativeException;

    private static native void cTerminate() throws NativeException;

    private static native String cGetCurrentUserName(int var0) throws NativeException;

    private static native boolean cCanCurrentUserImpersonate(int var0) throws NativeException;

    private static native long cBeginImpersonation(int var0, String var1, String var2, String var3) throws NativeException;

    private static native void cRevertImpersonation(int var0, long var1) throws NativeException;

    private static native String cCAMImpUsrNegotiate(int var0, String var1, String var2) throws NativeException;

    private static native void cCAMBeginImpersonation(int var0, String var1) throws NativeException;

    private static native void cCAMRevertImpersonation(int var0, String var1) throws NativeException;

    private static native void cCAMReleaseHandle(int var0, String var1) throws NativeException;

    private void logException(Object obj, String s, Level level) {
        String loggingClassName = obj.getClass().getSimpleName();
        boolean isTraceOn = RelmdLoggerFactory.isLoggingEnabled(loggingClassName);
        if (isTraceOn) {
            Logger logger = RelmdLoggerFactory.get(loggingClassName);
            logger.log(level, s);
            RelmdLoggerFactory.flush(logger);
        }
    }
}

