/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.secbridge.relmd;

import com.cognos.xqe.data.providers.secbridge.relmd.NativeException;
import com.cognos.xqe.data.providers.secbridge.relmd.SecBridge;

public final class WinImpersonate {
    private static final String ERRMSG_DOMAIN_WAS_NULL = "domain was null";
    private static final String ERRMSG_USER_WAS_NULL = "user was null";
    private static final String ERRMSG_PASSWORD_WAS_NULL = "password was null";

    private WinImpersonate() {
    }

    public static String getCurrentUserName(int errMsgLocale) throws NativeException {
        return SecBridge.getInstance().getCurrentUserName(errMsgLocale);
    }

    public static boolean canCurrentUserImpersonate(int errMsgLocale) throws NativeException {
        return SecBridge.getInstance().canCurrentUserImpersonate(errMsgLocale);
    }

    public static long beginImpersonation(int errMsgLocale, String domain, String user, String password) throws NativeException {
        if (null == domain) {
            throw new NullPointerException(ERRMSG_DOMAIN_WAS_NULL);
        }
        if (null == user) {
            throw new NullPointerException(ERRMSG_USER_WAS_NULL);
        }
        if (null == password) {
            throw new NullPointerException(ERRMSG_PASSWORD_WAS_NULL);
        }
        return SecBridge.getInstance().beginWinImpersonation(errMsgLocale, domain, user, password);
    }

    public static void revertImpersonation(int errMsgLocale, long token) throws NativeException {
        SecBridge.getInstance().revertWinImpersonation(errMsgLocale, token);
    }
}

