/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.Base64BinaryMIMEProp;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.pogo.async.AsyncServiceBase;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.ibm.cognos.internal.relmd.bibus.AxisTypesHelper;
import com.ibm.cognos.relmd.xmlapi.IWriteableAsXml;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.axis.encoding.Base64;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class AsyncResponseHelper {
    public static final String REQUEST_HEADERS = "request.headers";
    public static final String RESPONSE_ATTACHMENTS = "response.attachments";
    public static final String RESPONSE_BOUNDARY = "response.boundary";
    public static final String RESPONSE_ENVELOPE = "response.envelope";
    public static final String REQUEST_ENVELOPE = "request.envelope";
    private static final QName STATUS = DocumentHelper.createQName((String)"status");
    private static final String UNCOMPRESSED_HEADER = "Content-Type: application/xml\r\nContent-Id: relationalMetadataServiceResponseAttachment@ca.ibm.com\r\nContent-Length:-size-\r\nContent-Transfer-Encoding: 8bit\r\n\n";
    private static final String COMPRESSED_HEADER = "Content-Type: text/xml; charset=UTF-8\r\nContent-Encoding: gzip\r\nContent-Id: relationalMetadataServiceResponseAttachment@ca.ibm.com\r\nContent-Length:-size-\r\nContent-Transfer-Encoding: 8bit\r\n\n";

    public void writeResponse(MessageContext mc, AsynchReplyStatusEnum status, IWriteableAsXml apiResults) throws IOException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty(REQUEST_ENVELOPE);
        BIBusEnvelope mcResponseEnvelope = AsyncServiceBase.prepareSkeletalResponse((BIBusEnvelope)requestEnvelope, (MessageContext)mc, null);
        Element responseBodyElem = mcResponseEnvelope.getBody();
        QName responseQName = null;
        Element body = requestEnvelope.getBody();
        Iterator children = body.elementIterator();
        if (children.hasNext()) {
            Element child = (Element)children.next();
            responseQName = new QName(EAsyncCommand.runSpecification.toString() + "Response", child.getNamespace());
        }
        Element asynchResponseRootElem = responseBodyElem.addElement(responseQName);
        Element asynchResponseResultElem = AxisTypesHelper.addBIBusResponseElem(asynchResponseRootElem, "result", AxisTypesHelper.getOMClassTypeName(AsynchReply.class));
        Element statusElem = AxisTypesHelper.addBIBusResponseElem(asynchResponseResultElem, STATUS, "asynchReplyStatusEnum");
        statusElem.setText(status.getValue());
        mcResponseEnvelope.setConversationContextStatus(status.getValue());
        EncodingEnum encoding = AsyncResponseHelper.getAsyncRequestEncodingOption(requestEnvelope);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (encoding.equals((Object)EncodingEnum.MIME) || encoding.equals((Object)EncodingEnum.MIMECompressed)) {
            FilterOutputStream outStream = new BufferedOutputStream(baos);
            String header = null;
            if (encoding.equals((Object)EncodingEnum.MIMECompressed)) {
                outStream = new GZIPOutputStream(baos);
                header = COMPRESSED_HEADER;
            } else {
                outStream = new BufferedOutputStream(baos);
                header = UNCOMPRESSED_HEADER;
            }
            outStream = new BufferedOutputStream(outStream);
            apiResults.write("relmdApi.xsd", outStream);
            ((OutputStream)outStream).flush();
            ((OutputStream)outStream).close();
            int baosSize = baos.size();
            String baosSizeStr = String.valueOf(baosSize);
            header = header.replaceAll("-size-", baosSizeStr);
            byte[] headerBytes = header.getBytes();
            ByteArrayInputStream headerStream = new ByteArrayInputStream(headerBytes);
            byte[] baosBytes = baos.toByteArray();
            ByteArrayInputStream resultStream = new ByteArrayInputStream(baosBytes);
            SequenceInputStream sequenceStream = new SequenceInputStream(headerStream, resultStream);
            ArrayList<SequenceInputStream> attachmentList = new ArrayList<SequenceInputStream>(1);
            attachmentList.add(sequenceStream);
            mc.setProperty("multipart", (Object)Boolean.TRUE);
            mc.setProperty(RESPONSE_BOUNDARY, (Object)"###_MIME_BOUNDARY_###");
            mc.setProperty(RESPONSE_ATTACHMENTS, attachmentList.iterator());
        } else {
            Element detailsElem = AxisTypesHelper.addResponseElem(asynchResponseResultElem, "details", SOAPEnvelope.SOAP_ENC_ARRAY);
            detailsElem.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, AxisTypesHelper.getBIBusObjectTypeName(AxisTypesHelper.getOMClassTypeName(AsynchDetail.class) + "[1]"));
            Element itemElem = AxisTypesHelper.addBIBusResponseElem(detailsElem, "item", AxisTypesHelper.getOMClassTypeName(AsynchDetailMIMEAttachment.class));
            Element dataElem = AxisTypesHelper.addResponseElem(itemElem, "data", AxisTypesHelper.getXsdPropValueTypeName(Base64BinaryMIMEProp.class));
            apiResults.write("relmdApi.xsd", baos);
            baos.flush();
            baos.close();
            byte[] baosBytes = baos.toByteArray();
            String responseXmlEncoded = Base64.encode((byte[])baosBytes);
            dataElem.setText(responseXmlEncoded);
        }
        mc.setResponseName("response");
        mc.setProperty("response.status_code", (Object)"200");
        mc.setProperty(RESPONSE_ENVELOPE, (Object)mcResponseEnvelope);
    }

    private static EncodingEnum getAsyncRequestEncodingOption(BIBusEnvelope requestEnvelope) {
        Element optionsElem;
        EncodingEnum encodingOptionValue = null;
        Element requestBody = requestEnvelope.getBody();
        Element asyncCommandElem = null;
        Iterator childElemsIter = requestBody.elementIterator();
        if (childElemsIter.hasNext()) {
            asyncCommandElem = (Element)childElemsIter.next();
        }
        if (asyncCommandElem != null && (optionsElem = asyncCommandElem.element("options")) != null) {
            Element asynchOptionItemElem = null;
            List optionItemElems = optionsElem.elements("options");
            Iterator optionItemElemsIter = optionItemElems.iterator();
            while (asynchOptionItemElem == null && optionItemElemsIter.hasNext()) {
                Element optionItemElem = (Element)optionItemElemsIter.next();
                Element nameElem = optionItemElem.element("name");
                String name = nameElem.getText();
                if (!name.equals("attachmentEncoding")) continue;
                asynchOptionItemElem = optionItemElem;
            }
            if (asynchOptionItemElem != null) {
                Element valueElem = asynchOptionItemElem.element("value");
                encodingOptionValue = EncodingEnum.fromString((String)valueElem.getText());
            }
        }
        if (encodingOptionValue == null) {
            encodingOptionValue = EncodingEnum.base64;
        }
        return encodingOptionValue;
    }

    private static enum EAsyncCommand {
        runSpecification,
        wait,
        release,
        cancel;

    }
}

