/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.bibus.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.relmd.bibus.BuildVersionInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.dom4j.Element;

public final class RelmdLogger {
    private static LogTypedLogger MDSRV_AUDIT_USAGE_LOGGER = null;
    private static LogTypedLogger MDSRV_TRACE_LOGGER = null;
    private static RelmdLogger M_INSTANCE = null;
    private static boolean ERROR_ON_INIT = false;

    public static final RelmdLogger GetLogUtilInstance() {
        return M_INSTANCE;
    }

    private RelmdLogger() {
    }

    public void startMDSRVRequest(BIBusEnvelope request) {
        LogAuditIndication li2;
        LogAuditAccessIndication li = this.createLogAuditAccessIndication("Request", 30000, "", MDSRV_AUDIT_USAGE_LOGGER);
        if (li != null) {
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
        if ((li2 = this.createLogAuditIndication("Request", request, 20000, MDSRV_AUDIT_USAGE_LOGGER)) != null) {
            String requestBody = this.getSoapBody(request);
            this.setLogData(requestBody, li2);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li2);
        }
    }

    public void endMDSRVRequest(BIBusEnvelope response) {
        if (response == null) {
            return;
        }
        if (MDSRV_AUDIT_USAGE_LOGGER != null) {
            LogAuditIndication li2;
            String fault = response.getFaultCode();
            LogAuditAccessIndication li = this.createLogAuditAccessIndication("Response", 30000, fault != null ? "Failure" : "Success", MDSRV_AUDIT_USAGE_LOGGER);
            if (li != null) {
                this.populateRequestParameters((LogAuditIndication)li, response);
                MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
            }
            if ((li2 = this.createLogAuditIndication("Response", response, 20000, MDSRV_AUDIT_USAGE_LOGGER)) != null) {
                String responseBody = this.getSoapBody(response);
                this.setLogData(responseBody, li2);
                MDSRV_AUDIT_USAGE_LOGGER.log((Object)li2);
            }
        }
    }

    public void runtimeError(Throwable e, BIBusEnvelope envelope) {
        LogAuditAccessIndication li;
        if (MDSRV_AUDIT_USAGE_LOGGER != null && (li = this.createLogAuditAccessIndication("Execute", 50000, "Failure", MDSRV_AUDIT_USAGE_LOGGER)) != null) {
            StringBuffer errors = new StringBuffer();
            errors.append("<messages><message><messageString>");
            errors.append(e.getMessage());
            errors.append("</messageString></message></messages>");
            li.setErrorMessage(errors.toString());
            this.populateRequestParameters((LogAuditIndication)li, envelope);
            MDSRV_AUDIT_USAGE_LOGGER.log((Object)li);
        }
    }

    public boolean isMethodTraceEnabled() {
        return MDSRV_TRACE_LOGGER != null && MDSRV_TRACE_LOGGER.isEnabled(20000);
    }

    public void methodStart(String method) {
        if (MDSRV_TRACE_LOGGER != null) {
            LogTraceIndication li = this.createLogTraceIndication(20000, (byte)5, method);
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void methodEnd(String method) {
        LogTraceIndication li;
        if (MDSRV_TRACE_LOGGER != null && (li = this.createLogTraceIndication(20000, (byte)6, method)) != null) {
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void rethrownException(String message, Throwable th) {
        LogTraceIndication li;
        if (MDSRV_TRACE_LOGGER != null && (li = this.createLogTraceIndication(50000, (byte)11, "")) != null) {
            StringBuffer res = new StringBuffer();
            res.append("Unhandled exception being rethrown: " + message);
            res.append("\n");
            this.appendThrowable(res, th);
            li.setMessage(res.toString());
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void unexpectedHandledException(String message, Throwable th) {
        LogTraceIndication li;
        if (MDSRV_TRACE_LOGGER != null && (li = this.createLogTraceIndication(50000, (byte)11, "")) != null) {
            StringBuffer res = new StringBuffer();
            res.append(message);
            res.append("\n");
            this.appendThrowable(res, th);
            li.setMessage(res.toString());
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public void unexpectedSituation(String message) {
        if (MDSRV_TRACE_LOGGER != null) {
            LogTraceIndication li = this.createLogTraceIndication(40000, (byte)11, message);
            MDSRV_TRACE_LOGGER.log((Object)li);
        }
    }

    public boolean isTraceInformativeEnabled() {
        return MDSRV_TRACE_LOGGER != null && MDSRV_TRACE_LOGGER.isEnabled(10000);
    }

    public void traceInformative(String message) {
        LogTraceIndication li = this.createLogTraceIndication(10000, (byte)11, message);
        MDSRV_TRACE_LOGGER.log((Object)li);
    }

    public void logEnv() {
        if (this.isTraceInformativeEnabled()) {
            StringBuffer buf = new StringBuffer();
            String[] env = RelmdLogger.getEnv();
            if (env != null) {
                for (int i = 0; i < env.length; ++i) {
                    buf.append("ENV VAR: ");
                    buf.append(env[i]);
                }
                this.traceInformative(buf.toString());
            }
        }
    }

    private LogAuditAccessIndication createLogAuditAccessIndication(String operation, int level, String success, LogTypedLogger logger) {
        LogAuditAccessIndication ind = null;
        if (!ERROR_ON_INIT && logger.isEnabled(level)) {
            ind = new LogAuditAccessIndication("MDSRV", BuildVersionInfo.getBuildNumber());
            ind.setOperation(operation);
            ind.setLevel(level);
            ind.setStatus(success);
        }
        return ind;
    }

    private LogAuditIndication createLogAuditIndication(String operation, BIBusEnvelope envelope, int level, LogTypedLogger logger) {
        LogAuditIndication ind = null;
        if (!ERROR_ON_INIT && logger.isEnabled(level)) {
            ind = new LogAuditIndication("MDSRV", BuildVersionInfo.getBuildNumber());
            ind.setOperation(operation);
            ind.setLevel(level);
            this.populateRequestParameters(ind, envelope);
        }
        return ind;
    }

    private static String[] getEnv() {
        String[] env = null;
        Process nativeProcess = null;
        try {
            nativeProcess = System.getProperty("os.name").startsWith("Windows") ? Runtime.getRuntime().exec("set") : Runtime.getRuntime().exec("env");
        }
        catch (Exception e) {
            return env;
        }
        if (nativeProcess == null) {
            return env;
        }
        String[] env1 = new String[100];
        int size = 0;
        try {
            BufferedReader aReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
            try {
                String line;
                while ((line = aReader.readLine()) != null && line.length() != 0) {
                    env1[size++] = line;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            aReader.close();
            nativeProcess.getErrorStream().close();
            env = new String[size];
            for (int i = 0; i < size; ++i) {
                env[i] = env1[i];
            }
        }
        catch (Exception e) {
            return env;
        }
        return env;
    }

    private LogTraceIndication createLogTraceIndication(int level, byte action, String message) {
        LogTraceIndication ind = null;
        if (!ERROR_ON_INIT && MDSRV_TRACE_LOGGER != null && MDSRV_TRACE_LOGGER.isEnabled(level)) {
            ind = new LogTraceIndication("MDSRV", BuildVersionInfo.getBuildNumber());
            ind.setAction(action);
            ind.setLevel(level);
            ind.setMessage(message);
        }
        return ind;
    }

    private void appendThrowable(StringBuffer out, Throwable th) {
        StackTraceElement[] st = th.getStackTrace();
        out.append(th.getMessage());
        out.append("\n");
        for (int i = 0; i < st.length; ++i) {
            out.append(st[i].toString());
            out.append("\n");
        }
    }

    private String getSoapBody(BIBusEnvelope envelope) {
        Element body = envelope.getBody();
        if (body != null) {
            return body.asXML();
        }
        return "";
    }

    private void setLogData(String data, LogAuditIndication li) {
        if (data != null) {
            data = data.replaceAll("(\n|\r)", "");
            data = data.replaceAll("\t", " ");
        }
        li.setLogData(data);
    }

    private void populateRequestParameters(LogAuditIndication li, BIBusEnvelope requestEnvelope) {
        Element tracking = requestEnvelope.getTracking();
        if (tracking != null) {
            Element sessionContextElement;
            Element requestContextElement = tracking.element("requestContext");
            if (requestContextElement != null) {
                li.setRequestID(requestContextElement.getText());
            }
            if ((sessionContextElement = tracking.element("sessionContext")) != null) {
                li.setSessionID(sessionContextElement.getText());
            }
        }
    }

    static {
        try {
            M_INSTANCE = new RelmdLogger();
        }
        catch (Exception e) {
            ERROR_ON_INIT = true;
            e.printStackTrace();
        }
    }
}

