/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.dataSource;

import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.developer.schemas.bibus._3.DataSourceCommandBlock;
import com.cognos.developer.schemas.bibus._3.DataSourceCommandBlockProp;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.data.providers.secbridge.relmd.CAMImpersonate;
import com.cognos.xqe.data.providers.secbridge.relmd.LocaleConverter;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.logging.RelmdLoggerFactory;
import com.ibm.cognos.internal.relmd.dataSource.ApiTokenSignon;
import com.ibm.cognos.internal.relmd.dataSource.Commands;
import com.ibm.cognos.internal.relmd.dataSource.DataSourceConnectionCommandBlock;
import com.ibm.cognos.internal.relmd.dataSource.IDataSourceConnectionCommandBlock;
import com.ibm.cognos.internal.relmd.dataSource.JCAMImpersonator;
import com.ibm.cognos.internal.relmd.dataSource.OIDCCredentialsSignon;
import com.ibm.cognos.internal.relmd.dataSource.ValueDecryption;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.metadata.source.MetadataSourceToolkit;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnectionProxySignonParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnectionStringParameters;
import com.ibm.cognos.relmd.vendor.connection.ConnnectionSignonParameters;
import com.ibm.cognos.relmd.vendor.connection.ExtendedParameterLookup;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;

public class ConnectionParametersQuery
implements ConnectionParameters {
    private static final String IBMCOGNOS_AUTHENTICATION_JAVA_KRB5 = "ibmcognos.authentication=java_krb5";
    private static final String PART_NAME = "biBusHeader";
    private static final String NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    public static final String SESSION_SEARCHPATH = "~~";
    public static final String DEFAULTNAME_SEARCHPATH = "~";
    public static final String ADMINROOT_SEARCHPATH = "CAMID(\":\")";
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SINGLE_QUOTE = "'";
    private static final String INTEGRATED_SECURITY = "integratedSecurity=true";
    private static final String EXCEPTION = "exception";
    private static final String ERRORCODESTRING = "errorCodeString";
    private static final String PROMPT_INFO = "promptInfo";
    private static final String SECURITYBLOB = "securityBlob";
    private static final String JDBC_CONNECTION_STRING_PREFIX = "URL=jdbc:";
    protected static final String CAM_AUTH_NEGOTIATE = "camAuthNegotiate";
    private static final String ELEM_SQL = "sql";
    private static final String ELEM_ARGUMENTS = "arguments";
    private static final String ELEM_COMMANDS = "commands";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_NAME = "name";
    private static final String CONNECTION_STRING_PROPERTY = "connectionString";
    private static final String DISABLED_STRING_PROPERTY = "disabled";
    private static final String CMD_SESSION_START = "sessionStartCommand";
    private static final String CMD_SESSION_END = "sessionEndCommand";
    private static final String CMD_SQL = "sqlCommand";
    private ConnectionStringParameters m_connectionStringParser;
    private ConnnectionSignonParameters m_credentialsDecrypt;
    private ConnectionProxySignonParameters m_proxyCredentialsDecrypt;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private JCAMImpersonator.DelegatedCredential credential;
    private boolean m_isKerberos;
    private EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands;
    private Map<String, String> cookies = null;
    private String passport = null;
    private BiBusHeader biBusHeader = null;
    private String cPassportId = null;
    private boolean m_isIntegratedSecurity = false;
    private String m_contentLocale = null;
    private String m_productLocale = null;
    private String m_cryptoHandle = null;

    public ConnectionParametersQuery(MetadataSource dataSource, ContentManagerService_PortType port, ValueDecryption valueDecrypter) throws Exception {
        this(dataSource, port, valueDecrypter, new BiBusHeader());
    }

    public ConnectionParametersQuery(MetadataSource dataSource, ContentManagerService_PortType port, ValueDecryption valueDecrypter, BiBusHeader header) throws Exception {
        AnyTypeProp proxyCredentials;
        MetadataSourceToolkit dataSourceToolkit;
        this.biBusHeader = header;
        SearchPathMultipleObject sessionSearchPath = new SearchPathMultipleObject(SESSION_SEARCHPATH);
        Session session = (Session)port.query(sessionSearchPath, new PropEnum[]{PropEnum.userCapabilities}, null, null)[0];
        UserCapabilityEnum[] userCapabilities = session.getUserCapabilities().getValue();
        List<UserCapabilityEnum> userCapabilitiesList = Arrays.asList(userCapabilities);
        if (-1 == userCapabilitiesList.indexOf(UserCapabilityEnum.canImportRelationalMetadata)) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.insufficentCapabilities);
        }
        String dataSourceConnectionPath = this.buildDataSourceConnectionSearchPath(dataSource);
        DataSourceConnection dataSourceConnection = this.connectionQuery(dataSourceConnectionPath, port);
        this.commands = this.parseCommandBlocks(dataSourceConnection);
        StringProp cmDataSourceConnectionSearchPath = dataSourceConnection.getSearchPath();
        dataSourceConnectionPath = cmDataSourceConnectionSearchPath.getValue();
        StringProp dataSourceConnectionStringProp = dataSourceConnection.getConnectionString();
        String dataSourceConnectionString = dataSourceConnectionStringProp.getValue();
        String apiToken = null;
        if (dataSourceConnection.getApiToken() != null && dataSourceConnection.getApiToken().getValue() != null) {
            apiToken = dataSourceConnection.getApiToken().getValue();
        }
        if (dataSourceConnectionString.contains("#")) {
            dataSourceConnectionString = this.expandMacro(dataSourceConnectionString);
        }
        if (this.ifKerberosConnection(dataSource, port, header, dataSourceConnectionString, dataSourceToolkit = RelmdGateway.relmd().xmlApiToolkit().metadataSourceToolkit())) {
            return;
        }
        String encryptedCredentialsXml = null;
        Boolean hasEncryptedCredentialsXml = dataSource.hasEncryptedCredentialsXml();
        if (hasEncryptedCredentialsXml.booleanValue()) {
            encryptedCredentialsXml = dataSource.encryptedCredentialsXml();
        } else {
            String signonSearchPath = dataSourceConnectionPath + "/dataSourceSignon";
            Boolean hasDataSourceSignonName = dataSource.hasDataSourceSignonName();
            String dataSourceSignonName = dataSource.dataSourceSignonName();
            if (hasDataSourceSignonName.booleanValue()) {
                signonSearchPath = signonSearchPath + "[@name='" + dataSourceSignonName + "']";
            } else {
                String dataSourceName = dataSource.dataSourceName();
                signonSearchPath = "dataSourceSignon('" + dataSourceName + "')";
            }
            DataSourceSignon signon = this.signonQuery(signonSearchPath, port, dataSourceConnection, dataSourceSignonName);
            if (null != signon) {
                AnyTypeProp credentialsProp = signon.getCredentials();
                if (null == credentialsProp) {
                    throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.missingEncryptedSignonCredentials);
                }
                encryptedCredentialsXml = credentialsProp.getValue();
            }
        }
        if (encryptedCredentialsXml != null) {
            this.m_credentialsDecrypt = dataSourceToolkit.decryptCredentials(encryptedCredentialsXml, valueDecrypter);
        }
        if (apiToken != null) {
            this.m_credentialsDecrypt = dataSourceToolkit.decryptCredentials(apiToken, valueDecrypter);
        }
        if (this.isIntegratedSecurityConnection(dataSource, port, header, dataSourceConnectionString, dataSourceToolkit)) {
            return;
        }
        this.m_connectionStringParser = dataSourceToolkit.parseConnectionString(dataSourceConnectionString, this.biBusHeader, this.m_credentialsDecrypt);
        String proxySignonSearchPath = dataSourceConnectionPath + "/credential";
        Credential proxySignon = this.proxysignonQuery(proxySignonSearchPath = proxySignonSearchPath + "[@name='proxy']", port);
        if (proxySignon != null && (proxyCredentials = proxySignon.getCredentials()) != null) {
            this.m_proxyCredentialsDecrypt = dataSourceToolkit.decryptProxyCredentials(proxyCredentials.getValue(), valueDecrypter);
        }
    }

    private boolean isIntegratedSecurityConnection(MetadataSource dataSource, ContentManagerService_PortType port, BiBusHeader header, String dataSourceConnectionString, MetadataSourceToolkit dataSourceToolkit) {
        if (dataSourceConnectionString.contains(INTEGRATED_SECURITY)) {
            this.m_isIntegratedSecurity = true;
            this.retrieveLocaleFromUserPreferenceVars();
            this.retrieveCryptoHandleForIntegratedSecurity(dataSource, port, header);
            this.m_connectionStringParser = dataSourceToolkit.parseConnectionString(dataSourceConnectionString, this.biBusHeader, new ConnnectionSignonParameters(){

                @Override
                public String userName() {
                    if (ConnectionParametersQuery.this.m_credentialsDecrypt != null) {
                        return ConnectionParametersQuery.this.m_credentialsDecrypt.userName();
                    }
                    return null;
                }

                @Override
                public String password() {
                    if (ConnectionParametersQuery.this.m_credentialsDecrypt != null) {
                        return ConnectionParametersQuery.this.m_credentialsDecrypt.password();
                    }
                    return null;
                }

                @Override
                public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
                    return null;
                }

                @Override
                public boolean isKerberos() {
                    return false;
                }

                @Override
                public boolean isIntegratedSecurity() {
                    return true;
                }

                @Override
                public String getCryptoHandle() {
                    return ConnectionParametersQuery.this.m_cryptoHandle;
                }

                @Override
                public String getContentLocale() {
                    return ConnectionParametersQuery.this.m_contentLocale;
                }

                @Override
                public OIDCCredentialsSignon getOIDCCredentialsSignon() {
                    return null;
                }

                @Override
                public ApiTokenSignon getApiTokenSignon() {
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    private boolean ifKerberosConnection(MetadataSource dataSource, ContentManagerService_PortType port, BiBusHeader header, String dataSourceConnectionString, MetadataSourceToolkit dataSourceToolkit) {
        if (dataSourceConnectionString.contains(IBMCOGNOS_AUTHENTICATION_JAVA_KRB5)) {
            this.m_isKerberos = true;
            if (this.generateCredential(dataSource, port, header)) {
                this.m_connectionStringParser = dataSourceToolkit.parseConnectionString(dataSourceConnectionString, this.biBusHeader, new ConnnectionSignonParameters(){

                    @Override
                    public String userName() {
                        return null;
                    }

                    @Override
                    public String password() {
                        return null;
                    }

                    @Override
                    public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
                        return ConnectionParametersQuery.this.credential;
                    }

                    @Override
                    public boolean isKerberos() {
                        return true;
                    }

                    @Override
                    public boolean isIntegratedSecurity() {
                        return false;
                    }

                    @Override
                    public String getCryptoHandle() {
                        return null;
                    }

                    @Override
                    public String getContentLocale() {
                        return null;
                    }

                    @Override
                    public OIDCCredentialsSignon getOIDCCredentialsSignon() {
                        return null;
                    }

                    @Override
                    public ApiTokenSignon getApiTokenSignon() {
                        return null;
                    }
                });
                return true;
            }
        }
        return false;
    }

    private boolean generateCredential(MetadataSource dataSource, ContentManagerService_PortType port, BiBusHeader header) {
        String base64EncodedSecurityBlob = null;
        boolean isNegotiating = false;
        JCAMImpersonator impersonator = null;
        CAM cam = header.getCAM();
        do {
            SearchPathMultipleObject smo = new SearchPathMultipleObject("dataSourceSignon('" + dataSource.dataSourceName() + "')");
            PropEnum[] props = new PropEnum[]{PropEnum.credentials};
            if (base64EncodedSecurityBlob != null) {
                cam.setSecurityBlob(base64EncodedSecurityBlob.getBytes());
            }
            ((Stub)port).setHeader(NAMESPACE, PART_NAME, (Object)header);
            ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            try {
                port.query(smo, props, null, null);
                if (!isNegotiating) {
                    return false;
                }
                isNegotiating = false;
            }
            catch (Throwable e2) {
                Exception e2;
                isNegotiating = false;
                try {
                    BIBusEnvelope envelope = this.getBIBusEnvelope((Stub)port);
                    if (this.parseAuthException(envelope)) {
                        base64EncodedSecurityBlob = envelope.getCAM().element(EXCEPTION).element(PROMPT_INFO).element(SECURITYBLOB).getText();
                        if (impersonator == null) {
                            impersonator = new JCAMImpersonator();
                        }
                        base64EncodedSecurityBlob = impersonator.camImpUsrNegotiate(base64EncodedSecurityBlob);
                        isNegotiating = true;
                    }
                }
                catch (Exception ex) {
                    e2 = ex;
                }
                if (isNegotiating) continue;
                throw new RuntimeException(e2);
            }
        } while (isNegotiating);
        this.credential = impersonator.getDelegatedCredential();
        cam.setSecurityBlob(null);
        return true;
    }

    private String retrieveCryptoHandleForIntegratedSecurity(MetadataSource dataSource, ContentManagerService_PortType port, BiBusHeader header) {
        String tmpCryptoHandleId = null;
        String base64EncodedSecurityBlob = null;
        boolean isNegotiating = false;
        CAM cam = header.getCAM();
        do {
            SearchPathMultipleObject smo = new SearchPathMultipleObject("dataSourceSignon('" + dataSource.dataSourceName() + "')");
            PropEnum[] props = new PropEnum[]{PropEnum.credentials};
            if (base64EncodedSecurityBlob != null) {
                cam.setSecurityBlob(base64EncodedSecurityBlob.getBytes());
            }
            ((Stub)port).setHeader(NAMESPACE, PART_NAME, (Object)header);
            ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            try {
                port.query(smo, props, null, null);
                if (!isNegotiating) {
                    return null;
                }
                isNegotiating = false;
            }
            catch (Throwable e2) {
                Exception e2;
                isNegotiating = false;
                try {
                    BIBusEnvelope envelope = this.getBIBusEnvelope((Stub)port);
                    if (this.parseAuthException(envelope)) {
                        base64EncodedSecurityBlob = envelope.getCAM().element(EXCEPTION).element(PROMPT_INFO).element(SECURITYBLOB).getText();
                        String camSecBlobCryptoHandle = CAMImpersonate.camImpUsrNegotiate(LocaleConverter.strToLocale(this.m_productLocale), base64EncodedSecurityBlob, tmpCryptoHandleId);
                        int index = camSecBlobCryptoHandle.indexOf("<>");
                        if (index == -1 || camSecBlobCryptoHandle.length() <= index + 2) {
                            if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
                                Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
                                logger.log(Level.WARNING, "Unexpected exception occurred while parsing camSecBlobCryptoHandle");
                                RelmdLoggerFactory.flush(logger);
                            }
                            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.CAM_NEGOTIATION_FAILURE);
                        }
                        base64EncodedSecurityBlob = base64.encode((int)0, (byte[])camSecBlobCryptoHandle.substring(0, index).getBytes());
                        tmpCryptoHandleId = camSecBlobCryptoHandle.substring(index + 2);
                        isNegotiating = true;
                    }
                }
                catch (Exception ex) {
                    e2 = ex;
                }
                if (isNegotiating) continue;
                throw new RuntimeException(e2);
            }
        } while (isNegotiating);
        cam.setSecurityBlob(null);
        return tmpCryptoHandleId;
    }

    private boolean parseAuthException(BIBusEnvelope envelope) {
        Element camFault = envelope.getCAM();
        if (null != camFault && null != camFault.element(EXCEPTION) && null != camFault.element(EXCEPTION).element(ERRORCODESTRING) && null != camFault.element(EXCEPTION).element(ERRORCODESTRING).getText()) {
            return camFault.element(EXCEPTION).element(ERRORCODESTRING).getText().equalsIgnoreCase(CAM_AUTH_NEGOTIATE);
        }
        return false;
    }

    private BIBusEnvelope getBIBusEnvelope(Stub port) throws Exception {
        SOAPHeaderElement she = port.getResponseHeader(NAMESPACE, PART_NAME);
        if (she == null) {
            she = port.getHeader(NAMESPACE, PART_NAME);
        }
        BIBusEnvelope envelope = new BIBusEnvelope();
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(she.getAsDocument());
        envelope.setBIBusHeader(doc2.getRootElement());
        return envelope;
    }

    private DataSourceConnection connectionQuery(String dataSourceConnectionPath, ContentManagerService_PortType port) throws RemoteException, RelmdException {
        SearchPathMultipleObject dataSourceConnectionQuerySearchPath = new SearchPathMultipleObject(dataSourceConnectionPath);
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.objectClass, PropEnum.searchPath, PropEnum.connectionString, PropEnum.apiToken, PropEnum.disabled, PropEnum.storeID, PropEnum.parent, PropEnum.openConnectionCommands, PropEnum.closeConnectionCommands, PropEnum.openSessionCommands, PropEnum.closeSessionCommands};
        BaseClass[] results = port.query(dataSourceConnectionQuerySearchPath, props, null, null);
        if (results == null || 0 == results.length) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.dataSourceConnectionNotFound);
        }
        if (results.length == 1) {
            DataSourceConnection outConns = (DataSourceConnection)results[0];
            return outConns;
        }
        ArrayList<DataSourceConnection> listOfEnabledConnections = new ArrayList<DataSourceConnection>();
        for (int i = 0; i < results.length; ++i) {
            boolean bIsConnectionDisabled;
            DataSourceConnection connection = (DataSourceConnection)results[i];
            if (connection == null || connection.getDisabled() == null) continue;
            StringProp dataSourceConnectionStringProp = connection.getConnectionString();
            String dataSourceConnectionString = dataSourceConnectionStringProp.getValue();
            boolean isJDBCConnectionString = true;
            if (dataSourceConnectionString != null && dataSourceConnectionString.indexOf(JDBC_CONNECTION_STRING_PREFIX) == -1) {
                isJDBCConnectionString = false;
            }
            if ((bIsConnectionDisabled = connection.getDisabled().isValue()) || !isJDBCConnectionString) continue;
            listOfEnabledConnections.add(connection);
        }
        DataSourceConnection outConns = null;
        if (listOfEnabledConnections != null && listOfEnabledConnections.size() == 0) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.dataSourceConnectionNotFound);
        }
        if (listOfEnabledConnections == null || listOfEnabledConnections.size() != 1) {
            ArrayList<String> listOfConnectionStrings = new ArrayList<String>();
            for (int i = 0; i < listOfEnabledConnections.size(); ++i) {
                DataSourceConnection connection = (DataSourceConnection)listOfEnabledConnections.get(i);
                listOfConnectionStrings.add(connection.getConnectionString().getValue());
            }
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.ambiguousDataSourceConnections, listOfConnectionStrings);
        }
        outConns = (DataSourceConnection)listOfEnabledConnections.get(0);
        return outConns;
    }

    private String buildDataSourceConnectionSearchPath(MetadataSource dataSource) {
        String dataSourceName = dataSource.dataSourceName();
        String dataSourceConnectionPath = "CAMID(\":\")/dataSource[@name=";
        String readPermission = "[permission('read')]";
        dataSourceConnectionPath = dataSourceName.contains(SINGLE_QUOTE) ? dataSourceConnectionPath + DOUBLE_QUOTE + dataSourceName + DOUBLE_QUOTE + "]/dataSourceConnection" + readPermission : dataSourceConnectionPath + SINGLE_QUOTE + dataSourceName + SINGLE_QUOTE + "]/dataSourceConnection" + readPermission;
        if (dataSource.hasDataSourceConnectionName().booleanValue()) {
            dataSourceConnectionPath = dataSourceName.contains(SINGLE_QUOTE) ? dataSourceConnectionPath + "[@name=\"" + dataSource.dataSourceConnectionName() + DOUBLE_QUOTE + "]" + readPermission : dataSourceConnectionPath + "[@name='" + dataSource.dataSourceConnectionName() + SINGLE_QUOTE + "]" + readPermission;
        }
        return dataSourceConnectionPath;
    }

    public DataSourceSignon signonQuery(String signonSearchPath, ContentManagerService_PortType m_port, DataSourceConnection dataSourceConnection, String dataSourceSignonName) throws MalformedURLException, ServiceException, CCLConfigurationException, RemoteException {
        SearchPathMultipleObject smo = new SearchPathMultipleObject(signonSearchPath);
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.credentials, PropEnum.disabled, PropEnum.storeID, PropEnum.parent};
        BaseClass[] results = m_port.query(smo, props, null, null);
        Guid connectionID = dataSourceConnection.getStoreID().getValue();
        DataSourceSignon aSignon = null;
        ArrayList<DataSourceSignon> signons = new ArrayList<DataSourceSignon>();
        for (BaseClass obj : results) {
            if (!(obj instanceof DataSourceSignon) || !this.isEnabled(obj) || !this.hasName(obj, dataSourceSignonName) || !this.hasParent(obj, connectionID)) continue;
            signons.add((DataSourceSignon)obj);
        }
        if (signons.size() == 1) {
            aSignon = (DataSourceSignon)signons.get(0);
        } else if (signons.size() > 1) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.ambiguousDataSourceCredentials);
        }
        return aSignon;
    }

    private boolean isEnabled(BaseClass obj) {
        return !obj.getDisabled().isValue();
    }

    private boolean hasName(BaseClass obj, String name) {
        if (name == null) {
            return true;
        }
        return name.equals(obj.getDefaultName().getValue());
    }

    private boolean hasParent(BaseClass obj, Guid parentStoreID) {
        BaseClass parent = obj.getParent().getValue()[0];
        return parent.getStoreID().getValue().get_value().isEmpty() || parentStoreID.equals((Object)parent.getStoreID().getValue());
    }

    private Credential proxysignonQuery(String proxySignonSearchPath, ContentManagerService_PortType port) throws RemoteException {
        SearchPathMultipleObject smo = new SearchPathMultipleObject(proxySignonSearchPath);
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.credentials};
        BaseClass[] results = port.query(smo, props, null, null);
        Credential proxySignon = null;
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                BaseClass baseClass = results[i];
                if (!(baseClass instanceof Credential)) continue;
                proxySignon = (Credential)baseClass;
            }
        }
        return proxySignon;
    }

    @Override
    public String jdbcConnectionString() {
        return this.m_connectionStringParser.jdbcConnectionString();
    }

    @Override
    public Properties getProperties() {
        return this.m_connectionStringParser.getProperties();
    }

    @Override
    public String driverClass() {
        return this.m_connectionStringParser.driverClass();
    }

    @Override
    public String userName() {
        if (this.m_credentialsDecrypt != null) {
            return this.m_credentialsDecrypt.userName();
        }
        return null;
    }

    @Override
    public String password() {
        if (this.m_credentialsDecrypt != null) {
            return this.m_credentialsDecrypt.password();
        }
        return null;
    }

    @Override
    public String proxyUserName() {
        if (this.m_proxyCredentialsDecrypt == null) {
            return null;
        }
        return this.m_proxyCredentialsDecrypt.proxyUserName();
    }

    @Override
    public String proxyPassword() {
        if (this.m_proxyCredentialsDecrypt == null) {
            return null;
        }
        return this.m_proxyCredentialsDecrypt.proxyPassword();
    }

    @Override
    public Database.EVendorType vendorType() {
        return this.m_connectionStringParser.vendorType();
    }

    @Override
    public Database.EVendorType rawVendorType() {
        return this.m_connectionStringParser.rawVendorType();
    }

    @Override
    public String language() {
        return "en";
    }

    @Override
    public ExtendedParameterLookup extendedParameterLookup() {
        ExtendedParameterLookup extendedParameterLookup = new ExtendedParameterLookup(){

            @Override
            public Object parameter(String parameterName) {
                return null;
            }
        };
        return extendedParameterLookup;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    @Override
    public JCAMImpersonator.DelegatedCredential getDelegatedCredential() {
        return this.credential;
    }

    @Override
    public Database.ECatalogSupport catalogSupport() {
        return Database.ECatalogSupport.catalogsNotSupported;
    }

    @Override
    public boolean isKerberos() {
        return this.m_isKerberos;
    }

    @Override
    public boolean isIntegratedSecurity() {
        return this.m_isIntegratedSecurity;
    }

    @Override
    public String getCryptoHandle() {
        return this.m_cryptoHandle;
    }

    @Override
    public String getContentLocale() {
        return this.m_contentLocale;
    }

    @Override
    public EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands() {
        return this.commands;
    }

    private EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> parseCommandBlocks(DataSourceConnection dataSourceConnection) {
        DataSourceCommandBlock cmd;
        EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands = new EnumMap<Commands, List<IDataSourceConnectionCommandBlock>>(Commands.class);
        DataSourceCommandBlockProp cmdProp = dataSourceConnection.getOpenConnectionCommands();
        if (cmdProp != null && (cmd = cmdProp.getValue()) != null) {
            commands.put(Commands.CMD_OPEN_CONNECTION, this.parseCommandBlock(cmd.get_value()));
        }
        if ((cmdProp = dataSourceConnection.getOpenSessionCommands()) != null && (cmd = cmdProp.getValue()) != null) {
            commands.put(Commands.CMD_OPEN_SESSION, this.parseCommandBlock(cmd.get_value()));
        }
        if ((cmdProp = dataSourceConnection.getCloseConnectionCommands()) != null && (cmd = cmdProp.getValue()) != null) {
            commands.put(Commands.CMD_CLOSE_CONNECTION, this.parseCommandBlock(cmd.get_value()));
        }
        if ((cmdProp = dataSourceConnection.getCloseSessionCommands()) != null && (cmd = cmdProp.getValue()) != null) {
            commands.put(Commands.CMD_CLOSE_SESSION, this.parseCommandBlock(cmd.get_value()));
        }
        return commands;
    }

    private List<IDataSourceConnectionCommandBlock> parseCommandBlock(String input) {
        ArrayList<IDataSourceConnectionCommandBlock> commandBlocks = new ArrayList<IDataSourceConnectionCommandBlock>();
        SAXReader reader = new SAXReader();
        input = input.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        try {
            Document doc = reader.read((Reader)new StringReader(input));
            List commandElements = doc.getRootElement().element(ELEM_COMMANDS).elements();
            for (Element commandElement : commandElements) {
                DataSourceConnectionCommandBlock commandBlock = null;
                String comandName = commandElement.getName();
                HashMap<String, Object> commandProps = new HashMap<String, Object>();
                if (comandName.equals(CMD_SESSION_START) || comandName.equals(CMD_SESSION_END)) {
                    commandBlock = comandName.equals(CMD_SESSION_START) ? new DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND, commandProps) : new DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND, commandProps);
                    Element argumentsElement = commandElement.element(ELEM_ARGUMENTS);
                    if (argumentsElement != null) {
                        List arguments = argumentsElement.elements();
                        for (int j = 0; j < arguments.size(); ++j) {
                            Element argument = (Element)arguments.get(j);
                            Element nameElement = argument.element(ELEM_NAME);
                            if (nameElement == null) continue;
                            String nameStr = nameElement.getText();
                            String valueStr = null;
                            Element valueElement = argument.element(ELEM_VALUE);
                            if (valueElement == null) {
                                throw new RuntimeException("Missing Command Block Element:value");
                            }
                            valueStr = valueElement.getText();
                            if (valueStr.contains("#")) {
                                valueStr = this.expandMacro(valueStr);
                            }
                            if (nameStr.equals("OCI_ATTR_USERNAME")) {
                                commandProps.put("userName", valueStr);
                                continue;
                            }
                            if (!nameStr.equals("OCI_ATTR_PASSWORD")) continue;
                            commandProps.put(PASSWORD, valueStr);
                        }
                    }
                } else if (comandName.equals(CMD_SQL)) {
                    commandBlock = new DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND, commandProps);
                    Element sqlElement = commandElement.element(ELEM_SQL);
                    if (sqlElement != null) {
                        String sqlStr = sqlElement.getText();
                        if (sqlStr.contains("#")) {
                            sqlStr = this.expandMacro(sqlStr);
                        }
                        commandProps.put(ELEM_SQL, sqlStr);
                    } else {
                        throw new RuntimeException("Missing Command Block Element:value");
                    }
                }
                if (commandBlock == null) continue;
                commandBlocks.add(commandBlock);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse command block" + input, e);
        }
        return commandBlocks;
    }

    @Override
    public OIDCCredentialsSignon getOIDCCredentialsSignon() {
        if (this.m_credentialsDecrypt != null) {
            return this.m_credentialsDecrypt.getOIDCCredentialsSignon();
        }
        return null;
    }

    @Override
    public ApiTokenSignon getApiTokenSignon() {
        if (this.m_credentialsDecrypt != null) {
            return this.m_credentialsDecrypt.getApiTokenSignon();
        }
        return null;
    }

    public String expandMacro(String toExpandMacroString) throws Exception {
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("Before macro expand: toExpandMacroString is ");
            msgBuilder.append(toExpandMacroString);
            logger.info(msgBuilder.toString());
            RelmdLoggerFactory.flush(logger);
        }
        RESTClientConfig config = new RESTClientConfig("relmd");
        if (this.cookies == null) {
            this.getCookiesFromHdrSession();
        }
        if (this.cookies != null) {
            config.setRequestHeader("Cookie", this.cookies.toString());
        }
        if (this.passport == null) {
            this.generatePassportFromCAM();
        }
        if (this.passport != null) {
            config.setPassportCookie(this.passport);
        }
        JSONObject functionSpecJSON = new JSONObject();
        functionSpecJSON.put((Object)"moserFunctionType", (Object)"expandMacros");
        JSONArray macroJSONArray = new JSONArray();
        macroJSONArray.add((Object)toExpandMacroString);
        functionSpecJSON.put((Object)"expressions", (Object)macroJSONArray);
        String functionSpecJSONURLEncoded = URLEncoder.encode(functionSpecJSON.toString(), "UTF-8");
        String url = "/bi/v1/mosercommand?functionSpec=" + functionSpecJSONURLEncoded;
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("url is ");
            msgBuilder.append(url);
            logger.info(msgBuilder.toString());
            RelmdLoggerFactory.flush(logger);
        }
        RESTClient client = null;
        try {
            client = RESTClientFactory.getInstance().getClient(config);
        }
        catch (Exception e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.RESTClientFactoryGetClient, "Failed to create a RESTClient.");
        }
        int status = client.getResource(url);
        if (status != 200) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.expandMacroFailure, "Failed to expand a macro: " + toExpandMacroString + ". Status: " + status + ".");
        }
        JSONObject result = JSONObject.parse((InputStream)client.getResponseStream());
        JSONArray expandedMacros = (JSONArray)result.get((Object)"expandedMacros");
        if (RelmdLoggerFactory.isLoggingEnabled(this.getClass().getName())) {
            Logger logger = RelmdLoggerFactory.get(this.getClass().getName());
            String expandedMacroString = (String)((JSONObject)expandedMacros.get(0)).get((Object)"target");
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("after macro expand: toExpandMacroString is ");
            msgBuilder.append(expandedMacroString);
            logger.info(msgBuilder.toString());
            RelmdLoggerFactory.flush(logger);
        }
        return (String)((JSONObject)expandedMacros.get(0)).get((Object)"target");
    }

    public void getCookiesFromHdrSession() {
        CookieVar[] cVars;
        for (CookieVar var : cVars = this.biBusHeader.getHdrSession().getCookieVars()) {
            String nameStr = var.getName();
            String valueStr = var.getValue();
            if (this.cookies == null) {
                this.cookies = new TreeMap<String, String>();
            }
            this.cookies.put(nameStr, valueStr);
        }
    }

    public String generatePassportFromCAM() {
        CAMPassport cPassport;
        if (this.biBusHeader == null) {
            return null;
        }
        CAM cSecurity = this.biBusHeader.getCAM();
        if (cSecurity != null && null != (cPassport = cSecurity.getCAMPassport())) {
            int version = 1;
            this.cPassportId = cPassport.getId();
            boolean logEnabled = cPassport.isLogEnabled();
            int generation = cPassport.getGeneration();
            boolean canCallLogon = cPassport.isCanCallLogon();
            String separator = ";";
            String stringToCookie = String.valueOf(version) + separator + this.cPassportId + separator + String.valueOf(logEnabled ? 1 : 0) + separator + String.valueOf(generation) + separator + String.valueOf(canCallLogon ? 1 : 0) + separator;
            this.passport = CCLWeb64.encode((byte[])stringToCookie.getBytes());
        }
        return this.passport;
    }

    public void retrieveLocaleFromUserPreferenceVars() {
        UserPreferenceVar[] vars;
        for (UserPreferenceVar var : vars = this.biBusHeader.getUserPreferenceVars()) {
            String nameStr = var.getName();
            if (nameStr.equals("contentLocale")) {
                this.m_contentLocale = var.getValue();
                continue;
            }
            if (!nameStr.equals("productLocale")) continue;
            this.m_productLocale = var.getValue();
        }
    }
}

