/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.dataSource._tools;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class CAMCryptoProvider {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final CAMFactory CAM_FACTORY = new CAMFactory();
    private static final byte[] CAM_INITDOC = "<initializeDocument><serviceID>MFW</serviceID></initializeDocument>".getBytes();
    private static final String ERRMSG_NOT_INITIALIZED = "CryptoProvider hasn't been initialized.";

    private CAMCryptoProvider() {
    }

    public static void initialize() throws CAMCryptoException {
        if (INITIALIZED.compareAndSet(false, true)) {
            CAM_FACTORY.initialize(CAM_INITDOC);
        }
    }

    public static void terminate() throws CAMCryptoException {
        if (!INITIALIZED.get()) {
            throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
        }
        CAM_FACTORY.terminate();
    }

    public static byte[] encrypt(byte[] data) throws CAMCryptoException {
        if (INITIALIZED.get()) {
            return CAM_FACTORY.createEncryptingSession().encryptData(data);
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }

    public static byte[] decrypt(byte[] data) throws CAMCryptoException {
        if (INITIALIZED.get()) {
            return CAM_FACTORY.createEncryptingSession().decryptData(data);
        }
        throw new IllegalStateException(ERRMSG_NOT_INITIALIZED);
    }
}

