/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._schema;

import com.ibm.cognos.internal.relmd.metadata._schema.MetadataElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.relmd.metadata._schema.properties.Aliasable;
import com.ibm.cognos.relmd.metadata._schema.properties.DatabaseObject;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import java.util.ArrayList;
import java.util.Collection;
import org.dom4j.Element;

public abstract class ModelElement
extends RelmdElement
implements Referenceable,
DatabaseObject,
MetadataElement,
Aliasable,
Comparable<Object> {
    public static final String ATTRIBUTE_description = "description";
    public static final String ATTRIBUTE_NAME = "name";

    @Override
    public int compareTo(Object o) {
        String objectName = this.getObjectName();
        return objectName == null ? -1 : objectName.compareTo((String)o);
    }

    public ModelElement(String elemName) {
        this(elemName, new RelmdAttributeGroup());
    }

    public ModelElement(String elemName, XmlAttributeGroup attributes) {
        super(elemName, attributes);
    }

    public ModelElement(Element elem) {
        super(elem);
    }

    public ModelElement(String elemName, String objectDescription, String objectName, boolean bMandatoryName) {
        super(elemName);
        if (bMandatoryName && objectName != null) {
            this.addAttribute(ATTRIBUTE_NAME, objectName);
        } else {
            this.addOptionalAttribute(ATTRIBUTE_NAME, objectName);
        }
        this.addOptionalAttribute(ATTRIBUTE_description, objectDescription);
    }

    @Override
    public String objectName() {
        String objectName = this.attributeValue(ATTRIBUTE_NAME);
        if (objectName == null) {
            objectName = this.attributeValue("dataSourceName");
        }
        return objectName != null && objectName.length() == 0 ? null : objectName;
    }

    @Override
    public String description() {
        return this.attributeValue(ATTRIBUTE_description);
    }

    @Override
    public Collection<String> aliasCollection() {
        return new ArrayList<String>();
    }

    @Deprecated
    public final String getDescription() {
        return this.description();
    }

    @Deprecated
    public String getObjectName() {
        return this.objectName();
    }

    public final Collection<XmlElement> childElements() {
        Collection<MetadataElement> modelElems = this.childMetadataElements();
        ArrayList<XmlElement> childXmlElems = new ArrayList<XmlElement>(modelElems.size());
        for (MetadataElement childModelElement : modelElems) {
            childXmlElems.add(childModelElement.asXml());
        }
        return childXmlElems;
    }

    protected abstract Collection<MetadataElement> childMetadataElements();

    public int hashCode() {
        return this.objectName().hashCode();
    }

    public boolean equals(Object rhs) {
        boolean bEquals = false;
        if (rhs != null && rhs instanceof Referenceable) {
            String objectName = this.objectName();
            String ReferenceableObjectName = ((Referenceable)rhs).objectName();
            if (objectName != null && ReferenceableObjectName != null) {
                bEquals = objectName.equals(ReferenceableObjectName);
            }
        }
        return bEquals;
    }

    @Override
    public Collection<String> getAliasCollection() {
        return new ArrayList<String>();
    }
}

