/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._schema;

import com.ibm.cognos.internal.relmd.metadata._schema.CollectionAddDecorator;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ReferenceableSetElem<T extends Referenceable>
extends CollectionAddDecorator<T>
implements ReferenceableSet<T> {
    private SortedMap<String, Integer> m_map = new TreeMap<String, Integer>();

    public ReferenceableSetElem() {
        super(new ArrayList());
    }

    @Override
    public T find(String objectName) {
        Referenceable retVal = null;
        Integer objectPosition = (Integer)this.m_map.get(objectName);
        if (objectPosition != null) {
            Iterator sourceIter = super.iterator();
            for (int objectIdx = -1; sourceIter.hasNext() && objectPosition > objectIdx; ++objectIdx) {
                retVal = (Referenceable)sourceIter.next();
            }
        }
        return (T)retVal;
    }

    @Override
    public boolean add(T o) {
        String objectName = o.objectName();
        boolean badded = false;
        if (o.objectName() == null) {
            badded = true;
            super.add(o);
        } else {
            Integer foundIndex = (Integer)this.m_map.get(objectName);
            boolean bl = badded = foundIndex == null;
            if (badded) {
                super.add(o);
                this.m_map.put(objectName, super.size() - 1);
            }
        }
        return badded;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean bAdded = false;
        for (Referenceable currentObject : c) {
            if (!this.add((T)currentObject)) continue;
            bAdded = true;
        }
        return bAdded;
    }

    @Override
    public void clear() {
        this.m_map.clear();
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        this.m_map.remove(o);
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> cIter = c.iterator();
        while (cIter.hasNext()) {
            this.m_map.remove(cIter.next());
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Iterator<?> cIter = c.iterator();
        while (cIter.hasNext()) {
            this.remove(cIter.next());
        }
        return super.retainAll(c);
    }

    @Override
    public T find(Referenceable referenceable) {
        return referenceable == null ? null : (T)this.find(referenceable.objectName());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (String k : this.m_map.keySet()) {
            buffer.append(k);
            buffer.append(":");
            buffer.append(this.m_map.get(k));
        }
        buffer.append("}");
        return buffer.toString();
    }
}

