/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._schema;

import com.ibm.cognos.internal.relmd.metadata._schema.ModelElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.jdbc.adaptor.AdaptorJDBCTypes;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SqlColumnsIndexes;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import java.lang.reflect.Field;

public abstract class SqlColumnObjectElem
extends ModelElement
implements SqlColumn {
    public static final String ATTRIBUTE_datatype = "datatype";
    public static final String ATTRIBUTE_size = "size";
    public static final String ATTRIBUTE_precision = "precision";
    public static final String ATTRIBUTE_scale = "scale";
    public static final String ATTRIBUTE_isNullable = "isNullable";
    public static final String ATTRIBUTE_defaultValue = "defaultValue";
    public static final String ATTRIBUTE_collationSequence = "collationSequence";
    public static final String JDBC_SQLTYPES_DEFAULT_OTHER = "OTHER";
    private Database.EVendorType m_vendorType;
    protected static final String TRUE = "true";
    protected static final String TRUE_1 = "1";
    protected static final String TRUE_Y = "Y";
    protected static final String TRUE_YES = "YES";
    protected static final String FALSE = "false";

    @Override
    public SqlColumn.SourceType sourceType() {
        return SqlColumn.SourceType.frameworkManager;
    }

    public SqlColumnObjectElem(String elemName, SqlColumnsIndexes columnsRules, VendorAccessResultSetValues resultSetValueRetrieval, int nameResultSetColumnIndex, int descriptionResultSetColumnIndex, boolean bMandatoryName) {
        super(elemName, resultSetValueRetrieval.stringValue(descriptionResultSetColumnIndex), resultSetValueRetrieval.stringValue(nameResultSetColumnIndex), bMandatoryName);
        int collationSequenceRecordIndex;
        int datatypeRecordIndex = columnsRules.datatypeRecordIndex();
        this.addAttribute(ATTRIBUTE_datatype, resultSetValueRetrieval.stringValue(datatypeRecordIndex));
        int sizeRecordIndex = columnsRules.sizeRecordIndex();
        this.addOptionalAttribute(ATTRIBUTE_size, resultSetValueRetrieval.stringValue(sizeRecordIndex));
        int precisionRecordIndex = columnsRules.precisionRecordIndex();
        this.addOptionalAttribute(ATTRIBUTE_precision, resultSetValueRetrieval.stringValue(precisionRecordIndex));
        int scaleRecordIndex = columnsRules.scaleRecordIndex();
        this.addOptionalAttribute(ATTRIBUTE_scale, resultSetValueRetrieval.stringValue(scaleRecordIndex));
        int defaultValueRecordIndex = columnsRules.defaultValueRecordIndex();
        this.addOptionalAttribute(ATTRIBUTE_defaultValue, resultSetValueRetrieval.stringValue(defaultValueRecordIndex));
        int nullableFlagRecordIndex = columnsRules.nullableFlagRecordIndex();
        String isNullable = resultSetValueRetrieval.stringValue(nullableFlagRecordIndex);
        if (TRUE.equals(isNullable) || TRUE_1.equals(isNullable) || TRUE_Y.equals(isNullable) || TRUE_YES.equals(isNullable)) {
            this.addAttribute(ATTRIBUTE_isNullable, TRUE);
        }
        if (-1 != (collationSequenceRecordIndex = columnsRules.collationSequenceRecordIndex())) {
            this.addOptionalAttribute(ATTRIBUTE_collationSequence, resultSetValueRetrieval.stringValue(collationSequenceRecordIndex));
        }
    }

    public SqlColumnObjectElem(String elemName, SqlColumnsIndexes columnsRules, VendorAccessResultSetValues resultSetValueRetrieval, int nameResultSetColumnIndex, int descriptionResultSetColumnIndex, boolean bMandatoryName, Database.EVendorType vendorType) {
        super(elemName, resultSetValueRetrieval.stringValue(descriptionResultSetColumnIndex), resultSetValueRetrieval.stringValue(nameResultSetColumnIndex), bMandatoryName);
        int collationSequenceRecordIndex;
        int datatypeRecordIndex;
        int precisionRecordIndex = columnsRules.precisionRecordIndex();
        if (vendorType != null && vendorType.toString().indexOf("generic") != -1) {
            datatypeRecordIndex = columnsRules.datatypeRecordIndex();
            int dataType = resultSetValueRetrieval.intValue(datatypeRecordIndex);
            String jdbcSqlType = SqlColumnObjectElem.getJdbcSqlType(dataType);
            this.addAttribute(ATTRIBUTE_datatype, jdbcSqlType);
            switch (dataType) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.addOptionalAttribute(ATTRIBUTE_precision, resultSetValueRetrieval.stringValue(precisionRecordIndex));
                    int scaleRecordIndex = columnsRules.scaleRecordIndex();
                    this.addOptionalAttribute(ATTRIBUTE_scale, resultSetValueRetrieval.stringValue(scaleRecordIndex));
                    break;
                }
                case -1015: 
                case -1014: 
                case -1013: 
                case -1012: 
                case -1011: 
                case -1010: 
                case -1009: 
                case -1008: 
                case -1007: 
                case -1006: 
                case -1005: 
                case -1004: 
                case -1003: 
                case -1002: 
                case -15: 
                case -9: 
                case -4: 
                case -2: 
                case -1: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 1111: {
                    this.addOptionalAttribute(ATTRIBUTE_size, resultSetValueRetrieval.stringValue(precisionRecordIndex));
                    break;
                }
                case -1001: 
                case 93: {
                    this.addOptionalAttribute(ATTRIBUTE_size, resultSetValueRetrieval.stringValue(precisionRecordIndex));
                    int scaleRecordIndex = columnsRules.scaleRecordIndex();
                    this.addOptionalAttribute(ATTRIBUTE_scale, resultSetValueRetrieval.stringValue(scaleRecordIndex));
                    break;
                }
            }
        } else {
            datatypeRecordIndex = columnsRules.datatypeRecordIndex();
            this.addAttribute(ATTRIBUTE_datatype, resultSetValueRetrieval.stringValue(datatypeRecordIndex));
            int sizeRecordIndex = columnsRules.sizeRecordIndex();
            this.addOptionalAttribute(ATTRIBUTE_size, resultSetValueRetrieval.stringValue(sizeRecordIndex));
            this.addOptionalAttribute(ATTRIBUTE_precision, resultSetValueRetrieval.stringValue(precisionRecordIndex));
            int scaleRecordIndex = columnsRules.scaleRecordIndex();
            this.addOptionalAttribute(ATTRIBUTE_scale, resultSetValueRetrieval.stringValue(scaleRecordIndex));
        }
        int nullableFlagRecordIndex = columnsRules.nullableFlagRecordIndex();
        String isNullable = resultSetValueRetrieval.stringValue(nullableFlagRecordIndex);
        int defaultValueRecordIndex = columnsRules.defaultValueRecordIndex();
        String defaultValue = resultSetValueRetrieval.stringValue(defaultValueRecordIndex);
        this.addOptionalAttribute(ATTRIBUTE_defaultValue, defaultValue);
        if (TRUE.equals(isNullable) || TRUE_1.equals(isNullable) || TRUE_Y.equals(isNullable) || TRUE_YES.equals(isNullable)) {
            this.addAttribute(ATTRIBUTE_isNullable, TRUE);
        }
        if (-1 != (collationSequenceRecordIndex = columnsRules.collationSequenceRecordIndex())) {
            this.addOptionalAttribute(ATTRIBUTE_collationSequence, resultSetValueRetrieval.stringValue(collationSequenceRecordIndex));
        }
    }

    public SqlColumnObjectElem(String elemName, XmlAttributeGroup attributes) {
        super(elemName, attributes);
    }

    @Deprecated
    public String dataType() {
        return this.datatype();
    }

    @Override
    public String datatype() {
        return this.attributeValue(ATTRIBUTE_datatype);
    }

    @Override
    public Integer size() {
        return this.intAttributeValue(ATTRIBUTE_size);
    }

    @Override
    public Boolean hasSize() {
        return null != this.size();
    }

    @Override
    public Boolean hasPrecision() {
        return null != this.precision();
    }

    @Override
    public Integer precision() {
        return this.intAttributeValue(ATTRIBUTE_precision);
    }

    @Override
    public Integer scale() {
        return this.intAttributeValue(ATTRIBUTE_scale);
    }

    @Override
    public Boolean hasScale() {
        return null != this.scale();
    }

    @Override
    public Boolean hasDefaultValue() {
        return null != this.defaultValue();
    }

    @Override
    public String defaultValue() {
        return this.attributeValue(ATTRIBUTE_defaultValue);
    }

    @Override
    public Boolean hasIsNullable() {
        return null != this.isNullable();
    }

    @Override
    public Boolean isNullable() {
        return this.booleanAttributeValue(ATTRIBUTE_isNullable);
    }

    @Override
    public String collationSequence() {
        return this.attributeValue(ATTRIBUTE_collationSequence);
    }

    @Override
    public Boolean hasCollationSequence() {
        return null != this.collationSequence();
    }

    @Deprecated
    public String getDataType() {
        return this.dataType();
    }

    @Deprecated
    public String getDefaultValue() {
        return this.defaultValue();
    }

    @Deprecated
    public Integer getLength() {
        return this.size();
    }

    @Deprecated
    public Boolean getIsNullable() {
        return this.isNullable();
    }

    @Deprecated
    public String getCollationSequence() {
        return this.collationSequence();
    }

    @Deprecated
    public Integer getPrecision() {
        return this.precision();
    }

    @Deprecated
    public Integer getScale() {
        return this.scale();
    }

    protected Integer intAttributeValue(String attributeName) {
        String attributeValue = this.attributeValue(attributeName);
        return attributeValue == null ? null : Integer.valueOf(Integer.parseInt(attributeValue));
    }

    protected Boolean booleanAttributeValue(String attributeName) {
        String attributeValue = this.attributeValue(attributeName);
        return attributeValue == null ? null : Boolean.valueOf(Boolean.parseBoolean(attributeValue));
    }

    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    public static String getJdbcSqlType(int jdbcType) {
        String jdbcTypeName = JDBC_SQLTYPES_DEFAULT_OTHER;
        Field[] fields = AdaptorJDBCTypes.class.getFields();
        for (int index = 0; index < fields.length; ++index) {
            try {
                String name;
                Integer value = (Integer)fields[index].get(null);
                if (!value.equals(jdbcType)) continue;
                jdbcTypeName = name = fields[index].getName();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return jdbcTypeName;
    }
}

