/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.columnConversion;

import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;

public class Db2SqlColumnConversions
implements SqlColumnConversionRules {
    @Override
    public String mapDataType(SqlColumn nativeColumn) {
        String mappedType = FMColumnRule.FMDataType.unknown.toString();
        String datatype = nativeColumn.datatype();
        if ("BIGINT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int64.toString();
        } else if ("BLOB".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.blob.toString();
        } else if ("CHARACTER".equals(datatype) || "CHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.character.toString();
        } else if ("CLOB".equals(datatype) || "LONG VARCHAR".equals(datatype) || "XML".equals(datatype) || "DBCLOB".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.textBlob.toString();
        } else if ("DECIMAL".equals(datatype) || "NUMERIC".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        } else if ("DATE".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.date.toString();
        } else if ("FLOAT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float_.toString();
        } else if ("DOUBLE".equals(datatype) || "DECFLOAT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("REAL".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float32.toString();
        } else if ("INTEGER".equals(datatype) || "INT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int32.toString();
        } else if ("SMALLINT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int16.toString();
        } else if ("TIME".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.time.toString();
        } else if ("TIMESTAMP".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if ("VARCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if ("GRAPHIC".equals(datatype) || "NCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nChar.toString();
        } else if ("VARGRAPHIC".equals(datatype) || "LONG VARGRAPHIC".equals(datatype) || "NVARCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nVarChar.toString();
        } else if ("ROWID".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.binaryLength16.toString();
        } else if ("DISTINCT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.unknown.toString();
        } else if ("BINARY".equals(datatype) || "VARBINARY".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.binary.toString();
        } else if (datatype.endsWith("_DOLLAR")) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        }
        return mappedType;
    }

    @Override
    public Integer mapSize(SqlColumn nativeColumn) {
        Integer mappedLength = nativeColumn.size();
        String datatype = nativeColumn.datatype();
        if ("CHARACTER".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("GRAPHIC".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("VARCHAR".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("VARGRAPHIC".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : (mappedLength + 1) * 2;
        } else if ("DECIMAL".equals(datatype)) {
            mappedLength = mappedLength == null ? 0 : mappedLength / 2 + 1;
        } else if ("DECFLOAT".equals(datatype)) {
            mappedLength = 8;
        } else if ("LONG VARCHAR".equals(datatype)) {
            mappedLength = 4;
        } else if ("BLOB".equals(datatype)) {
            mappedLength = 4;
        } else if ("CLOB".equals(datatype)) {
            mappedLength = 4;
        } else if ("TIMESTAMP".equals(datatype)) {
            mappedLength = 12;
        } else if ("TIME".equals(datatype)) {
            mappedLength = 8;
        } else if ("XML".equals(datatype)) {
            mappedLength = 4;
        } else if (datatype.endsWith("_DOLLAR")) {
            mappedLength = 5;
        }
        return mappedLength;
    }

    @Override
    public Integer mapPrecision(SqlColumn nativeColumn) {
        Integer mappedPrecision = nativeColumn.size();
        String datatype = nativeColumn.datatype();
        if ("INTEGER".equals(datatype) || "TIMESTAMP".equals(datatype) || "SMALLINT".equals(datatype) || "BIGINT".equals(datatype) || "DOUBLE".equals(datatype) || "DATE".equals(datatype) || "BLOB".equals(datatype) || "CLOB".equals(datatype) || "LONG VARCHAR".equals(datatype) || "REAL".equals(datatype) || "DECFLOAT".equals(datatype) || "TIME".equals(datatype) || "XML".equals(datatype)) {
            mappedPrecision = 0;
        } else if (datatype.endsWith("_DOLLAR")) {
            mappedPrecision = 9;
        }
        return mappedPrecision;
    }

    @Override
    public Integer mapScale(SqlColumn nativeColumn) {
        Integer mappedScale = nativeColumn.scale();
        String datatype = nativeColumn.datatype();
        if ("TIMESTAMP".equals(datatype)) {
            mappedScale = 6;
        } else if (datatype.endsWith("_DOLLAR")) {
            mappedScale = 2;
        }
        return mappedScale;
    }
}

