/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.columnConversion;

import com.ibm.cognos.jdbc.adaptor.AdaptorJDBCTypes;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;
import java.lang.reflect.Field;

public class GenericSqlColumnsConversions
implements SqlColumnConversionRules {
    @Override
    public String mapDataType(SqlColumn nativeColumn) {
        String mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
        Integer scale = nativeColumn.scale();
        Integer precision = nativeColumn.precision();
        String strJdbcSqlType = nativeColumn.datatype().trim();
        int jdbcSqlType = this.getJdbcSqlType(strJdbcSqlType);
        switch (jdbcSqlType) {
            case 2003: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case -5: {
                mappedFMDataType = FMColumnRule.FMDataType.int64.toString();
                break;
            }
            case -2: {
                mappedFMDataType = FMColumnRule.FMDataType.binary.toString();
                break;
            }
            case -7: {
                mappedFMDataType = FMColumnRule.FMDataType.int16.toString();
                break;
            }
            case 2004: {
                mappedFMDataType = FMColumnRule.FMDataType.blob.toString();
                break;
            }
            case 16: {
                mappedFMDataType = FMColumnRule.FMDataType.boolean_.toString();
                break;
            }
            case 1: {
                mappedFMDataType = FMColumnRule.FMDataType.character.toString();
                break;
            }
            case 2005: {
                mappedFMDataType = FMColumnRule.FMDataType.textBlob.toString();
                break;
            }
            case 70: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case 91: {
                mappedFMDataType = FMColumnRule.FMDataType.date.toString();
                break;
            }
            case 3: {
                mappedFMDataType = FMColumnRule.FMDataType.decimal.toString();
                break;
            }
            case 2001: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case 8: {
                mappedFMDataType = FMColumnRule.FMDataType.float64.toString();
                break;
            }
            case 6: {
                mappedFMDataType = FMColumnRule.FMDataType.float64.toString();
                break;
            }
            case 4: {
                mappedFMDataType = FMColumnRule.FMDataType.int32.toString();
                break;
            }
            case 2000: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case -4: {
                mappedFMDataType = FMColumnRule.FMDataType.binaryLength16.toString();
                break;
            }
            case -1: {
                mappedFMDataType = FMColumnRule.FMDataType.characterLength16.toString();
                break;
            }
            case 0: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case 2: {
                if (scale != null && scale < 0 || precision != null && scale != null && precision < scale) {
                    mappedFMDataType = FMColumnRule.FMDataType.float64.toString();
                    break;
                }
                mappedFMDataType = FMColumnRule.FMDataType.decimal.toString();
                break;
            }
            case 1111: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case 7: {
                mappedFMDataType = FMColumnRule.FMDataType.float32.toString();
                break;
            }
            case 2006: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            case 5: {
                mappedFMDataType = FMColumnRule.FMDataType.int16.toString();
                break;
            }
            case 2002: {
                mappedFMDataType = FMColumnRule.FMDataType.character.toString();
                break;
            }
            case 92: {
                mappedFMDataType = FMColumnRule.FMDataType.time.toString();
                break;
            }
            case 93: {
                mappedFMDataType = FMColumnRule.FMDataType.dateTime.toString();
                break;
            }
            case -6: {
                mappedFMDataType = FMColumnRule.FMDataType.int16.toString();
                break;
            }
            case -3: {
                mappedFMDataType = FMColumnRule.FMDataType.binary.toString();
                break;
            }
            case 12: {
                mappedFMDataType = FMColumnRule.FMDataType.characterLength16.toString();
                break;
            }
            case -16: {
                mappedFMDataType = FMColumnRule.FMDataType.nVarChar.toString();
                break;
            }
            case -15: {
                mappedFMDataType = FMColumnRule.FMDataType.nChar.toString();
                break;
            }
            case 2011: {
                mappedFMDataType = FMColumnRule.FMDataType.textBlob.toString();
                break;
            }
            case -9: {
                mappedFMDataType = FMColumnRule.FMDataType.nVarChar.toString();
                break;
            }
            case -8: {
                mappedFMDataType = FMColumnRule.FMDataType.databaseKey.toString();
                break;
            }
            case 2009: {
                mappedFMDataType = FMColumnRule.FMDataType.textBlob.toString();
                break;
            }
            case -1001: {
                mappedFMDataType = FMColumnRule.FMDataType.timeStampTZ.toString();
                break;
            }
            case -1002: {
                mappedFMDataType = FMColumnRule.FMDataType.timeTZ.toString();
                break;
            }
            case -1003: {
                mappedFMDataType = FMColumnRule.FMDataType.intervalYM.toString();
                break;
            }
            case -1004: {
                mappedFMDataType = FMColumnRule.FMDataType.intervalYM.toString();
                break;
            }
            case -1005: {
                mappedFMDataType = FMColumnRule.FMDataType.intervalYM.toString();
                break;
            }
            case -1006: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1007: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1008: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1009: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1010: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1011: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1012: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1013: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1014: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1015: {
                mappedFMDataType = FMColumnRule.FMDataType.timeInterval.toString();
                break;
            }
            case -1020: 
            case -1019: 
            case -1018: 
            case -1017: 
            case -1016: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
                break;
            }
            default: {
                mappedFMDataType = FMColumnRule.FMDataType.unknown.toString();
            }
        }
        return mappedFMDataType;
    }

    @Override
    public Integer mapSize(SqlColumn nativeColumn) {
        Integer mappedFMLength = nativeColumn.size();
        if (mappedFMLength == null) {
            mappedFMLength = 0;
        }
        String strJdbcSqlType = nativeColumn.datatype();
        Integer precision = nativeColumn.precision();
        int jdbcSqlType = this.getJdbcSqlType(strJdbcSqlType);
        switch (jdbcSqlType) {
            case -6: 
            case 5: {
                mappedFMLength = 2;
                break;
            }
            case 4: {
                mappedFMLength = 4;
                break;
            }
            case -5: {
                mappedFMLength = 8;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                if (null == precision) break;
                mappedFMLength = precision / 2 + 1;
                break;
            }
            case -1020: 
            case -1018: 
            case -1002: 
            case -1001: 
            case -1: 
            case 1: 
            case 12: {
                mappedFMLength = (mappedFMLength + 1) * 2;
                break;
            }
            case 6: 
            case 91: 
            case 2004: 
            case 2005: {
                mappedFMLength = 4;
                break;
            }
            case 93: {
                mappedFMLength = 12;
            }
        }
        return mappedFMLength;
    }

    @Override
    public Integer mapPrecision(SqlColumn nativeColumn) {
        Integer mappedFMPrecision = nativeColumn.size();
        if (mappedFMPrecision == null) {
            mappedFMPrecision = 0;
        }
        String strJdbcSqlType = nativeColumn.datatype();
        int jdbcSqlType = this.getJdbcSqlType(strJdbcSqlType);
        switch (jdbcSqlType) {
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                mappedFMPrecision = nativeColumn.precision();
                break;
            }
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -3: 
            case -2: 
            case 4: 
            case 5: 
            case 7: 
            case 16: 
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2011: {
                mappedFMPrecision = 0;
            }
        }
        return mappedFMPrecision;
    }

    @Override
    public Integer mapScale(SqlColumn nativeColumn) {
        String strJdbcSqlType = nativeColumn.datatype();
        int jdbcSqlType = this.getJdbcSqlType(strJdbcSqlType);
        if (jdbcSqlType == 93) {
            return 6;
        }
        return nativeColumn.scale();
    }

    public int getJdbcSqlType(String jdbcType) {
        int jdbcSqlType = 0;
        Field[] fields = AdaptorJDBCTypes.class.getFields();
        for (int index = 0; index < fields.length; ++index) {
            try {
                String name = fields[index].getName();
                if (name.compareTo(jdbcType) != 0) continue;
                jdbcSqlType = (Integer)fields[index].get(null);
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return jdbcSqlType;
    }
}

