/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.columnConversion;

import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;

public class NetezzaSqlColumnConversions
implements SqlColumnConversionRules {
    @Override
    public String mapDataType(SqlColumn nativeColumn) {
        String mappedType = FMColumnRule.FMDataType.unknown.toString();
        String datatype = nativeColumn.datatype();
        if ("BIGINT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int64.toString();
        } else if ("CHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.character.toString();
        } else if ("DATE".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.date.toString();
        } else if ("DOUBLE".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float64.toString();
        } else if ("FLOAT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.float32.toString();
        } else if ("INTEGER".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int32.toString();
        } else if ("NCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nChar.toString();
        } else if ("NUMERIC".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.decimal.toString();
        } else if ("NVARCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.nVarChar.toString();
        } else if ("SMALLINT".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.int16.toString();
        } else if ("TIME".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.time.toString();
        } else if ("TIMESTAMP".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.dateTime.toString();
        } else if ("TIMETZ".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if ("VARCHAR".equals(datatype)) {
            mappedType = FMColumnRule.FMDataType.characterLength16.toString();
        }
        return mappedType;
    }

    @Override
    public Integer mapSize(SqlColumn nativeColumn) {
        Integer mappedLength = nativeColumn.size();
        String datatype = nativeColumn.datatype();
        if ("INTEGER".equals(datatype)) {
            mappedLength = 4;
        } else if ("DOUBLE".equals(datatype)) {
            mappedLength = 8;
        } else if ("BIGINT".equals(datatype)) {
            mappedLength = 8;
        } else if ("TIMESTAMP".equals(datatype)) {
            mappedLength = 12;
        } else if ("DATE".equals(datatype)) {
            mappedLength = 4;
        } else if ("TIME".equals(datatype)) {
            mappedLength = 8;
        } else if ("NUMERIC".equals(datatype)) {
            mappedLength = mappedLength / 2 + 1;
        } else if ("SMALLINT".equals(datatype)) {
            mappedLength = (mappedLength - 1) / 2;
        } else if ("VARCHAR".equals(datatype)) {
            mappedLength = (mappedLength + 1) * 2;
        } else if ("CHAR".equals(datatype)) {
            mappedLength = (mappedLength + 1) * 2;
        } else if ("NCHAR".equals(datatype)) {
            mappedLength = (mappedLength + 1) * 2;
        } else if ("NVARCHAR".equals(datatype)) {
            mappedLength = (mappedLength + 1) * 2;
        } else if ("FLOAT".equals(datatype)) {
            mappedLength = 4;
        } else if ("TIMETZ".equals(datatype)) {
            mappedLength = (mappedLength + 1) * 2;
        }
        return mappedLength;
    }

    @Override
    public Integer mapPrecision(SqlColumn nativeColumn) {
        Integer mappedPrecision = nativeColumn.precision();
        String datatype = nativeColumn.datatype();
        if ("INTEGER".equals(datatype) || "BIGINT".equals(datatype) || "DOUBLE".equals(datatype) || "FLOAT".equals(datatype) || "SMALLINT".equals(datatype) || "TIMESTAMP".equals(datatype) || "DATE".equals(datatype) || "TIME".equals(datatype)) {
            mappedPrecision = 0;
        } else if ("NUMERIC".equals(datatype) || "TIMETZ".equals(datatype) || "VARCHAR".equals(datatype) || "NVARCHAR".equals(datatype) || "CHAR".equals(datatype) || "NCHAR".equals(datatype)) {
            mappedPrecision = nativeColumn.size();
        }
        return mappedPrecision;
    }

    @Override
    public Integer mapScale(SqlColumn nativeColumn) {
        Integer mappedScale = nativeColumn.scale();
        String datatype = nativeColumn.datatype();
        if ("INTEGER".equals(datatype)) {
            mappedScale = 0;
        } else if ("BIGINT".equals(datatype)) {
            mappedScale = 0;
        } else if ("TIME".equals(datatype)) {
            mappedScale = 0;
        } else if ("TIMETZ".equals(datatype)) {
            mappedScale = 0;
        }
        return mappedScale;
    }
}

