/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.columnConversion;

import com.ibm.cognos.relmd.metadata._schema.properties.SqlColumn;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.FMColumnRule;
import com.ibm.cognos.relmd.metadata._tools.sqlColumnConversions.rules.SqlColumnConversionRules;

public class TeradataSqlColumnConversions
implements SqlColumnConversionRules {
    @Override
    public String mapDataType(SqlColumn nativeColumn) {
        String datatype = nativeColumn.datatype().trim();
        String mappedDataType = FMColumnRule.FMDataType.unknown.toString();
        Integer scale = nativeColumn.scale();
        Integer precision = nativeColumn.precision();
        if (datatype.matches("I 99:.*")) {
            mappedDataType = FMColumnRule.FMDataType.time.toString();
        } else if (datatype.equals("I") || datatype.matches("I .*")) {
            mappedDataType = FMColumnRule.FMDataType.int32.toString();
        } else if (datatype.equals("I1") || datatype.matches("I1 .*")) {
            mappedDataType = FMColumnRule.FMDataType.int16.toString();
        } else if (datatype.equals("I2") || datatype.matches("I2 .*")) {
            mappedDataType = FMColumnRule.FMDataType.int16.toString();
        } else if (datatype.equals("I8") || datatype.matches("I8 .*")) {
            mappedDataType = FMColumnRule.FMDataType.int64.toString();
        } else if (datatype.equals("CF 1 X(23)")) {
            mappedDataType = FMColumnRule.FMDataType.nChar.toString();
        } else if (datatype.equals("CF") || datatype.matches("CF .*")) {
            mappedDataType = FMColumnRule.FMDataType.character.toString();
        } else if (datatype.matches("CV 4 .*") || datatype.matches("CF 4 .*")) {
            mappedDataType = FMColumnRule.FMDataType.characterLength16.toString();
        } else if (datatype.equals("CV") || datatype.matches("CV .*")) {
            Integer length = nativeColumn.size();
            mappedDataType = null != length && length == 64000 ? FMColumnRule.FMDataType.textBlob.toString() : FMColumnRule.FMDataType.characterLength16.toString();
        } else if (datatype.equals("D") || datatype.matches("D .*")) {
            mappedDataType = FMColumnRule.FMDataType.decimal.toString();
        } else if (datatype.equals("N FN9")) {
            mappedDataType = precision <= 38 && scale >= 0 && scale <= 38 && scale < precision ? FMColumnRule.FMDataType.decimal.toString() : FMColumnRule.FMDataType.float64.toString();
        } else if (datatype.equals("F") || datatype.matches("F .*")) {
            mappedDataType = FMColumnRule.FMDataType.float64.toString();
        } else if (datatype.equals("AT") || datatype.matches("AT .*")) {
            mappedDataType = FMColumnRule.FMDataType.time.toString();
        } else if (datatype.equals("DA") || datatype.matches("DA .*")) {
            mappedDataType = FMColumnRule.FMDataType.date.toString();
        } else if (datatype.equals("DH") || datatype.matches("DH .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("SZ") || datatype.matches("SZ .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeStampTZ.toString();
        } else if (datatype.equals("TS") || datatype.matches("TS .*")) {
            mappedDataType = FMColumnRule.FMDataType.dateTime.toString();
        } else if (datatype.equals("TZ") || datatype.matches("TZ .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeTZ.toString();
        } else if (datatype.equals("DM") || datatype.matches("DM .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("DS") || datatype.matches("DS .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("DY") || datatype.matches("DY .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("HM") || datatype.matches("HM .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("HR") || datatype.matches("HR .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("HS") || datatype.matches("HS .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("MI") || datatype.matches("MI .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("MS") || datatype.matches("MS .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("SC") || datatype.matches("SC .*")) {
            mappedDataType = FMColumnRule.FMDataType.timeInterval.toString();
        } else if (datatype.equals("MO") || datatype.matches("MO .*")) {
            mappedDataType = FMColumnRule.FMDataType.intervalYM.toString();
        } else if (datatype.equals("YM") || datatype.matches("YM .*")) {
            mappedDataType = FMColumnRule.FMDataType.intervalYM.toString();
        } else if (datatype.equals("YR") || datatype.matches("YR .*")) {
            mappedDataType = FMColumnRule.FMDataType.intervalYM.toString();
        } else if (datatype.equals("BF") || datatype.matches("BF .*")) {
            mappedDataType = FMColumnRule.FMDataType.binary.toString();
        } else if (datatype.equals("BO") || datatype.matches("BO .*")) {
            mappedDataType = FMColumnRule.FMDataType.blob.toString();
        } else if (datatype.equals("BV") || datatype.matches("BV .*")) {
            mappedDataType = FMColumnRule.FMDataType.binaryLength16.toString();
        } else if (datatype.equals("CO") || datatype.matches("CO .*")) {
            mappedDataType = FMColumnRule.FMDataType.textBlob.toString();
        } else if (datatype.equals("GF") || datatype.matches("GF .*")) {
            mappedDataType = FMColumnRule.FMDataType.binary.toString();
        } else if (datatype.equals("GV") || datatype.matches("GV .*")) {
            mappedDataType = FMColumnRule.FMDataType.binaryLength16.toString();
        } else if (datatype.equals("XM") || datatype.matches("XM .*")) {
            mappedDataType = FMColumnRule.FMDataType.xml.toString();
        }
        return mappedDataType;
    }

    @Override
    public Integer mapSize(SqlColumn nativeColumn) {
        Integer length = nativeColumn.size();
        String datatype = nativeColumn.datatype().trim();
        if (datatype.matches("CV 4 .*") || datatype.matches("CF 4 .*")) {
            length = 2;
        } else if (datatype.equals("CV") || datatype.matches("CV .*")) {
            length = null == length ? 0 : (64000 == length ? 4 : (length + 1) * 2);
        } else if (datatype.matches("I 99:99.*")) {
            length = 8;
        } else if (datatype.equals("I") || datatype.matches("I .*")) {
            length = 4;
        } else if (datatype.equals("I1") || datatype.matches("I1 .*")) {
            length = 2;
        } else if (datatype.equals("I2") || datatype.matches("I2 .*")) {
            length = 2;
        } else if (datatype.equals("I8") || datatype.matches("I8 .*")) {
            length = 8;
        } else if (datatype.equals("F") || datatype.matches("F .*")) {
            length = 8;
        } else if (datatype.equals("DA") || datatype.matches("DA .*")) {
            length = 4;
        } else if (datatype.equals("CF 1 X(23)")) {
            length = 48;
        } else if (datatype.equals("CF") || datatype.matches("CF .*")) {
            length = null == length ? 0 : (length + 1) * 2;
        } else if (datatype.equals("BV") || datatype.matches("BV .*")) {
            length = null == length ? 0 : length + 2;
        } else if (datatype.equals("D") || datatype.matches("D .*")) {
            length = null == length ? 0 : length / 2 + 1;
        } else if (datatype.equals("TS") || datatype.matches("TS .*")) {
            length = 12;
        } else if (datatype.equals("AT") || datatype.matches("AT .*")) {
            length = 8;
        } else if (datatype.equals("TZ") || datatype.matches("TZ .*")) {
            length = 8;
        } else if (datatype.equals("SZ") || datatype.matches("SZ .*")) {
            length = 12;
        } else if (datatype.equals("YR") || datatype.matches("YR .*")) {
            length = 12;
        } else if (datatype.equals("YM") || datatype.matches("YM .*")) {
            length = 12;
        } else if (datatype.equals("MO") || datatype.matches("MO .*")) {
            length = 12;
        } else if (datatype.equals("DY") || datatype.matches("DY .*")) {
            length = 24;
        } else if (datatype.equals("DH") || datatype.matches("DH .*")) {
            length = 24;
        } else if (datatype.equals("DM") || datatype.matches("DM .*")) {
            length = 24;
        } else if (datatype.equals("DS") || datatype.matches("DS .*")) {
            length = 24;
        } else if (datatype.equals("HR") || datatype.matches("HR .*")) {
            length = 24;
        } else if (datatype.equals("HM") || datatype.matches("HM .*")) {
            length = 24;
        } else if (datatype.equals("HS") || datatype.matches("HS .*")) {
            length = 24;
        } else if (datatype.equals("MI") || datatype.matches("MI .*")) {
            length = 24;
        } else if (datatype.equals("MS") || datatype.matches("MS .*")) {
            length = 24;
        } else if (datatype.equals("SC") || datatype.matches("SC .*")) {
            length = 24;
        } else if (datatype.equals("CO") || datatype.matches("CO .*")) {
            length = 4;
        } else if (datatype.equals("BO") || datatype.matches("BO .*")) {
            length = 4;
        } else if (datatype.equals("XM") || datatype.matches("XM .*")) {
            length = 4;
        }
        return length;
    }

    @Override
    public Integer mapPrecision(SqlColumn nativeColumn) {
        Integer mappedPrecision = nativeColumn.precision();
        String datatype = nativeColumn.datatype().trim();
        Integer length = nativeColumn.size();
        if (datatype.matches("CV 4 .*") || datatype.matches("CF 4 .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("CF 1 X(23)")) {
            mappedPrecision = 23;
        } else if (datatype.equals("CV") || datatype.matches("CV .*") && null != length) {
            mappedPrecision = 64000 == length ? 0 : length;
        } else if (datatype.equals("I") || datatype.matches("I .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("D") || datatype.matches("D .*")) {
            mappedPrecision = null == nativeColumn.size() ? 0 : nativeColumn.size();
        } else if (datatype.equals("I1") || datatype.matches("I1 .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("I2") || datatype.matches("I2 .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("I8") || datatype.matches("I8 .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("F") || datatype.matches("F .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("DA") || datatype.matches("DA .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("TS") || datatype.matches("TS .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("AT") || datatype.matches("AT .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("TZ") || datatype.matches("TZ .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("SZ") || datatype.matches("SZ .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("CF") || datatype.matches("CF .*")) {
            mappedPrecision = length;
        } else if (datatype.equals("BF") || datatype.matches("BF .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("BV") || datatype.matches("BV .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("YR") || datatype.matches("YR .*")) {
            mappedPrecision = 32;
        } else if (datatype.equals("YM") || datatype.matches("YM .*")) {
            mappedPrecision = 48;
        } else if (datatype.equals("MO") || datatype.matches("MO .*")) {
            mappedPrecision = 16;
        } else if (datatype.equals("DY") || datatype.matches("DY .*")) {
            mappedPrecision = 8;
        } else if (datatype.equals("DH") || datatype.matches("DH .*")) {
            mappedPrecision = 12;
        } else if (datatype.equals("DM") || datatype.matches("DM .*")) {
            mappedPrecision = 14;
        } else if (datatype.equals("DS") || datatype.matches("DS .*")) {
            mappedPrecision = 15;
        } else if (datatype.equals("HR") || datatype.matches("HR .*")) {
            mappedPrecision = 4;
        } else if (datatype.equals("HM") || datatype.matches("HM .*")) {
            mappedPrecision = 6;
        } else if (datatype.equals("HS") || datatype.matches("HS .*")) {
            mappedPrecision = 7;
        } else if (datatype.equals("MI") || datatype.matches("MI .*")) {
            mappedPrecision = 2;
        } else if (datatype.equals("MS") || datatype.matches("MS .*")) {
            mappedPrecision = 3;
        } else if (datatype.equals("SC") || datatype.matches("SC .*")) {
            mappedPrecision = 1;
        } else if (datatype.equals("CO") || datatype.matches("CO .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("BO") || datatype.matches("BO .*")) {
            mappedPrecision = 0;
        } else if (datatype.equals("XM") || datatype.matches("XM .*")) {
            mappedPrecision = 0;
        }
        return mappedPrecision;
    }

    @Override
    public Integer mapScale(SqlColumn nativeColumn) {
        Integer mappedScale = nativeColumn.scale();
        String datatype = nativeColumn.datatype().trim();
        if (datatype.equals("CV") || datatype.matches("CV .*")) {
            mappedScale = 0;
        } else if (datatype.equals("CF 1 X(23)")) {
            mappedScale = 0;
        } else if (datatype.equals("I") || datatype.matches("I .*")) {
            mappedScale = 0;
        } else if (datatype.equals("I1") || datatype.matches("I1 .*")) {
            mappedScale = 0;
        } else if (datatype.equals("I2") || datatype.matches("I2 .*")) {
            mappedScale = 0;
        } else if (datatype.equals("I8") || datatype.matches("I8 .*")) {
            mappedScale = 0;
        } else if (datatype.equals("F") || datatype.matches("F .*")) {
            mappedScale = 0;
        } else if (datatype.equals("DA") || datatype.matches("DA .*")) {
            mappedScale = 0;
        } else if (datatype.equals("AT") || datatype.matches("AT .*")) {
            mappedScale = 0;
        } else if (datatype.equals("TZ") || datatype.matches("TZ .*")) {
            mappedScale = 0;
        } else if (datatype.equals("CF") || datatype.matches("CF .*")) {
            mappedScale = 0;
        } else if (datatype.equals("BF") || datatype.matches("BF .*")) {
            mappedScale = 0;
        } else if (datatype.equals("BV") || datatype.matches("BV .*")) {
            mappedScale = 0;
        } else if (datatype.equals("YR") || datatype.matches("YR .*")) {
            mappedScale = 0;
        } else if (datatype.equals("YM") || datatype.matches("YM .*")) {
            mappedScale = 0;
        } else if (datatype.equals("MO") || datatype.matches("MO .*")) {
            mappedScale = 0;
        } else if (datatype.equals("DY") || datatype.matches("DY .*")) {
            mappedScale = 0;
        } else if (datatype.equals("DH") || datatype.matches("DH .*")) {
            mappedScale = 0;
        } else if (datatype.equals("DM") || datatype.matches("DM .*")) {
            mappedScale = 0;
        } else if (datatype.equals("HR") || datatype.matches("HR .*")) {
            mappedScale = 0;
        } else if (datatype.equals("HM") || datatype.matches("HM .*")) {
            mappedScale = 0;
        } else if (datatype.equals("MI") || datatype.matches("MI .*")) {
            mappedScale = 0;
        } else if (datatype.equals("CO") || datatype.matches("CO .*")) {
            mappedScale = 0;
        } else if (datatype.equals("BO") || datatype.matches("BO .*")) {
            mappedScale = 0;
        } else if (datatype.equals("XM") || datatype.matches("XM .*")) {
            mappedScale = 0;
        }
        return mappedScale;
    }
}

