/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.xml;

import com.ibm.cognos.relmd.metadata.Metadata;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.StoredProcedure;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.UserDefinedFunction;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.MetadataObjectHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._schema.properties.SchemaParent;
import com.ibm.cognos.relmd.metadata._tools.xml.MergeSource;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import java.util.Collection;

public class MergeUtil
implements MetadataObjectHandler {
    private Metadata m_sourceMetadata;
    private Database m_currentSourceDatabase;
    private SchemaParent m_currentSourceSchemaParent;
    private Schema m_currentSourceSchema;
    private final MetadataObjectHandler m_objectHandler;

    public MergeUtil(MergeSource mergee, MetadataObjectHandler objectHandler) {
        this.m_sourceMetadata = mergee.metadata();
        this.m_objectHandler = objectHandler;
    }

    public Metadata getNewModel() {
        return this.m_sourceMetadata;
    }

    public void handleSummary(ImportSummary summary) {
    }

    @Override
    public void handleMetadata(Metadata model) {
        this.m_objectHandler.handleMetadata(model);
    }

    @Override
    public void handleDatabase(Database database) {
        this.flushSourceDatabase();
        String dataSource = database.dataSourceName();
        Collection<Database> databaseCollection = this.m_sourceMetadata.databaseCollection();
        for (Database sourceDatabase : databaseCollection) {
            String sourceDataSource = sourceDatabase.dataSourceName();
            if (this.m_currentSourceSchemaParent != null || !sourceDataSource.equalsIgnoreCase(dataSource)) continue;
            this.m_currentSourceSchemaParent = sourceDatabase;
            this.m_currentSourceDatabase = sourceDatabase;
            databaseCollection.remove(this.m_currentSourceDatabase);
        }
        this.m_objectHandler.handleDatabase(database);
    }

    @Override
    public void handleCatalog(Catalog catalog) {
        this.flushSourceSchemaParent();
        if (this.m_currentSourceDatabase != null) {
            this.m_currentSourceSchemaParent = this.m_currentSourceDatabase.catalogsSet().find(catalog);
        }
        this.m_objectHandler.handleCatalog(catalog);
    }

    @Override
    public void handleSchema(Schema schema) {
        this.flushSourceSchema();
        if (this.m_currentSourceSchemaParent != null) {
            this.m_currentSourceSchema = this.m_currentSourceSchemaParent.schemasSet().find(schema);
        }
        this.m_objectHandler.handleSchema(schema);
    }

    @Override
    public void handleTable(Table table) {
        Table mergedTable = this.m_currentSourceSchema == null ? table : this.resolveSchemaLevelObject(table, this.m_currentSourceSchema.tablesSet());
        this.m_objectHandler.handleTable(mergedTable);
    }

    @Override
    public void handleView(View view) {
        View mergedView = this.m_currentSourceSchema == null ? view : this.resolveSchemaLevelObject(view, this.m_currentSourceSchema.viewsSet());
        this.m_objectHandler.handleView(mergedView);
    }

    @Override
    public void handleSynonym(Synonym synonym) {
        Synonym mergedObj = this.m_currentSourceSchema == null ? synonym : this.resolveSchemaLevelObject(synonym, this.m_currentSourceSchema.synonymsSet());
        this.m_objectHandler.handleSynonym(mergedObj);
    }

    @Override
    public void handleStoredProcedure(StoredProcedure storedProcedure) {
        StoredProcedure mergedObj = this.m_currentSourceSchema == null ? storedProcedure : this.resolveSchemaLevelObject(storedProcedure, this.m_currentSourceSchema.storedProcedureSet());
        this.m_objectHandler.handleStoredProcedure(mergedObj);
    }

    @Override
    public void handleUserDefinedFunction(UserDefinedFunction userDefinedFunction) {
        UserDefinedFunction mergedObj = this.m_currentSourceSchema == null ? userDefinedFunction : this.resolveSchemaLevelObject(userDefinedFunction, this.m_currentSourceSchema.userDefinedFunctionSet());
        this.m_objectHandler.handleUserDefinedFunction(mergedObj);
    }

    private <T extends Referenceable> T resolveSchemaLevelObject(T object, ReferenceableSet<T> sourceObjectCollection) {
        T foundSourceObj = sourceObjectCollection.find(object);
        if (foundSourceObj != null) {
            sourceObjectCollection.remove(foundSourceObj);
        }
        return foundSourceObj == null ? object : foundSourceObj;
    }

    private void flushSourceDatabase() {
        if (this.m_currentSourceDatabase != null) {
            this.flushSourceSchemaParent();
            for (Catalog sourceCatalog : this.m_currentSourceDatabase.catalogsSet()) {
                this.m_objectHandler.handleCatalog(sourceCatalog);
            }
            for (Schema sourceSchema : this.m_currentSourceDatabase.schemasSet()) {
                this.m_objectHandler.handleSchema(sourceSchema);
            }
        }
        this.m_currentSourceDatabase = null;
    }

    private void flushSourceSchemaParent() {
        if (this.m_currentSourceSchemaParent != null) {
            this.flushSourceSchema();
            for (Schema sourceSchema : this.m_currentSourceSchemaParent.schemasSet()) {
                this.m_objectHandler.handleSchema(sourceSchema);
            }
        }
        this.m_currentSourceSchemaParent = null;
    }

    private void flushSourceSchema() {
        if (this.m_currentSourceSchema != null) {
            this.flushTables(this.m_currentSourceSchema.tablesSet());
            this.flushViews(this.m_currentSourceSchema.viewsSet());
            this.flushSynonyms(this.m_currentSourceSchema.synonymsSet());
            this.flushStoredProcedures(this.m_currentSourceSchema.storedProcedureSet());
            this.flushUserDefinedFunctions(this.m_currentSourceSchema.userDefinedFunctionSet());
            this.m_currentSourceSchemaParent.schemasSet().remove(this.m_currentSourceSchema);
        }
        this.m_currentSourceSchema = null;
    }

    private void flushStoredProcedures(ReferenceableSet<StoredProcedure> storedProcedureCollection) {
        for (StoredProcedure storedProcedure : storedProcedureCollection) {
            this.m_objectHandler.handleStoredProcedure(storedProcedure);
        }
        storedProcedureCollection.clear();
    }

    private void flushUserDefinedFunctions(ReferenceableSet<UserDefinedFunction> userDefinedFunctionCollection) {
        for (UserDefinedFunction userDefinedFunction : userDefinedFunctionCollection) {
            this.m_objectHandler.handleUserDefinedFunction(userDefinedFunction);
        }
        userDefinedFunctionCollection.clear();
    }

    private void flushSynonyms(ReferenceableSet<Synonym> synonymCollection) {
        for (Synonym sourceSynonym : synonymCollection) {
            this.m_objectHandler.handleSynonym(sourceSynonym);
        }
        synonymCollection.clear();
    }

    private void flushViews(ReferenceableSet<View> viewCollection) {
        for (View sourceView : viewCollection) {
            this.m_objectHandler.handleView(sourceView);
        }
        viewCollection.clear();
    }

    private void flushTables(ReferenceableSet<Table> tableCollection) {
        for (Table sourceTable : tableCollection) {
            this.m_objectHandler.handleTable(sourceTable);
        }
        tableCollection.clear();
    }

    private void flushSourceModel() {
        this.flushSourceDatabase();
        Collection<Database> sourceDatabaseCollection = this.m_sourceMetadata.databaseCollection();
        for (Database sourceDatabase : sourceDatabaseCollection) {
            this.m_objectHandler.handleDatabase(sourceDatabase);
        }
        sourceDatabaseCollection.clear();
    }

    @Override
    public void done() {
        this.flushSourceModel();
    }
}

