/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata._tools.xml;

import com.ibm.cognos.internal.relmd.metadata._schema.CatalogElem;
import com.ibm.cognos.internal.relmd.metadata._schema.SchemaElem;
import com.ibm.cognos.relmd.metadata.Metadata;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.StoredProcedure;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.UserDefinedFunction;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.Argument;
import com.ibm.cognos.relmd.metadata._schema.elements.Column;
import com.ibm.cognos.relmd.metadata._schema.elements.ForeignKey;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.elements.NestedArgument;
import com.ibm.cognos.relmd.metadata._schema.elements.Signature;
import com.ibm.cognos.relmd.metadata._schema.elements.TableParameter;
import com.ibm.cognos.relmd.metadata._schema.elements.UniqueKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainer;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._schema.properties.Routine;
import com.ibm.cognos.relmd.metadata._schema.properties.RoutineArgumentBase;
import com.ibm.cognos.relmd.metadata._schema.properties.SchemaParent;
import com.ibm.cognos.relmd.metadata._tools.xml.ImportResultsMetadataBuilder;
import com.ibm.cognos.relmd.metadata._tools.xml.MergeSource;
import com.ibm.cognos.relmd.metadata._tools.xml.MetadataLoader;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.results.ImportMetadataResultHandler;

public class ModelBuilder
implements ImportMetadataResultHandler,
MetadataLoader,
MergeSource,
ImportResultsMetadataBuilder,
MetadataElementHandler {
    private Metadata m_model;
    private SchemaParent m_schemaParent;
    private Schema m_schema;
    private Database m_database;
    private ColumnContainer m_columnsContainer;
    private Table m_table;
    private Routine m_routine;
    private Signature m_routineSignature;
    private RoutineArgumentBase m_nestedRoutineArgumentParent;

    @Override
    public Metadata metadata() {
        return this.m_model;
    }

    @Override
    public void handleMetadata(Metadata model) {
        this.m_model = model;
    }

    @Override
    public void handleDatabase(Database database) {
        this.m_model.databaseCollection().add(database);
        this.m_schemaParent = database;
        this.m_database = database;
    }

    @Override
    public void handleTable(Table table) {
        ReferenceableSet<Table> tables = this.m_schema.tablesSet();
        tables.add(table);
        this.m_table = table;
        this.m_columnsContainer = table;
    }

    @Override
    public void handleView(View view) {
        ReferenceableSet<View> views = this.m_schema.viewsSet();
        views.add(view);
        this.m_columnsContainer = view;
    }

    @Override
    public void handleStoredProcedure(StoredProcedure storedProcedure) {
        ReferenceableSet<StoredProcedure> storedProcedures = this.m_schema.storedProcedureSet();
        storedProcedures.add(storedProcedure);
    }

    @Override
    public void handleUserDefinedFunction(UserDefinedFunction userDefinedFunction) {
        ReferenceableSet<UserDefinedFunction> userDefinedFunctions = this.m_schema.userDefinedFunctionSet();
        userDefinedFunctions.add(userDefinedFunction);
    }

    @Override
    public void handleSynonym(Synonym synonym) {
        ReferenceableSet<Synonym> synonyms = this.m_schema.synonymsSet();
        synonyms.add(synonym);
    }

    public ColumnContainer getCurrentColumnsContainer() {
        return this.m_columnsContainer;
    }

    @Override
    public void handleColumn(Column column) {
        if (null != this.m_columnsContainer) {
            this.m_columnsContainer.columnsSet().add(column);
        }
    }

    @Override
    public void handleTableParameter(TableParameter param) {
        if (null != this.m_columnsContainer) {
            this.m_columnsContainer.tableParametersSet().add(param);
        }
    }

    @Override
    public void handleUniqueKey(UniqueKey uniqueKey) {
        if (null != this.m_table) {
            this.m_table.uniqueKeysSet().add(uniqueKey);
        }
    }

    @Override
    public void handleIndex(Index index) {
        if (null != this.m_table) {
            this.m_table.indexesCollection().add(index);
        }
    }

    @Override
    public void handleForeignKey(ForeignKey foreignKey) {
        if (null != this.m_table) {
            this.m_table.foreignKeysCollection().add(foreignKey);
        }
    }

    @Override
    public void handleNestedRoutineArgument(NestedArgument nestedRoutineArgument) {
        if (this.m_nestedRoutineArgumentParent != null) {
            this.m_nestedRoutineArgumentParent.nestedArgumentsCollection().add(nestedRoutineArgument);
            this.m_nestedRoutineArgumentParent = nestedRoutineArgument;
        }
    }

    @Override
    public void handleRoutineArgument(Argument routineArgument) {
        if (this.m_routine != null) {
            this.m_routineSignature.routineArgumentsCollection().add(routineArgument);
            this.m_nestedRoutineArgumentParent = routineArgument;
        }
    }

    @Override
    public void handleRoutineSignature(Signature routineSignature) {
        if (this.m_routine != null) {
            this.m_routine.routineSignaturesCollection().add(routineSignature);
            this.m_nestedRoutineArgumentParent = null;
            this.m_routineSignature = routineSignature;
        }
    }

    @Override
    public void handleCatalog(Catalog catalog) {
        ReferenceableSet<Catalog> catalogCollection = this.m_database.catalogsSet();
        Catalog existingCatalog = catalogCollection.find(catalog.objectName());
        if (existingCatalog != null) {
            this.m_schemaParent = existingCatalog;
        } else {
            catalogCollection.add(catalog);
            this.m_schemaParent = catalog;
        }
    }

    @Override
    public void handleSchema(Schema schema) {
        ReferenceableSet<Schema> schemaCollection = this.m_schemaParent.schemasSet();
        Schema existingSchema = schemaCollection.find(schema.objectName());
        if (existingSchema != null) {
            this.m_schema = existingSchema;
        } else {
            schemaCollection.add(schema);
            this.m_schema = schema;
        }
    }

    @Override
    public void handleParentCatalogReference(String catalogName) {
        ReferenceableSet<Catalog> catalogCollection = this.m_database.catalogsSet();
        Catalog existingCatalog = catalogCollection.find(catalogName);
        if (existingCatalog != null) {
            this.m_schemaParent = existingCatalog;
        } else {
            CatalogElem catalog = new CatalogElem(catalogName, "");
            catalogCollection.add(catalog);
            this.m_schemaParent = catalog;
        }
    }

    @Override
    public void handleParentSchemaReference(String schemaName) {
        ReferenceableSet<Schema> schemaCollection = this.m_schemaParent.schemasSet();
        Schema existingSchema2 = schemaCollection.find(schemaName);
        if (schemaName.equals("")) {
            for (Schema existingSchema2 : schemaCollection) {
            }
        }
        if (existingSchema2 != null) {
            this.m_schema = existingSchema2;
        } else {
            SchemaElem schema = new SchemaElem(schemaName);
            schemaCollection.add(schema);
            this.m_schema = schema;
        }
    }

    @Override
    public void handleParentTableViewReference(String parentTableViewName) {
        ReferenceableSet<Table> tables = this.m_schema.tablesSet();
        Table table = tables.find(parentTableViewName);
        if (table != null) {
            this.m_table = table;
            this.m_columnsContainer = table;
        } else {
            ReferenceableSet<View> views = this.m_schema.viewsSet();
            View view = views.find(parentTableViewName);
            this.m_columnsContainer = view != null ? view : null;
        }
    }

    @Override
    public void handleParentTableReference(String parentTableName) {
        if (null != this.m_schema) {
            ReferenceableSet<Table> tables = this.m_schema.tablesSet();
            Table table = tables.find(parentTableName);
            if (table != null) {
                this.m_table = table;
                this.m_columnsContainer = table;
            } else {
                this.m_table = null;
                this.m_columnsContainer = null;
            }
        }
    }

    @Override
    public void handleParentRoutineReference(String parentRoutineName) {
        ReferenceableSet<UserDefinedFunction> userDefinedFunctions;
        UserDefinedFunction userDefinedFunction;
        Routine routine;
        ReferenceableSet<StoredProcedure> tables = this.m_schema.storedProcedureSet();
        this.m_routine = routine = (Routine)tables.find(parentRoutineName);
        if (this.m_routine == null && (userDefinedFunction = (userDefinedFunctions = this.m_schema.userDefinedFunctionSet()).find(parentRoutineName)) != null) {
            this.m_routine = userDefinedFunction;
        }
    }

    @Override
    public void handleSummary(ImportSummary summary) {
    }

    @Override
    public void done() {
    }

    @Override
    public Table getParentTable() {
        return this.m_table;
    }
}

