/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.FunctionElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.FunctionHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.FunctionsImport;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.rules.FunctionsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllFunctionsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.FunctionSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class FunctionsImportElem
extends ExtractionElement
implements VendorAccessResultSetHandler,
I_ChildElementHandler,
FunctionsImport {
    private FunctionsImportRules m_functionsImportRules = null;
    private FunctionHandler m_functionHandler = null;
    private FunctionElem m_function = null;
    private VendorAccessResultSet m_resultSet = null;
    private SessionAccess m_sessionAccess;
    private SessionAccessToolkit m_sessionAccessToolkit;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private MetadataImportSelectionsChoice m_objectSelectionsChoice;
    private ExtractionSummary m_importSummary;
    private boolean m_applyQualifierList = false;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public FunctionsImportElem(SessionAccess sessionAccess) {
        super(ImportMetadataFunction.EImportFunctionType.importFunctions);
        Relmd relmd = RelmdGateway.relmd();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        this.m_sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccess;
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_objectSelectionsChoice = null;
        this.m_importSummary = null;
    }

    public FunctionsImportElem() {
        this((SessionAccess)null);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, FunctionsImportRules functionsImportRules, MetadataObjectSelections objectSelections, FunctionHandler functionHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_resultSet = null;
        this.m_functionHandler = functionHandler;
        this.m_functionsImportRules = functionsImportRules;
        this.m_sessionAccess = this.m_sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_objectSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        VendorAccess m_extractionQuery = this.m_functionsImportRules.extractionQuery();
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (parentCatalogSchemaHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)this.m_functionsImportRules, parentCatalogSchemaHandler, (I_ChildElementHandler)this);
        }
        this.m_importSummary = new ExtractionSummary(this.getClass().getName());
        this.m_importSummary.start();
        if (this.m_vendorType != null && this.m_vendorType.toString().indexOf("generic") != -1) {
            Connection jdbcConnection = relmdConnection.jdbcConnection();
            this.runFunctionsImportGeneric(jdbcConnection, resultSetSchemaLocator);
            long rowsProcessed = this.m_importSummary.rowsProcessed();
            this.m_importSummary.functionsCount(rowsProcessed);
            return this.m_importSummary;
        }
        this.m_resultSet = m_extractionQuery.run(relmdConnection, objectSelections, this.m_functionsImportRules.objectSelectionsInclusionCollection());
        if (null != this.m_resultSet) {
            VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
            while (resultSetIterator.next()) {
                VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
                this.m_importSummary.incrementRowCount();
                if (resultSetSchemaLocator != null) {
                    resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
                }
                this.handleResultSetRecord(resultSetValueRetrieval);
            }
        }
        this.done();
        long rowsProcessed = this.m_importSummary.rowsProcessed();
        this.m_importSummary.functionsCount(rowsProcessed);
        this.m_importSummary.stop();
        return this.m_importSummary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        ImportSummary summary = this.run(relmdConnection, metadataImportRules.functionsImportRules(), objectSelections, modelElementHandler, modelElementHandler);
        return summary;
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        int nameRecordIndex = this.m_functionsImportRules.nameRecordIndex();
        String functionName = resultSetValueRetrieval.stringValue(nameRecordIndex);
        if (functionName.equals("<") || functionName.equals("<=") || functionName.equals("<>") || functionName.equals("=") || functionName.equals(">") || functionName.equals(">=")) {
            return;
        }
        if (this.m_function == null || !this.m_function.objectName().equals(functionName)) {
            this.m_function = new FunctionElem("userDefinedFunction", functionName, this.m_functionsImportRules, resultSetValueRetrieval);
            this.m_functionHandler.handleUserDefinedFunction(this.m_function);
        }
    }

    public void handleResultSetRecord(String desc, String functionName) {
        if (functionName.equals("<") || functionName.equals("<=") || functionName.equals("<>") || functionName.equals("=") || functionName.equals(">") || functionName.equals(">=")) {
            return;
        }
        if (this.m_function == null || !this.m_function.objectName().equals(functionName)) {
            this.m_function = new FunctionElem("userDefinedFunction", desc, functionName);
            this.m_functionHandler.handleUserDefinedFunction(this.m_function);
        }
    }

    @Override
    public void handleParentObjectChanged() {
    }

    public FunctionsImportRules functionsImportRule() {
        return this.m_functionsImportRules;
    }

    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void done() {
    }

    @Override
    public void cancel() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runFunctionsImportGeneric(Connection connection, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        Statement statement = null;
        ResultSet rsFunctions = null;
        try {
            statement = connection.createStatement();
            DatabaseMetaData md = connection.getMetaData();
            MetadataObjectSelections metadataObjectSelections = this.m_objectSelectionsChoice.metadataObjectSelections();
            SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
            boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
            if (bAllCatalogsSelected) {
                rsFunctions = md instanceof IAdaptorDBMetadata ? ((IAdaptorDBMetadata)md).getFunctions("", "", "") : md.getProcedures(null, null, null);
                this.handleResultSet(statement, rsFunctions, resultSetSchemaLocator);
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        String catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, catalogName);
                    }
                }
            }
            this.close(rsFunctions, statement);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
        finally {
            this.close(rsFunctions, statement);
        }
    }

    private void handleResultSet(Statement statement, ResultSet rsFunctions, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        FunctionInfo functionInfo;
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsFunctions, vendorAccessHandler);
        this.m_resultSet = relmdResultSet;
        ArrayList<FunctionInfo> functionInfoList = new ArrayList<FunctionInfo>();
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            String catalogName = resultSetValueRetrieval.stringValue(this.m_functionsImportRules.parentCatalogNameRecordIndex());
            String schemaName = resultSetValueRetrieval.stringValue(this.m_functionsImportRules.parentSchemaNameRecordIndex());
            int nameRecordIndex = this.m_functionsImportRules.nameRecordIndex();
            String functionName = resultSetValueRetrieval.stringValue(nameRecordIndex);
            String description = resultSetValueRetrieval.stringValue(this.m_functionsImportRules.descriptionRecordIndex());
            FunctionInfo functionInfo2 = new FunctionInfo(catalogName, schemaName, description, functionName);
            functionInfoList.add(functionInfo2);
        }
        ArrayList<QualifierList.CatalogSchemaPath> qualifierList = this.getQualifierList();
        if (null == qualifierList) {
            this.m_applyQualifierList = false;
        }
        if (this.m_applyQualifierList && null != (functionInfo = this.findFunctionInfoWithQualifierList(functionInfoList, qualifierList))) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(functionInfo.getCatalog(), functionInfo.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(functionInfo.getDescription(), functionInfo.getFunction());
            return;
        }
        for (FunctionInfo functionInfo3 : functionInfoList) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(functionInfo3.getCatalog(), functionInfo3.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(functionInfo3.getDescription(), functionInfo3.getFunction());
        }
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private FunctionInfo findFunctionInfoWithQualifierList(ArrayList<FunctionInfo> functionInfoList, ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        if (1 == functionInfoList.size()) {
            FunctionInfo functionInfo = functionInfoList.get(0);
            QualifierList.CatalogSchemaPath cs = new QualifierList.CatalogSchemaPath(functionInfo.getCatalog(), functionInfo.getSchema());
            this.setQualifiedCatalogSchema(cs);
            return functionInfo;
        }
        if (0 >= functionInfoList.size()) {
            return null;
        }
        boolean matching = false;
        for (QualifierList.CatalogSchemaPath qualifier : qualifierList) {
            String qualifierCatalogName = qualifier.getCatalog();
            String qualifierSchemaName = qualifier.getSchema();
            for (FunctionInfo functionInfo : functionInfoList) {
                String catalogValue = functionInfo.getCatalog();
                String schemaValue = functionInfo.getSchema();
                if (null == qualifierCatalogName && null != qualifierSchemaName) {
                    matching = qualifierSchemaName.equals(schemaValue);
                } else if (null != qualifierCatalogName && null == qualifierSchemaName) {
                    matching = qualifierCatalogName.equals(catalogValue);
                } else if (null == qualifierCatalogName && null == qualifierSchemaName) {
                    matching = false;
                } else {
                    boolean bl = matching = qualifierSchemaName.equals(schemaValue) && qualifierCatalogName.equals(catalogValue);
                }
                if (!matching) continue;
                this.setQualifiedCatalogSchema(qualifier);
                return functionInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleSchemaSelections(Statement statement, DatabaseMetaData md, ParentSchemaReferenceProcessor resultSetSchemaLocator, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, String catalogName) {
        boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
        ResultSet rsFunctions = null;
        try {
            if (bAllSchemaSelected) {
                rsFunctions = md instanceof IAdaptorDBMetadata ? ((IAdaptorDBMetadata)md).getFunctions(catalogName, null, null) : md.getProcedures(catalogName, null, null);
                this.handleResultSet(statement, rsFunctions, resultSetSchemaLocator);
            } else {
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null != selectedSchemas) {
                    EscapeObjectName escapeObject = new EscapeObjectName(md);
                    for (SchemaSelection selectedSchema : selectedSchemas) {
                        String schemaName = selectedSchema.objectName();
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        SelectionChoice<FunctionSelection, AllFunctionsSelection> functionSelections = selectedSchema.functionSelections();
                        boolean bAllFunctionsSelected = this.m_objectSelectionsToolkit.allSelected(functionSelections);
                        if (bAllFunctionsSelected) {
                            rsFunctions = md instanceof IAdaptorDBMetadata ? ((IAdaptorDBMetadata)md).getFunctions(catalogName, escapedSchemaName, null) : md.getProcedures(catalogName, escapedSchemaName, null);
                            this.handleResultSet(statement, rsFunctions, resultSetSchemaLocator);
                            continue;
                        }
                        ReferenceableSet<FunctionSelection> selectedFunctions = functionSelections.selectedObjects();
                        if (null == selectedFunctions) continue;
                        for (FunctionSelection selectedFunction : selectedFunctions) {
                            String functionName = selectedFunction.objectName();
                            String escapedFunctionName = escapeObject.escape(functionName);
                            if (escapedSchemaName != null && escapedSchemaName.isEmpty()) {
                                escapedSchemaName = null;
                            }
                            String resolvedCatalogName = catalogName;
                            String resolvedFunctionName = escapedFunctionName;
                            if (this.m_rawVendorType.equals((Object)Database.EVendorType.oracle)) {
                                if (!escapedFunctionName.contains(".")) {
                                    if (catalogName == null) {
                                        resolvedCatalogName = "";
                                    }
                                } else {
                                    resolvedCatalogName = escapedFunctionName.substring(0, escapedFunctionName.indexOf("."));
                                    resolvedFunctionName = escapedFunctionName.substring(escapedFunctionName.indexOf(".") + 1, escapedFunctionName.length());
                                }
                            }
                            rsFunctions = md instanceof IAdaptorDBMetadata ? ((IAdaptorDBMetadata)md).getFunctions(resolvedCatalogName, escapedSchemaName, resolvedFunctionName) : md.getProcedures(resolvedCatalogName, escapedSchemaName, resolvedFunctionName);
                            this.handleResultSet(statement, rsFunctions, resultSetSchemaLocator);
                        }
                    }
                }
            }
            this.close(rsFunctions, null);
        }
        catch (SQLException sQLException) {
            this.close(rsFunctions, null);
            catch (Throwable throwable) {
                this.close(rsFunctions, null);
                throw throwable;
            }
        }
    }

    private void close(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class FunctionInfo
    extends QualifierList.CatalogSchemaPath {
        private String description;
        private String function;

        public FunctionInfo(String catalog, String schema, String desc, String function) {
            super(catalog, schema);
            this.description = null;
            this.function = null;
            this.description = desc;
            this.function = function;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFunction() {
            return this.function;
        }
    }
}

