/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ExternalSchemaReferenceElem;
import com.ibm.cognos.internal.relmd.metadata._schema.IndexElem;
import com.ibm.cognos.internal.relmd.metadata._schema.IndexedColumnRefElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.SchemaChildLevelExtraction;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentTableHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.IndexHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.Index;
import com.ibm.cognos.relmd.metadata._schema.properties.IndexedColumnRef;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.IndexesImport;
import com.ibm.cognos.relmd.metadata.import_.rules.IndexesImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.RefColumnIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class IndexesImportElem
extends ExtractionElement
implements VendorAccessResultSetHandler,
I_ChildElementHandler,
IndexesImport {
    private IndexesImportRules m_indexesRules = null;
    private Index m_currentIndex = null;
    private IndexHandler m_indexHandler;
    private SchemaChildLevelExtraction m_schemaChildLevelExtraction = null;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private String m_catalogName = null;
    private String m_schemaName = null;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_schemaPathHandler;
    private SessionAccess m_sessionAccess;
    private VendorAccessHandler m_vendorAccessHandler = null;
    private static final int TABLE_NAME_INDEX = 3;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public IndexesImportElem() {
        super(ImportMetadataFunction.EImportFunctionType.importIndexes);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, IndexesImportRules indexesImportRules, MetadataObjectSelections objectSelections, IndexHandler indexHandler, ParentTableHandler parentTableHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_schemaChildLevelExtraction = null;
        this.m_indexesRules = indexesImportRules;
        this.m_indexHandler = indexHandler;
        this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(parentTableHandler);
        VendorAccess extractionQuery = this.m_indexesRules.extractionQuery();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        ImportSummary summary = null;
        if (null != this.m_vendorType && this.m_vendorType == Database.EVendorType.genericHive) {
            String className = this.getClass().getName();
            summary = new ExtractionSummary(className);
        } else if (this.m_vendorType != null && this.m_vendorType.toString().indexOf("generic") != -1) {
            VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
            IndexesImportElem resultSetHandler = this;
            this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
            this.m_schemaPathHandler = metadataToolkit.contextHandler(parentCatalogSchemaHandler);
            summary = this.runIndexesImportGeneric(jdbcConnection, objectSelections, this.m_schemaPathHandler, this.m_indexesRules, resultSetHandler);
        } else {
            summary = this.m_schemaChildLevelExtraction.run(relmdConnection.jdbcConnection(), (QueryObjectChildIndexes)this.m_indexesRules, extractionQuery, relmdConnection, objectSelections, this.m_indexesRules.objectSelectionsInclusionCollection(), this, parentCatalogSchemaHandler, (I_ChildElementHandler)this, this.m_vendorType);
        }
        return summary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        return this.run(relmdConnection, metadataImportRules.indexesImportRules(), objectSelections, modelElementHandler, modelElementHandler, modelElementHandler);
    }

    public IndexesImportRules indexesImportRule() {
        return this.m_indexesRules;
    }

    @Override
    public void done() {
        this.handleParentObjectChanged();
    }

    @Override
    public void cancel() {
        if (this.m_schemaChildLevelExtraction != null) {
            this.m_schemaChildLevelExtraction.cancel();
        }
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        String indexName = resultSetValueRetrieval.stringValue(this.m_indexesRules.indexNameRecordIndex());
        if (indexName.equals("")) {
            return;
        }
        if (this.m_currentIndex == null || !indexName.equals(this.m_currentIndex.objectName())) {
            if (this.m_currentIndex != null) {
                this.m_indexHandler.handleIndex(this.m_currentIndex);
            }
            int parentCatalogNameRecordIndex = this.m_indexesRules.parentCatalogNameRecordIndex();
            String m_catalog = resultSetValueRetrieval.stringValue(parentCatalogNameRecordIndex);
            int parentSchemaNameRecordIndex = this.m_indexesRules.parentSchemaNameRecordIndex();
            String m_schema = resultSetValueRetrieval.stringValue(parentSchemaNameRecordIndex);
            RefColumnIndexes refColumnRules = this.m_indexesRules.refColumnRules();
            ExternalSchemaReferenceElem externalSchemaReference = new ExternalSchemaReferenceElem(null, m_catalog, m_schema, resultSetValueRetrieval, refColumnRules);
            int refQueryObjectRecordIndex = refColumnRules.refQueryObjectRecordIndex();
            String tableName = resultSetValueRetrieval.stringValue(refQueryObjectRecordIndex);
            int descriptionRecordIndex = this.m_indexesRules.descriptionRecordIndex();
            String description = resultSetValueRetrieval.stringValue(descriptionRecordIndex);
            boolean computeIsUniqueValue = this.computeIsUniqueValue(resultSetValueRetrieval);
            Index.EStorageType computeStorageTypeValue = this.computeStorageTypeValue(resultSetValueRetrieval);
            this.m_currentIndex = new IndexElem(indexName, description, computeIsUniqueValue, computeStorageTypeValue, externalSchemaReference, tableName);
        }
        IndexedColumnRefElem columnRef = new IndexedColumnRefElem(resultSetValueRetrieval, this.m_indexesRules);
        Collection<IndexedColumnRef> indexedColumnRefCollection = this.m_currentIndex.indexedColumnRefsCollection();
        indexedColumnRefCollection.add(columnRef);
    }

    @Override
    public void handleParentObjectChanged() {
        if (this.m_currentIndex != null) {
            this.m_indexHandler.handleIndex(this.m_currentIndex);
            this.m_currentIndex = null;
        }
    }

    private boolean computeIsUniqueValue(VendorAccessResultSetValues resultSetValueRetrieval) {
        String extractedIsUniqueValue = resultSetValueRetrieval.stringValue(this.m_indexesRules.isUniqueRecordIndex());
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            return extractedIsUniqueValue != null && !extractedIsUniqueValue.startsWith("T") && !extractedIsUniqueValue.startsWith("t") && !extractedIsUniqueValue.startsWith("Y") && !extractedIsUniqueValue.startsWith("y") && !extractedIsUniqueValue.startsWith("1");
        }
        return extractedIsUniqueValue != null && (extractedIsUniqueValue.startsWith("T") || extractedIsUniqueValue.startsWith("t") || extractedIsUniqueValue.startsWith("Y") || extractedIsUniqueValue.startsWith("y") || extractedIsUniqueValue.startsWith("1"));
    }

    private Index.EStorageType computeStorageTypeValue(VendorAccessResultSetValues resultSetValueRetrieval) {
        String extractedStorageType = resultSetValueRetrieval.stringValue(this.m_indexesRules.storageTypeRecordIndex());
        Index.EStorageType realStorageType = Index.EStorageType.regular;
        if (extractedStorageType != null && extractedStorageType.length() > 0) {
            if (extractedStorageType.equals("0")) {
                realStorageType = Index.EStorageType.unknown;
            } else if (extractedStorageType.equals("1")) {
                realStorageType = Index.EStorageType.regular;
            } else if (extractedStorageType.equals("2")) {
                realStorageType = Index.EStorageType.hash;
            } else if (extractedStorageType.equals("3")) {
                realStorageType = Index.EStorageType.clustered;
            }
        }
        return realStorageType;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private ExtractionSummary runIndexesImportGeneric(Connection connection, MetadataObjectSelections metadataObjectSelections, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        String className = this.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        try {
            DatabaseMetaData md = connection.getMetaData();
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            ResultSet rsTables = null;
            if (bAllCatalogsSelected) {
                rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(null, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(null, null, null, tableTypeMapper.defaultTable_tableTypes);
                ArrayList<Object> tableNames = new ArrayList<Object>();
                while (rsTables != null && rsTables.next()) {
                    String tableName = rsTables.getString(3);
                    tableNames.add(tableName);
                }
                if (rsTables != null) {
                    rsTables.close();
                }
                for (String string : tableNames) {
                    summary = this.getIndexesGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                }
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                } else {
                    for (CatalogSelection catalogSelection : selectedCatalogs) {
                        this.m_catalogName = catalogSelection.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = catalogSelection.schemaSelections();
                        this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return summary;
    }

    private ExtractionSummary handleSchemaSelections(Connection connection, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        block10: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            ResultSet rsTables = null;
            try {
                DatabaseMetaData md = connection.getMetaData();
                TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
                if (bAllSchemaSelected) {
                    rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(this.m_catalogName, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(this.m_catalogName, null, null, tableTypeMapper.defaultTable_tableTypes);
                    while (rsTables != null && rsTables.next()) {
                        String tableName = rsTables.getString(3);
                        summary = this.getIndexesGeneric(connection, tableName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                    break block10;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block10;
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                for (SchemaSelection selectedSchema : selectedSchemas) {
                    this.m_schemaName = selectedSchema.objectName();
                    QualifierList.CatalogSchemaPath cs = this.getQualifiedCatalogSchema();
                    if (null != this.m_catalogName && this.m_catalogName.isEmpty() && null != cs && null != cs.getCatalog()) {
                        this.m_catalogName = cs.getCatalog();
                    }
                    if (null != this.m_schemaName && this.m_schemaName.isEmpty() && null != cs && null != cs.getSchema()) {
                        this.m_schemaName = cs.getSchema();
                    }
                    String escapedSchemaName = escapeObject.escape(this.m_schemaName);
                    SelectionChoice<TableSelection, AllTablesSelection> tableSelections = selectedSchema.tableSelections();
                    boolean bAllTablesSelected = this.m_objectSelectionsToolkit.allSelected(tableSelections);
                    if (bAllTablesSelected) {
                        rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(this.m_catalogName, escapedSchemaName, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(this.m_catalogName, escapedSchemaName, null, tableTypeMapper.defaultTable_tableTypes);
                        while (rsTables != null && rsTables.next()) {
                            String tableName = rsTables.getString(3);
                            summary = this.getIndexesGeneric(connection, tableName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    ReferenceableSet<TableSelection> selectedTables = tableSelections.selectedObjects();
                    if (null == selectedTables) continue;
                    for (TableSelection selectedTable : selectedTables) {
                        String tableName = selectedTable.objectName();
                        summary = this.getIndexesGeneric(connection, tableName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return summary;
    }

    private ExtractionSummary getIndexesGeneric(Connection connection, String tableName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) throws SQLException {
        try {
            DatabaseMetaData md = connection.getMetaData();
            Statement statement = connection.createStatement();
            if (this.m_catalogName != null && this.m_catalogName.isEmpty()) {
                this.m_catalogName = null;
            }
            if (this.m_schemaName != null && this.m_schemaName.isEmpty()) {
                this.m_schemaName = null;
            }
            ResultSet rsIndexes = md.getIndexInfo(this.m_catalogName, this.m_schemaName, tableName, false, true);
            RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsIndexes, this.m_vendorAccessHandler);
            summary = this.m_schemaChildLevelExtraction.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, relmdResultSet, this, resultSetHandler, Database.EVendorType.generic);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.done();
        return summary;
    }
}

