/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.RoutineArgumentElem;
import com.ibm.cognos.internal.relmd.metadata._schema.RoutineSignatureElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.SchemaChildLevelExtraction;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentRoutineHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.RoutineArgumentHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.RoutineArgumentsImport;
import com.ibm.cognos.relmd.metadata.import_.rules.RoutineArgumentsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllFunctionsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllProceduresSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.FunctionSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ProcedureSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class RoutineArgumentsImportElem
extends ExtractionElement
implements ImportMetadataFunction,
VendorAccessResultSetHandler,
I_ChildElementHandler,
RoutineArgumentsImport {
    private static final int DEFAULT_SIGNATURE_INDEX = -99999;
    private int m_signatureIndex = -99999;
    private RoutineArgumentHandler m_routineArgumentHandler = null;
    private RoutineArgumentsImportRules m_routineArgumentsImportRules = null;
    private SchemaChildLevelExtraction m_schemaChildLevelExtraction = null;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private String m_catalogName = null;
    private String m_schemaName = null;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_schemaPathHandler;
    private SessionAccess m_sessionAccess;
    private VendorAccessHandler m_vendorAccessHandler = null;
    final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    final String PROCEDURE_NAME = "PROCEDURE_NAME";

    public RoutineArgumentsImportElem() {
        super(ImportMetadataFunction.EImportFunctionType.importRoutineArguments);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, RoutineArgumentsImportRules routineArgumentsImportRules, MetadataObjectSelections objectSelections, RoutineArgumentHandler routineArgumentHandler, ParentRoutineHandler parentRoutineHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_schemaChildLevelExtraction = null;
        this.m_routineArgumentsImportRules = routineArgumentsImportRules;
        this.m_routineArgumentHandler = routineArgumentHandler;
        this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(parentRoutineHandler);
        VendorAccess extractionQuery = this.m_routineArgumentsImportRules.extractionQuery();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        ImportSummary summary = null;
        if (this.m_vendorType != null && this.m_vendorType.toString().indexOf("generic") != -1) {
            VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
            RoutineArgumentsImportElem resultSetHandler = this;
            this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
            summary = this.runRoutineArgumentsImportGeneric(jdbcConnection, objectSelections, this.m_schemaPathHandler, this.m_routineArgumentsImportRules, resultSetHandler);
        } else {
            summary = this.m_schemaChildLevelExtraction.run(relmdConnection.jdbcConnection(), (QueryObjectChildIndexes)this.m_routineArgumentsImportRules, extractionQuery, relmdConnection, objectSelections, this.m_routineArgumentsImportRules.objectSelectionsInclusionCollection(), this, parentCatalogSchemaHandler, (I_ChildElementHandler)this, this.m_vendorType);
        }
        return summary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules metadataImportRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        return this.run(relmdConnection, metadataImportRules.routineArgumentsImportRules(), objectSelections, modelElementHandler, modelElementHandler, modelElementHandler);
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        int signatureIndex = this.m_routineArgumentsImportRules.signatureIndex();
        int signatureIdx = resultSetValueRetrieval.intValue(signatureIndex);
        if (this.m_signatureIndex == -99999 || this.m_signatureIndex != signatureIdx) {
            RoutineSignatureElem routineSignature = new RoutineSignatureElem();
            this.m_routineArgumentHandler.handleRoutineSignature(routineSignature);
            this.m_signatureIndex = signatureIdx;
        }
        int mode = this.m_routineArgumentsImportRules.mode();
        String modeValue = resultSetValueRetrieval.stringValue(mode);
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            modeValue = modeValue.equals("1") ? "in" : (modeValue.equals("2") ? "inout" : (modeValue.equals("3") || modeValue.equals("5") ? "out" : (modeValue.equals("4") ? "ret" : "emptyArgumentListPlacholder")));
        }
        if (!modeValue.equals("emptyArgumentListPlacholder")) {
            RoutineArgumentElem argument = new RoutineArgumentElem("argument", modeValue, this.m_routineArgumentsImportRules, resultSetValueRetrieval, this.m_vendorType);
            this.m_routineArgumentHandler.handleRoutineArgument(argument);
        }
    }

    @Override
    public void handleParentObjectChanged() {
        this.m_signatureIndex = -99999;
    }

    @Override
    public void done() {
    }

    @Override
    public void cancel() {
        if (this.m_schemaChildLevelExtraction != null) {
            this.m_schemaChildLevelExtraction.cancel();
        }
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    private ExtractionSummary runRoutineArgumentsImportGeneric(Connection connection, MetadataObjectSelections metadataObjectSelections, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        String className = this.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        if (bAllCatalogsSelected) {
            summary = this.getRoutineArgumentsGeneric(connection, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
        } else {
            ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
            if (selectedCatalogs.isEmpty()) {
                SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
            } else {
                for (CatalogSelection selectedCatalog : selectedCatalogs) {
                    this.m_catalogName = selectedCatalog.objectName();
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                    this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                }
            }
        }
        return summary;
    }

    private ExtractionSummary handleSchemaSelections(Connection connection, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        block18: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            try {
                DatabaseMetaData md = connection.getMetaData();
                if (bAllSchemaSelected) {
                    summary = this.getRoutineArgumentsGeneric(connection, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    break block18;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block18;
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                for (SchemaSelection selectedSchema : selectedSchemas) {
                    ReferenceableSet<ProcedureSelection> selectedProcedures;
                    String functionName2;
                    this.m_schemaName = selectedSchema.objectName();
                    String escapedSchemaName = escapeObject.escape(this.m_schemaName);
                    SelectionChoice<FunctionSelection, AllFunctionsSelection> functionSelections = selectedSchema.functionSelections();
                    SelectionChoice<ProcedureSelection, AllProceduresSelection> procedureSelections = selectedSchema.procedureSelections();
                    boolean bAllFunctionsSelected = this.m_objectSelectionsToolkit.allSelected(functionSelections);
                    boolean bAllProceduresSelected = this.m_objectSelectionsToolkit.allSelected(procedureSelections);
                    if (bAllFunctionsSelected && bAllProceduresSelected) {
                        summary = this.getRoutineArgumentsGeneric(connection, null, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        continue;
                    }
                    if (bAllFunctionsSelected && !bAllProceduresSelected) {
                        ResultSet rsFunctions = md.getProcedures(this.m_catalogName, escapedSchemaName, null);
                        ArrayList<String> functionNames = new ArrayList<String>();
                        while (rsFunctions.next()) {
                            String functionType = rsFunctions.getString("PROCEDURE_TYPE");
                            functionName2 = rsFunctions.getString("PROCEDURE_NAME");
                            if (Integer.parseInt(functionType) != 2) continue;
                            functionNames.add(functionName2);
                        }
                        if (rsFunctions != null) {
                            rsFunctions.close();
                        }
                        for (String functionName2 : functionNames) {
                            summary = this.getRoutineArgumentsGeneric(connection, functionName2, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        ReferenceableSet<ProcedureSelection> selectedProcedures2 = procedureSelections.selectedObjects();
                        if (null == selectedProcedures2) continue;
                        for (ProcedureSelection selectedProcedure : selectedProcedures2) {
                            String procedureName = selectedProcedure.objectName();
                            summary = this.getRoutineArgumentsGeneric(connection, procedureName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    if (!bAllFunctionsSelected && bAllProceduresSelected) {
                        ResultSet rsProcedures = md.getProcedures(this.m_catalogName, escapedSchemaName, null);
                        ArrayList<String> procedureNames = new ArrayList<String>();
                        while (rsProcedures.next()) {
                            String procedureType = rsProcedures.getString("PROCEDURE_TYPE");
                            String procedureName = rsProcedures.getString("PROCEDURE_NAME");
                            if (Integer.parseInt(procedureType) != 1) continue;
                            procedureNames.add(procedureName);
                        }
                        if (rsProcedures != null) {
                            rsProcedures.close();
                        }
                        for (String procedureName : procedureNames) {
                            summary = this.getRoutineArgumentsGeneric(connection, procedureName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        ReferenceableSet<FunctionSelection> selectedFunctions = functionSelections.selectedObjects();
                        if (null == selectedFunctions) continue;
                        for (FunctionSelection selectedFunction : selectedFunctions) {
                            String functionName3 = selectedFunction.objectName();
                            summary = this.getRoutineArgumentsGeneric(connection, functionName3, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    if (bAllFunctionsSelected || bAllProceduresSelected) continue;
                    ReferenceableSet<FunctionSelection> selectedFunctions = functionSelections.selectedObjects();
                    if (null != selectedFunctions) {
                        for (FunctionSelection selectedFunction : selectedFunctions) {
                            functionName2 = selectedFunction.objectName();
                            summary = this.getRoutineArgumentsGeneric(connection, functionName2, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                    }
                    if (null == (selectedProcedures = procedureSelections.selectedObjects())) continue;
                    for (ProcedureSelection selectedProcedure : selectedProcedures) {
                        String procedureName = selectedProcedure.objectName();
                        summary = this.getRoutineArgumentsGeneric(connection, procedureName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExtractionSummary getRoutineArgumentsGeneric(Connection connection, String routineName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        Statement statement = null;
        ResultSet rsRoutineArguments = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            statement = connection.createStatement();
            if (this.m_catalogName != null && this.m_catalogName.isEmpty()) {
                this.m_catalogName = null;
            }
            if (this.m_schemaName != null && this.m_schemaName.isEmpty()) {
                this.m_schemaName = null;
            }
            EscapeObjectName escapeObject = new EscapeObjectName(md);
            String escapedSchemaName = escapeObject.escape(this.m_schemaName);
            String escapedRoutineName = escapeObject.escape(routineName);
            rsRoutineArguments = md.getProcedureColumns(this.m_catalogName, escapedSchemaName, escapedRoutineName, null);
            RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsRoutineArguments, this.m_vendorAccessHandler);
            summary = this.m_schemaChildLevelExtraction.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, relmdResultSet, this, resultSetHandler, Database.EVendorType.generic);
            this.m_schemaChildLevelExtraction.close(rsRoutineArguments, statement);
        }
        catch (SQLException sQLException) {
            this.m_schemaChildLevelExtraction.close(rsRoutineArguments, statement);
            catch (Throwable throwable) {
                this.m_schemaChildLevelExtraction.close(rsRoutineArguments, statement);
                throw throwable;
            }
        }
        this.done();
        return summary;
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return null;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return null;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
    }
}

