/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.SimulatedResultSet;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlWriter;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttributeGroup;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Schema;
import com.ibm.cognos.relmd.metadata._schema.Synonym;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema.properties.Referenceable;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlObject;
import com.ibm.cognos.relmd.metadata._schema.properties.SqlObjectPath;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportToolkit;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.SqlObjectImport;
import com.ibm.cognos.relmd.metadata.import_.results.SqlObjectResults;
import com.ibm.cognos.relmd.metadata.import_.rules.SqlObjectImportRules;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.session.Session;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session._schema.DefaultCatalogSchema;
import com.ibm.cognos.relmd.session._schema.SqlObjectConflict;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import com.ibm.cognos.relmd.xmlapi.XmlApiToolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SqlObjectImportElem
implements SqlObjectImport {
    public static final String TAGNAME = "sqlObjectImport";
    public static final int GETTABLES_TABLE_CAT_INDEX = 1;
    public static final int GETTABLES_TABLE_SCHEM_INDEX = 2;
    public static final int GETTABLES_TABLE_NAME_INDEX = 3;
    public static final int GETTABLES_TABLE_TYPE_INDEX = 4;
    public static final int GETTABLES_REMARKS_INDEX = 5;
    public static final int GETSYNONYMS_parentCatalog = 1;
    public static final int GETSYNONYMS_parentSchema = 2;
    public static final int GETSYNONYMS_sqlObjectName = 3;
    public static final int GETSYNONYMS_externalHostRef = 4;
    public static final int GETSYNONYMS_refCatalog = 5;
    public static final int GETSYNONYMS_refSchema = 6;
    public static final int GETSYNONYMS_synonymTargetName = 7;
    public static final int GETSYNONYMS_description = 8;
    private final Relmd m_relmd;
    private final MetadataImportToolkit m_metadataImportToolkit;
    private final MetadataToolkit m_metadataToolkit;
    private final MetadataObjectPathsToolkit m_objectPathsToolkit;
    private final MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private final SessionToolkit m_sessionToolkit;
    private final VendorAccessToolkit m_vendorAccessToolkit;
    private final SessionAccess m_sessionAccess;
    private Database.ECatalogSupport m_catalogSupport;
    private final SqlObjectResults m_sqlObjectColumnResults;
    private final SqlObjectImportRules m_sqlObjectImportRules;
    private final SqlObjectQueryPath m_sqlObjectQueryPath;
    private Handler<SqlObjectConflict> m_sqlObjectConflictHandler;
    private boolean m_bCancelled;
    private boolean m_bExecutionError;
    private Database.EVendorType m_vendorType;
    private VendorAccessHandler m_vendorAccessHandler;
    private SchemaPath m_matchingSchemaPathFromQualifierList = null;

    public SqlObjectImportElem(SessionAccess sessionAccess, SqlObjectImportRules sqlObjectImportRules, SqlObjectQueryPath sqlObjectQueryPath, SqlObjectResults sqlObjectResults) {
        this.m_sqlObjectImportRules = sqlObjectImportRules;
        this.m_sqlObjectQueryPath = sqlObjectQueryPath;
        this.m_sqlObjectColumnResults = sqlObjectResults;
        this.m_relmd = RelmdGateway.relmd();
        this.m_metadataToolkit = this.m_relmd.metadataToolkit();
        this.m_metadataImportToolkit = this.m_metadataToolkit.metadataImportToolkit();
        this.m_objectPathsToolkit = this.m_metadataToolkit.metadataObjectPathsToolkit();
        this.m_objectSelectionsToolkit = this.m_metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_sessionToolkit = this.m_relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = this.m_sessionToolkit.sessionAccessToolkit();
        VendorAccessResults vendorAccessResults = sessionAccess.vendorAccessResults();
        this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        VendorAccessHandler cancellableHandler = this.cancellableHandler(this.m_vendorAccessHandler);
        VendorToolkit vendorToolkit = this.m_relmd.vendorToolkit();
        this.m_vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        this.m_sqlObjectConflictHandler = sqlObjectResults.sqlObjectConflictHandler();
        Session session = sessionAccess.session();
        SessionQueryRules sessionQueryRules = sessionAccess.sessionQueryRules();
        SessionAccess connectionParameters = sessionAccess;
        VendorAccessResults vendorAccess = this.m_vendorAccessToolkit.vendorAccessResults(cancellableHandler);
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(connectionParameters, session, sessionQueryRules, vendorAccess);
        this.m_vendorType = this.m_sessionAccess.vendorType();
        this.m_catalogSupport = sessionQueryRules.catalogSupport();
        this.m_bExecutionError = false;
        this.m_bCancelled = false;
    }

    @Override
    public void run(Connection jdbcConnection) {
        ExtractionSummary summary = new ExtractionSummary(TAGNAME);
        summary.start();
        VendorAccess extractionQuery = this.m_sqlObjectImportRules.extractionQuery();
        VendorAccessResultSetIterator resultSetIterator = null;
        DatabaseMetaData md = null;
        Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection = this.m_sqlObjectImportRules.objectSelectionsInclusionCollection();
        SqlObjectQueryPath searchPath = this.m_sqlObjectQueryPath;
        int iterationCount = 0;
        while (!this.m_bCancelled && null != searchPath) {
            SchemaPath schemaPath;
            LinkedHashMap<SqlObjectPath, SqlObject> foundObjectsMap = new LinkedHashMap<SqlObjectPath, SqlObject>();
            ArrayList<Synonym> foundSynonyms = new ArrayList<Synonym>();
            MetadataImportSelectionsChoice m_metadataImportSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(searchPath);
            VendorAccessResultSet resultSet = null;
            if (this.m_vendorType != null && jdbcConnection != null && this.m_vendorType.toString().indexOf("generic") != -1) {
                try {
                    md = jdbcConnection.getMetaData();
                    resultSet = this.runGeneric4SqlObjectImport(md, searchPath);
                }
                catch (SQLException sQLException) {}
            } else {
                resultSet = extractionQuery.run(jdbcConnection, this.m_sessionAccess, m_metadataImportSelectionsChoice, objectSelectionsInclusionCollection);
            }
            if (resultSet != null) {
                resultSetIterator = resultSet.iterator();
                while (resultSetIterator.next()) {
                    summary.incrementRowCount();
                    VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                    SqlObjectImportRules schemaChildIndexes = this.m_sqlObjectImportRules;
                    schemaPath = this.m_metadataImportToolkit.schemaPath(schemaChildIndexes, resultSetValueRetrieval);
                    SqlObject sqlObject = this.m_metadataImportToolkit.sqlObject(this.m_sqlObjectImportRules, resultSetValueRetrieval, md);
                    SqlObjectPath sqlObjectPath = this.m_objectPathsToolkit.sqlObjectPath(schemaPath, sqlObject);
                    foundObjectsMap.put(sqlObjectPath, sqlObject);
                    SqlObject.EType type = sqlObject.sqlObjectType();
                    if (!SqlObject.EType.synonym.equals((Object)type)) continue;
                    Synonym obj = this.m_metadataImportToolkit.synonym(schemaPath, this.m_sqlObjectImportRules, this.m_sqlObjectImportRules, resultSetValueRetrieval);
                    Boolean hasExternalSchemaRef = obj.hasExternalSchemaRef();
                    String externalCatalogRef = obj.externalCatalogRef();
                    String externalSchemaRef = obj.externalSchemaRef();
                    SchemaPath resolvedSchemaPath = hasExternalSchemaRef != false ? this.m_objectPathsToolkit.schemaPath(this.m_catalogSupport, externalCatalogRef, externalSchemaRef) : schemaPath;
                    String targetRef = obj.targetRef();
                    searchPath = this.m_objectPathsToolkit.sqlObjectQueryPath(resolvedSchemaPath, targetRef);
                    foundSynonyms.add(obj);
                }
            }
            Map.Entry<SqlObjectPath, SqlObject> foundEntry = this.checkFoundSqlObjects(jdbcConnection, foundObjectsMap);
            if (this.m_bExecutionError || null == foundEntry) {
                this.m_bCancelled = true;
            }
            if (this.m_bCancelled) continue;
            SqlObjectPath foundSqlObjectPath = foundEntry.getKey();
            schemaPath = foundSqlObjectPath.schemaPath();
            if (0 == iterationCount) {
                boolean hasParentCatalog = schemaPath.hasParentCatalog();
                if (hasParentCatalog) {
                    Handler<Catalog> origCatalogHandler = this.m_sqlObjectColumnResults.catalogHandler();
                    String parentCatalogName = schemaPath.parentCatalogName();
                    Catalog catalog = this.m_metadataToolkit.catalog(parentCatalogName);
                    origCatalogHandler.handle(catalog);
                }
                Handler<Schema> origSchemaHandler = this.m_sqlObjectColumnResults.schemaHandler();
                String parentSchemaName = schemaPath.parentSchemaName();
                Schema schema = this.m_metadataToolkit.schema(parentSchemaName);
                origSchemaHandler.handle(schema);
            }
            if (null != searchPath) {
                Handler<Table> origTableHandler = this.m_sqlObjectColumnResults.tableHandler();
                Handler<View> origViewHandler = this.m_sqlObjectColumnResults.viewHandler();
                SqlObject foundObj = foundEntry.getValue();
                SqlObject.EType sqlObjectType = foundObj.sqlObjectType();
                if (null != sqlObjectType) {
                    block1 : switch (sqlObjectType) {
                        case table: {
                            Table table = this.m_metadataToolkit.table(foundObj);
                            origTableHandler.handle(table);
                            searchPath = null;
                            break;
                        }
                        case view: {
                            View view = this.m_metadataToolkit.view(foundObj);
                            origViewHandler.handle(view);
                            searchPath = null;
                            break;
                        }
                        case synonym: {
                            Handler<Synonym> origSynonymHandler = this.m_sqlObjectColumnResults.synonymHandler();
                            Synonym obj = (Synonym)foundSynonyms.get(0);
                            origSynonymHandler.handle(obj);
                            searchPath = null;
                            if (this.m_bCancelled) break;
                            String targetRefName = obj.targetRef();
                            Referenceable targetRef = this.m_metadataToolkit.referenceable(targetRefName);
                            SqlObject.EType targetType = obj.targetType();
                            if (null == targetType) {
                                targetType = SqlObject.EType.synonym;
                            }
                            switch (targetType) {
                                case table: {
                                    Table targetTable = this.m_metadataToolkit.table(targetRef);
                                    origTableHandler.handle(targetTable);
                                    searchPath = null;
                                    break block1;
                                }
                                case view: {
                                    View targetView = this.m_metadataToolkit.view(targetRef);
                                    origViewHandler.handle(targetView);
                                    searchPath = null;
                                    break block1;
                                }
                            }
                            Boolean hasExternalSchemaRef = obj.hasExternalSchemaRef();
                            String externalCatalogRef = obj.externalCatalogRef();
                            String externalSchemaRef = obj.externalSchemaRef();
                            SchemaPath resolvedSchemaPath = hasExternalSchemaRef != false ? this.m_objectPathsToolkit.schemaPath(this.m_catalogSupport, externalCatalogRef, externalSchemaRef) : schemaPath;
                            searchPath = this.m_objectPathsToolkit.sqlObjectQueryPath(resolvedSchemaPath, targetRefName);
                        }
                    }
                }
            }
            ++iterationCount;
        }
        summary.stop();
    }

    private Map.Entry<SqlObjectPath, SqlObject> checkFoundSqlObjects(Connection jdbcConnection, final LinkedHashMap<SqlObjectPath, SqlObject> foundObjectsMap) {
        Map.Entry<SqlObjectPath, SqlObject> matching = null;
        int size = foundObjectsMap.size();
        Set<Map.Entry<SqlObjectPath, SqlObject>> values = foundObjectsMap.entrySet();
        Iterator<Map.Entry<SqlObjectPath, SqlObject>> valuesIterator = values.iterator();
        if (1 == size) {
            Map.Entry<SqlObjectPath, SqlObject> candidateEntry;
            matching = candidateEntry = valuesIterator.next();
        } else if (1 < size) {
            Session session = this.m_sessionAccess.session();
            String schemaName = "";
            String catalogName = "";
            SessionQueryRules sessionQueryRules = this.m_sessionAccess.sessionQueryRules();
            Database.ECatalogSupport catalogSupport = sessionQueryRules.catalogSupport();
            if (null != this.m_sqlObjectQueryPath && null != this.m_sqlObjectQueryPath.schemaPath()) {
                schemaName = this.m_sqlObjectQueryPath.schemaPath().parentSchemaName();
                catalogName = this.m_sqlObjectQueryPath.schemaPath().parentCatalogName();
            }
            DefaultCatalogSchema defaultCatalogSchema = session.defaultCatalogSchema();
            if (this.m_vendorType != null && this.m_vendorType.toString().indexOf("generic") != -1) {
                try {
                    DatabaseMetaData md = jdbcConnection.getMetaData();
                    String catalogTerm = md.getCatalogTerm();
                    if (catalogTerm != null && !catalogTerm.isEmpty()) {
                        catalogSupport = Database.ECatalogSupport.catalogsSupported;
                    }
                    String[] defaultCatalogSchemaName = ((IAdaptorDBMetadata)md).getDefaultCatalogSchemaName(this.m_sqlObjectQueryPath.objectName());
                    defaultCatalogSchema = this.m_metadataToolkit.defaultCatalogSchema(defaultCatalogSchemaName[0], defaultCatalogSchemaName[1]);
                }
                catch (SQLException md) {
                    // empty catch block
                }
            }
            if (null == schemaName || schemaName.length() == 0) {
                schemaName = defaultCatalogSchema.parentSchemaName();
            }
            if (null == catalogName || catalogName.length() == 0) {
                catalogName = defaultCatalogSchema.parentCatalogName();
            }
            SchemaPath defaultCatalogSchemaPath = this.m_objectPathsToolkit.schemaPath(catalogSupport, catalogName, schemaName);
            while (null == matching && valuesIterator.hasNext()) {
                Map.Entry<SqlObjectPath, SqlObject> candidateEntry = valuesIterator.next();
                SqlObjectPath candidate = candidateEntry.getKey();
                SchemaPath schemaPath = candidate.schemaPath();
                boolean match = false;
                match = Database.ECatalogSupport.catalogsSupported == catalogSupport && catalogName != null && catalogName.length() == 0 && schemaName != null && schemaPath != null ? schemaName.equals(schemaPath.parentSchemaName()) : this.m_objectPathsToolkit.match(schemaPath, defaultCatalogSchemaPath);
                if (!match) continue;
                matching = candidateEntry;
            }
            if (null == matching && jdbcConnection instanceof IAdaptorConnection && ((IAdaptorConnection)jdbcConnection).getQualifierList() != null) {
                List qualifierList = ((IAdaptorConnection)jdbcConnection).getQualifierList();
                boolean schemaSupport = true;
                try {
                    DatabaseMetaData md = jdbcConnection.getMetaData();
                    String schemaTerm = md.getSchemaTerm();
                    if (schemaTerm == null || schemaTerm.isEmpty()) {
                        schemaSupport = false;
                    }
                }
                catch (SQLException schemaTerm) {
                    // empty catch block
                }
                for (int i = 0; null == matching && i < qualifierList.size(); ++i) {
                    schemaName = "";
                    catalogName = "";
                    valuesIterator = values.iterator();
                    String[] token = ((String)qualifierList.get(i)).split("\\.");
                    if (Database.ECatalogSupport.catalogsSupported == catalogSupport && schemaSupport) {
                        if (token.length > 1) {
                            catalogName = token[0];
                            schemaName = token[1];
                        } else {
                            schemaName = token[0];
                        }
                    } else if (Database.ECatalogSupport.catalogsNotSupported == catalogSupport) {
                        schemaName = token.length > 1 ? token[1] : token[0];
                    } else {
                        catalogName = token[0];
                    }
                    boolean match = false;
                    while (null == matching && valuesIterator.hasNext()) {
                        Map.Entry<SqlObjectPath, SqlObject> candidateEntry = valuesIterator.next();
                        SqlObjectPath candidate = candidateEntry.getKey();
                        SchemaPath schemaPath = candidate.schemaPath();
                        if (Database.ECatalogSupport.catalogsSupported == catalogSupport && schemaSupport && catalogName.length() == 0 && schemaName != null && schemaPath != null) {
                            match = schemaName.equals(schemaPath.parentSchemaName());
                        } else {
                            SchemaPath CatalogSchemaPath2 = this.m_objectPathsToolkit.schemaPath(catalogSupport, catalogName, schemaName);
                            match = this.m_objectPathsToolkit.match(schemaPath, CatalogSchemaPath2);
                        }
                        if (!match) continue;
                        matching = candidateEntry;
                        this.m_matchingSchemaPathFromQualifierList = schemaPath;
                    }
                }
            }
            if (null == matching) {
                Handler<SqlObjectConflict> sqlObjectConflictHandler = this.sqlObjectConflictHandler();
                SqlObjectConflict obj = new SqlObjectConflict(){

                    @Override
                    public Collection<SqlObjectPath> sqlObjectPathCollection() {
                        return foundObjectsMap.keySet();
                    }
                };
                sqlObjectConflictHandler.handle(obj);
                this.m_bCancelled = true;
            }
        }
        return matching;
    }

    private VendorAccessHandler cancellableHandler(VendorAccessHandler vendorAccessHandler) {
        VendorToolkit vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        Handler<BeginSql> beginSqlHandler = null == vendorAccessHandler ? null : vendorAccessHandler.beginSqlHandler();
        Handler<BeginJava> beginJavaHandler = null == vendorAccessHandler ? null : vendorAccessHandler.beginJavaHandler();
        Handler<ExecutionInformation> executionInformationHandler = null == vendorAccessHandler ? null : vendorAccessHandler.executionInformationHandler();
        final Handler<ExecutionError> executionErrorHandlerOrig = null == vendorAccessHandler ? null : vendorAccessHandler.executionErrorHandler();
        Handler<ExecutionError> executionErrorHandler = new Handler<ExecutionError>(){

            @Override
            public void handle(ExecutionError obj) {
                SqlObjectImportElem.this.m_bExecutionError = true;
                if (null != executionErrorHandlerOrig) {
                    executionErrorHandlerOrig.handle(obj);
                }
            }
        };
        Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler = null == vendorAccessHandler ? null : vendorAccessHandler.resultSetProcessingInformationHandler();
        Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = null == vendorAccessHandler ? null : vendorAccessHandler.resultSetProcessingErrorHandler();
        VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        VendorAccessHandler cancellableHandler = vendorAccessToolkit.vendorAccessHandler(beginSqlHandler, beginJavaHandler, executionInformationHandler, executionErrorHandler, resultSetProcessingInformationHandler, resultSetProcessingErrorHandler);
        return cancellableHandler;
    }

    @Override
    public SchemaPath getMatchingSchemaPathFromQualifierList() {
        return this.m_matchingSchemaPathFromQualifierList;
    }

    @Override
    public SqlObjectQueryPath sqlObjectQueryPath() {
        return this.m_sqlObjectQueryPath;
    }

    @Override
    public SqlObjectImportRules sqlObjectImportRules() {
        return this.m_sqlObjectImportRules;
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void stop() {
        this.m_bCancelled = true;
    }

    @Override
    public XmlElement asXml() {
        final RelmdAttributeGroup attributeGroup = new RelmdAttributeGroup();
        String vendorTypeCode = this.m_vendorType.toString();
        XmlApiToolkit xmlApiToolkit = this.m_relmd.xmlApiToolkit();
        XmlAttribute vendorTypeAttribute = xmlApiToolkit.attribute("vendorType", vendorTypeCode);
        attributeGroup.add(vendorTypeAttribute);
        String jdbcConnectionString = this.m_sessionAccess.jdbcConnectionString();
        XmlAttribute jdbcConnectionStringAttribute = xmlApiToolkit.attribute("jdbcConnectionString", jdbcConnectionString);
        attributeGroup.add(jdbcConnectionStringAttribute);
        String userName = this.m_sessionAccess.userName();
        XmlAttribute userNameAttribute = xmlApiToolkit.attribute("userName", userName);
        attributeGroup.add(userNameAttribute);
        String driverClass = this.m_sessionAccess.driverClass();
        XmlAttribute driverClassAttribute = xmlApiToolkit.attribute("driverClass", driverClass);
        attributeGroup.add(driverClassAttribute);
        final ArrayList<SqlObjectQueryPath> childElements = new ArrayList<SqlObjectQueryPath>();
        childElements.add(this.m_sqlObjectQueryPath);
        XmlElement xmlElement = new XmlElement(){

            @Override
            public String getTagName() {
                return SqlObjectImportElem.TAGNAME;
            }

            @Override
            public void add(XmlAttribute attribute) {
                attributeGroup.add(attribute);
            }

            @Override
            public Collection<? extends XmlAttribute> attributes() {
                return attributeGroup.attributes();
            }

            @Override
            public XmlAttribute getAttribute(String name) {
                return attributeGroup.getAttribute(name);
            }

            @Override
            public Collection<? extends XmlElement> childElements() {
                return childElements;
            }
        };
        return xmlElement;
    }

    @Override
    public Handler<SqlObjectConflict> sqlObjectConflictHandler() {
        return this.m_sqlObjectConflictHandler;
    }

    @Override
    public Handler<Catalog> catalogHandler() {
        Handler<Catalog> catalogHandler = this.m_sqlObjectColumnResults.catalogHandler();
        return catalogHandler;
    }

    @Override
    public Handler<Schema> schemaHandler() {
        Handler<Schema> schemaHandler = this.m_sqlObjectColumnResults.schemaHandler();
        return schemaHandler;
    }

    @Override
    public Handler<Table> tableHandler() {
        Handler<Table> tableHandler = this.m_sqlObjectColumnResults.tableHandler();
        return tableHandler;
    }

    @Override
    public Handler<View> viewHandler() {
        Handler<View> viewHandler = this.m_sqlObjectColumnResults.viewHandler();
        return viewHandler;
    }

    @Override
    public Handler<Synonym> synonymHandler() {
        Handler<Synonym> synonymHandler = this.m_sqlObjectColumnResults.synonymHandler();
        return synonymHandler;
    }

    public String toString() {
        String string = "";
        ByteArrayOutputStream requestOut = new ByteArrayOutputStream();
        try {
            XmlElement asXml = this.asXml();
            XmlWriter writer = new XmlWriter("relmd", "relmdApi.xsd", "../webcontent/remd");
            writer.writeElem(asXml, requestOut, "relmd");
            requestOut.flush();
            requestOut.close();
            string = requestOut.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private VendorAccessResultSet runGeneric4SqlObjectImport(DatabaseMetaData md, SqlObjectQueryPath searchPath) {
        SimulatedResultSet resultSet = new SimulatedResultSet();
        boolean usingAdaptor = md instanceof IAdaptorDBMetadata;
        try {
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            EscapeObjectName escapeObject = new EscapeObjectName(md);
            String[] listofSynonymTableTypes = tableTypeMapper.getListOfSynonym_TableTypes();
            String catalogName = null;
            String schemaName = null;
            String objectName = searchPath.objectName();
            SchemaPath schemaPath = searchPath.schemaPath();
            if (schemaPath != null) {
                String s = schemaPath.parentCatalogName();
                if (s != null && !s.isEmpty()) {
                    catalogName = s;
                }
                if ((s = schemaPath.parentSchemaName()) != null && !s.isEmpty()) {
                    schemaName = s;
                }
            }
            String escapedSchemaName = escapeObject.escape(schemaName);
            String escapedObjectName = escapeObject.escape(objectName);
            SimulatedResultSet trs = new SimulatedResultSet();
            trs.addAll(md.getTables(catalogName, escapedSchemaName, escapedObjectName, null), 1, 2, 3, 4, 5);
            while (trs.next()) {
                String objectType = trs.stringValue(4);
                if (usingAdaptor && Arrays.asList(listofSynonymTableTypes).contains(objectType)) {
                    SimulatedResultSet srs = new SimulatedResultSet();
                    catalogName = trs.stringValue(1);
                    schemaName = trs.stringValue(2);
                    escapedSchemaName = escapeObject.escape(schemaName);
                    objectName = trs.stringValue(3);
                    escapedObjectName = escapeObject.escape(objectName);
                    srs.addAll(((IAdaptorDBMetadata)md).getSynonyms(catalogName, escapedSchemaName, escapedObjectName, listofSynonymTableTypes), 1, 2, 3, 4, 5, 6, 7, 8);
                    while (srs.next()) {
                        String targetType = null;
                        String targetDesc = null;
                        String refCatalog = srs.stringValue(5);
                        String refSchema = srs.stringValue(6);
                        if (srs.stringValue(4) == null || srs.stringValue(4).isEmpty()) {
                            SimulatedResultSet trs2 = new SimulatedResultSet();
                            schemaName = srs.stringValue(6);
                            escapedSchemaName = escapeObject.escape(schemaName);
                            objectName = srs.stringValue(7);
                            escapedObjectName = escapeObject.escape(objectName);
                            trs2.addAll(md.getTables(srs.stringValue(5), escapedSchemaName, escapedObjectName, null), 1, 2, 3, 4, 5);
                            if (trs2.next()) {
                                targetType = trs2.stringValue(4);
                                targetDesc = trs2.stringValue(5);
                                if (refCatalog == null && refSchema == null) {
                                    refCatalog = trs2.stringValue(1);
                                    refSchema = trs2.stringValue(2);
                                }
                            }
                            trs2.close();
                        }
                        resultSet.addRow(srs.stringValue(1), srs.stringValue(2), srs.stringValue(3), objectType, srs.stringValue(4), refCatalog, refSchema, srs.stringValue(7), targetType, targetDesc);
                    }
                    continue;
                }
                resultSet.addRow(trs.stringValue(1), trs.stringValue(2), trs.stringValue(3), trs.stringValue(4), null, null, null, null, null, trs.stringValue(5));
            }
            trs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return resultSet;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }
}

