/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.TableElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.Table;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.TableHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ParentCatalogSchema;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.TablesImport;
import com.ibm.cognos.relmd.metadata.import_.rules.TablesImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class TablesImportElem
extends ExtractionElement
implements TablesImport,
VendorAccessResultSetHandler,
I_ChildElementHandler {
    private TablesImportRules m_tablesRules;
    private VendorAccessResultSet m_resultSet;
    private SessionAccess m_sessionAccess;
    private MetadataImportSelectionsChoice m_objectSelectionsChoice;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_contextHandler;
    private Handler<Table> m_objectHandler;
    private MetadataToolkit m_metadataToolkit;
    private SessionAccessToolkit m_sessionAccessToolkit;
    private ExtractionSummary m_importSummary;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private TableTypeMapper m_tableTypeMapper;
    private int INDEX_TABLE_SCHEM = 1;
    private int INDEX_TABLE_CATALOG = 2;
    private boolean m_applyQualifierList = false;
    private Connection m_connection = null;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public TablesImportElem(SessionAccess sessionAccess, MetadataImportSelectionsChoice objectSelectionsChoice, TablesImportRules tablesRules, Handler<SchemaPath> contextHandler, Handler<Table> objectHandler) {
        super(ImportMetadataFunction.EImportFunctionType.importTables);
        Relmd relmd = RelmdGateway.relmd();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        this.m_sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = this.m_metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_tablesRules = tablesRules;
        this.m_sessionAccess = sessionAccess;
        this.m_objectSelectionsChoice = objectSelectionsChoice;
        this.m_contextHandler = contextHandler;
        this.m_objectHandler = objectHandler;
        this.m_importSummary = null;
        this.m_vendorType = null;
        this.m_tableTypeMapper = null;
        this.m_applyQualifierList = false;
    }

    public TablesImportElem() {
        this(null, null, null, null, null);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, TablesImportRules tablesImportRules, MetadataObjectSelections objectSelections, final TableHandler tableHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_importSummary = new ExtractionSummary(this.getClass().getName());
        this.m_importSummary.start();
        this.m_resultSet = null;
        this.m_objectHandler = new Handler<Table>(){

            @Override
            public void handle(Table obj) {
                Table table = obj;
                tableHandler.handleTable(table);
            }
        };
        this.m_tablesRules = tablesImportRules;
        this.m_sessionAccess = this.m_sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_objectSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        this.m_contextHandler = this.m_metadataToolkit.contextHandler(parentCatalogSchemaHandler);
        this.m_applyQualifierList = false;
        this.m_connection = relmdConnection.jdbcConnection();
        this.run(this.m_connection);
        this.m_importSummary.stop();
        return this.m_importSummary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules extractionRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        TablesImportRules tablesImportRules = extractionRules.tablesImportRules();
        return this.run(relmdConnection, tablesImportRules, objectSelections, modelElementHandler, modelElementHandler);
    }

    public TablesImportRules tableImportRule() {
        return this.m_tablesRules;
    }

    @Override
    public void done() {
    }

    @Override
    public void cancel() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void handleParentObjectChanged() {
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        TableElem table = new TableElem(this.m_tablesRules, resultSetValueRetrieval);
        this.m_objectHandler.handle(table);
    }

    public void handleResultSetRecord(String desc, String tableName) {
        TableElem table = new TableElem(desc, tableName, true);
        this.m_objectHandler.handle(table);
    }

    public void run(Connection jdbcConnection, SessionAccess access, TablesImportRules tablesImportRules, SqlObjectQueryPath sqlObjectQueryPath, Handler<Table> tableHandler, Handler<View> viewHandler, Handler<ParentCatalogSchema> parentCatalogSchemaHandler) {
    }

    @Override
    public ImportRules<Table> importRules() {
        ImportRules<Table> tablesImportRules = this.m_tablesRules.tablesImportRules();
        return tablesImportRules;
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice() {
        return this.m_objectSelectionsChoice;
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void run(Connection connection) {
        this.m_resultSet = null;
        VendorAccess m_extractionQuery = this.m_tablesRules.extractionQuery();
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (this.m_contextHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)this.m_tablesRules, this.m_contextHandler, (I_ChildElementHandler)this);
        }
        Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection = this.m_tablesRules.objectSelectionsInclusionCollection();
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            this.runForGeneric(connection, resultSetSchemaLocator);
            long rowsProcessed = this.m_importSummary.rowsProcessed();
            this.m_importSummary.tablesCount(rowsProcessed);
            return;
        }
        this.m_resultSet = m_extractionQuery.run(connection, this.m_sessionAccess, this.m_objectSelectionsChoice, objectSelectionsInclusionCollection);
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            this.m_importSummary.incrementRowCount();
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
            }
            this.handleResultSetRecord(resultSetValueRetrieval);
        }
        long rowsProcessed = this.m_importSummary.rowsProcessed();
        this.m_importSummary.tablesCount(rowsProcessed);
    }

    @Override
    public void stop() {
    }

    @Override
    public Handler<SchemaPath> contextHandler() {
        return this.m_contextHandler;
    }

    @Override
    public Handler<Table> objectHandler() {
        return this.m_objectHandler;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runForGeneric(Connection connection, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        Statement statement = null;
        ResultSet rsTables = null;
        try {
            statement = connection.createStatement();
            DatabaseMetaData md = connection.getMetaData();
            this.m_tableTypeMapper = new TableTypeMapper(md);
            MetadataObjectSelections metadataObjectSelections = this.m_objectSelectionsChoice.metadataObjectSelections();
            SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
            boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
            if (bAllCatalogsSelected) {
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                ResultSet rsSchemas = md.getSchemas();
                if (rsSchemas != null && rsSchemas.next()) {
                    do {
                        String schemaName = rsSchemas.getString(this.INDEX_TABLE_SCHEM);
                        String catalogName = rsSchemas.getString(this.INDEX_TABLE_CATALOG);
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, escapedSchemaName, null, this.m_tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(catalogName, escapedSchemaName, null, this.m_tableTypeMapper.defaultTable_tableTypes);
                        this.handleResultSet(statement, rsTables, resultSetSchemaLocator);
                    } while (rsSchemas.next());
                } else {
                    rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(null, null, null, this.m_tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(null, null, null, this.m_tableTypeMapper.defaultTable_tableTypes);
                    this.handleResultSet(statement, rsTables, resultSetSchemaLocator);
                }
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        String catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, catalogName);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.close(rsTables, statement);
        }
    }

    private void handleResultSet(Statement statement, ResultSet rsTables, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        TableInfo tableInfo;
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsTables, vendorAccessHandler);
        this.m_resultSet = relmdResultSet;
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>();
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            String catalogName = resultSetValueRetrieval.stringValue(this.m_tablesRules.parentCatalogNameRecordIndex());
            String schemaName = resultSetValueRetrieval.stringValue(this.m_tablesRules.parentSchemaNameRecordIndex());
            String tableName = resultSetValueRetrieval.stringValue(this.m_tablesRules.nameRecordIndex());
            String description = resultSetValueRetrieval.stringValue(this.m_tablesRules.descriptionRecordIndex());
            TableInfo tableInfo2 = new TableInfo(catalogName, schemaName, description, tableName);
            tableInfoList.add(tableInfo2);
        }
        ArrayList<QualifierList.CatalogSchemaPath> qualifierList = this.getQualifierList();
        if (null == qualifierList) {
            this.m_applyQualifierList = false;
        }
        if (this.m_applyQualifierList && null != (tableInfo = this.findTableInfoWithQualifierList(tableInfoList, qualifierList))) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(tableInfo.getCatalog(), tableInfo.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(tableInfo.getDescription(), tableInfo.getTable());
            return;
        }
        for (TableInfo tableInfo3 : tableInfoList) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(tableInfo3.getCatalog(), tableInfo3.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(tableInfo3.getDescription(), tableInfo3.getTable());
        }
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private TableInfo findTableInfoWithQualifierList(ArrayList<TableInfo> tableInfoList, ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        if (1 == tableInfoList.size()) {
            TableInfo tableInfo = tableInfoList.get(0);
            QualifierList.CatalogSchemaPath cs = new QualifierList.CatalogSchemaPath(tableInfo.getCatalog(), tableInfo.getSchema());
            this.setQualifiedCatalogSchema(cs);
            return tableInfo;
        }
        if (0 >= tableInfoList.size()) {
            return null;
        }
        boolean matching = false;
        for (QualifierList.CatalogSchemaPath qualifier : qualifierList) {
            String qualifierCatalogName = qualifier.getCatalog();
            String qualifierSchemaName = qualifier.getSchema();
            for (TableInfo tableInfo : tableInfoList) {
                String catalogValue = tableInfo.getCatalog();
                String schemaValue = tableInfo.getSchema();
                if (null == qualifierCatalogName && null != qualifierSchemaName) {
                    matching = qualifierSchemaName.equals(schemaValue);
                } else if (null != qualifierCatalogName && null == qualifierSchemaName) {
                    matching = qualifierCatalogName.equals(catalogValue);
                } else if (null == qualifierCatalogName && null == qualifierSchemaName) {
                    matching = false;
                } else {
                    boolean bl = matching = qualifierSchemaName.equals(schemaValue) && qualifierCatalogName.equals(catalogValue);
                }
                if (!matching) continue;
                this.setQualifiedCatalogSchema(qualifier);
                return tableInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSchemaSelections(Statement statement, DatabaseMetaData md, ParentSchemaReferenceProcessor resultSetSchemaLocator, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, String catalogName) {
        boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
        ResultSet rsTables = null;
        try {
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            EscapeObjectName escapeObject = new EscapeObjectName(md);
            if (bAllSchemaSelected) {
                String schemaTerm = md.getSchemaTerm();
                if (schemaTerm == null || schemaTerm.isEmpty()) {
                    rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(catalogName, null, null, tableTypeMapper.defaultTable_tableTypes);
                    this.handleResultSet(statement, rsTables, resultSetSchemaLocator);
                } else {
                    ResultSet rsSchemas = md.getSchemas();
                    while (rsSchemas != null && rsSchemas.next()) {
                        String schemaName = rsSchemas.getString(1);
                        String catName = rsSchemas.getString(2);
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        if (catName == null || catName.compareToIgnoreCase(catalogName) != 0) continue;
                        rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.defaultTable_tableTypes);
                        this.handleResultSet(statement, rsTables, resultSetSchemaLocator);
                    }
                    if (rsSchemas != null) {
                        rsSchemas.close();
                    }
                }
            } else {
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null != selectedSchemas) {
                    for (SchemaSelection selectedSchema : selectedSchemas) {
                        String schemaName = selectedSchema.objectName();
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        SelectionChoice<TableSelection, AllTablesSelection> tableSelections = selectedSchema.tableSelections();
                        boolean bAllTableSelected = this.m_objectSelectionsToolkit.allSelected(tableSelections);
                        if (bAllTableSelected) {
                            rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.defaultTable_tableTypes);
                            this.handleResultSet(statement, rsTables, resultSetSchemaLocator);
                            continue;
                        }
                        ReferenceableSet<TableSelection> selectedTables = tableSelections.selectedObjects();
                        if (null == selectedTables) continue;
                        for (TableSelection selectedTable : selectedTables) {
                            String tableName = selectedTable.objectName();
                            if (catalogName != null && catalogName.isEmpty()) {
                                catalogName = null;
                                this.m_applyQualifierList = true;
                            }
                            if (null != escapedSchemaName && escapedSchemaName.isEmpty()) {
                                escapedSchemaName = null;
                                this.m_applyQualifierList = true;
                            }
                            String escapedTableName = escapeObject.escape(tableName);
                            rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, escapedSchemaName, escapedTableName, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(catalogName, escapedSchemaName, escapedTableName, tableTypeMapper.defaultTable_tableTypes);
                            this.handleResultSet(statement, rsTables, resultSetSchemaLocator);
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.close(rsTables, null);
        }
    }

    private void close(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class TableInfo
    extends QualifierList.CatalogSchemaPath {
        private String description;
        private String table;

        public TableInfo(String catalog, String schema, String desc, String table) {
            super(catalog, schema);
            this.description = null;
            this.table = null;
            this.description = desc;
            this.table = table;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTable() {
            return this.table;
        }
    }
}

