/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ColumnRefElement;
import com.ibm.cognos.internal.relmd.metadata._schema.UniqueKeyElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.SchemaChildLevelExtraction;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentTableHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.UniqueKeyHandler;
import com.ibm.cognos.relmd.metadata._schema.elements.UniqueKey;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata._schema.properties.UniqueKeyColumnRef;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.UniqueKeysImport;
import com.ibm.cognos.relmd.metadata.import_.rules.UniqueKeysImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class UniqueKeysImportElem
extends ExtractionElement
implements ImportMetadataFunction,
VendorAccessResultSetHandler,
I_ChildElementHandler,
UniqueKeysImport {
    private UniqueKeysImportRules m_uniqueKeysRules;
    private UniqueKeyHandler m_uniqueKeyHandler;
    private UniqueKey m_currentUniqueKey;
    public static final String TAGNAME = "extractUniqueKeys";
    private SchemaChildLevelExtraction m_schemaChildLevelExtraction = null;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private String m_catalogName = null;
    private String m_schemaName = null;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_schemaPathHandler;
    private SessionAccess m_sessionAccess;
    private VendorAccessHandler m_vendorAccessHandler = null;
    private static final int TABLE_NAME_INDEX = 3;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public UniqueKeysImportElem() {
        super(ImportMetadataFunction.EImportFunctionType.importUniqueKeys);
    }

    public UniqueKeysImportRules uniqueKeysImportRule() {
        return this.m_uniqueKeysRules;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, UniqueKeysImportRules uniqueKeysImportRules, MetadataObjectSelections objectSelections, UniqueKeyHandler uniqueKeyHandler, ParentTableHandler parentTableHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_schemaChildLevelExtraction = null;
        this.m_uniqueKeysRules = uniqueKeysImportRules;
        this.m_uniqueKeyHandler = uniqueKeyHandler;
        this.m_schemaChildLevelExtraction = new SchemaChildLevelExtraction(parentTableHandler);
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        SessionAccessToolkit sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_sessionAccess = sessionAccessToolkit.sessionAccess(relmdConnection);
        Connection jdbcConnection = relmdConnection.jdbcConnection();
        ImportSummary summary = null;
        if (null != this.m_vendorType && this.m_vendorType == Database.EVendorType.genericHive) {
            String className = this.getClass().getName();
            summary = new ExtractionSummary(className);
        } else if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
            UniqueKeysImportElem resultSetHandler = this;
            this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
            this.m_schemaPathHandler = metadataToolkit.contextHandler(parentCatalogSchemaHandler);
            summary = this.runUniqueKeysImportGeneric(jdbcConnection, objectSelections, this.m_schemaPathHandler, this.m_uniqueKeysRules, resultSetHandler);
        } else {
            summary = this.m_schemaChildLevelExtraction.run(jdbcConnection, (QueryObjectChildIndexes)this.m_uniqueKeysRules, this.m_uniqueKeysRules.extractionQuery(), relmdConnection, objectSelections, this.m_uniqueKeysRules.objectSelectionsInclusionCollection(), this, parentCatalogSchemaHandler, (I_ChildElementHandler)this, this.m_vendorType);
        }
        return summary;
    }

    @Override
    public void done() {
        this.handleParentObjectChanged();
    }

    @Override
    public void cancel() {
        if (this.m_schemaChildLevelExtraction != null) {
            this.m_schemaChildLevelExtraction.cancel();
        }
    }

    @Override
    public void handleParentObjectChanged() {
        if (this.m_currentUniqueKey != null) {
            this.m_uniqueKeyHandler.handleUniqueKey(this.m_currentUniqueKey);
            this.m_currentUniqueKey = null;
        }
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        ColumnRefElement columnRef;
        String refColumnName = resultSetValueRetrieval.stringValue(this.m_uniqueKeysRules.refColumnRules().refColumnNameRecordIndex());
        String uniqueKeyName = resultSetValueRetrieval.stringValue(this.m_uniqueKeysRules.uniqueKeyNameRecordIndex());
        if (this.m_currentUniqueKey == null || !uniqueKeyName.equals(this.m_currentUniqueKey.objectName())) {
            if (this.m_currentUniqueKey != null) {
                this.m_uniqueKeyHandler.handleUniqueKey(this.m_currentUniqueKey);
            }
            String uniqueKeyDesc = resultSetValueRetrieval.stringValue(this.m_uniqueKeysRules.descriptionRecordIndex());
            this.m_currentUniqueKey = new UniqueKeyElem(this.m_uniqueKeysRules, uniqueKeyDesc, uniqueKeyName);
        }
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            columnRef = new ColumnRefElement("uniqueKeyColumnRef", refColumnName);
            Collection<UniqueKeyColumnRef> exportedUniqueKeyRefCollection = this.m_currentUniqueKey.uniqueKeyColumnRefsCollection();
            exportedUniqueKeyRefCollection.add(columnRef);
        } else {
            columnRef = new ColumnRefElement("uniqueKeyColumnRef", resultSetValueRetrieval, this.m_uniqueKeysRules.refColumnRules());
            Collection<UniqueKeyColumnRef> exportedUniqueKeyRefCollection = this.m_currentUniqueKey.uniqueKeyColumnRefsCollection();
            exportedUniqueKeyRefCollection.add(columnRef);
        }
    }

    @Override
    public ImportSummary run(VendorAccessConnection connection, MetadataImportRules extractionRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        return this.run(connection, extractionRules.uniqueKeysImportRules(), objectSelections, modelElementHandler, modelElementHandler, modelElementHandler);
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private ExtractionSummary runUniqueKeysImportGeneric(Connection connection, MetadataObjectSelections metadataObjectSelections, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        String className = this.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Relmd relmd = RelmdGateway.relmd();
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        ResultSet rsTables = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            if (bAllCatalogsSelected) {
                rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(null, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(null, null, null, tableTypeMapper.defaultTable_tableTypes);
                ArrayList<Object> tableNames = new ArrayList<Object>();
                while (rsTables != null && rsTables.next()) {
                    String tableName = rsTables.getString(3);
                    tableNames.add(tableName);
                }
                if (rsTables != null) {
                    rsTables.close();
                }
                for (String string : tableNames) {
                    summary = this.getUniqueKeysGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                }
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                } else {
                    for (CatalogSelection catalogSelection : selectedCatalogs) {
                        this.m_catalogName = catalogSelection.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = catalogSelection.schemaSelections();
                        this.handleSchemaSelections(connection, schemaSelections, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return summary;
    }

    private ExtractionSummary handleSchemaSelections(Connection connection, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        block12: {
            boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
            try {
                DatabaseMetaData md = connection.getMetaData();
                TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
                ResultSet rsTables = null;
                if (bAllSchemaSelected) {
                    rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(this.m_catalogName, null, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(this.m_catalogName, null, null, tableTypeMapper.defaultTable_tableTypes);
                    while (rsTables != null && rsTables.next()) {
                        String tableName = rsTables.getString(3);
                        summary = this.getUniqueKeysGeneric(connection, tableName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                    break block12;
                }
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null == selectedSchemas) break block12;
                EscapeObjectName escapeObject = new EscapeObjectName(md);
                for (SchemaSelection selectedSchema : selectedSchemas) {
                    this.m_schemaName = selectedSchema.objectName();
                    QualifierList.CatalogSchemaPath cs = this.getQualifiedCatalogSchema();
                    if (null != this.m_catalogName && this.m_catalogName.isEmpty() && null != cs && null != cs.getCatalog()) {
                        this.m_catalogName = cs.getCatalog();
                    }
                    if (null != this.m_schemaName && this.m_schemaName.isEmpty() && null != cs && null != cs.getSchema()) {
                        this.m_schemaName = cs.getSchema();
                    }
                    String escapedSchemaName = escapeObject.escape(this.m_schemaName);
                    SelectionChoice<TableSelection, AllTablesSelection> tableSelections = selectedSchema.tableSelections();
                    boolean bAllTablesSelected = this.m_objectSelectionsToolkit.allSelected(tableSelections);
                    if (bAllTablesSelected) {
                        rsTables = md instanceof IAdaptorDBMetadata ? md.getTables(this.m_catalogName, escapedSchemaName, null, tableTypeMapper.getListOfTable_TableTypes()) : md.getTables(this.m_catalogName, escapedSchemaName, null, tableTypeMapper.defaultTable_tableTypes);
                        ArrayList<Object> tableNames = new ArrayList<Object>();
                        while (rsTables != null && rsTables.next()) {
                            String tableName = rsTables.getString(3);
                            tableNames.add(tableName);
                        }
                        if (rsTables != null) {
                            rsTables.close();
                        }
                        for (String string : tableNames) {
                            summary = this.getUniqueKeysGeneric(connection, string, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                        }
                        continue;
                    }
                    ReferenceableSet<TableSelection> selectedTables = tableSelections.selectedObjects();
                    if (null == selectedTables) continue;
                    for (TableSelection tableSelection : selectedTables) {
                        String tableName = tableSelection.objectName();
                        summary = this.getUniqueKeysGeneric(connection, tableName, summary, parentCatalogSchemaHandler, queryObjectChildRules, resultSetHandler);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExtractionSummary getUniqueKeysGeneric(Connection connection, String tableName, ExtractionSummary summary, Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, VendorAccessResultSetHandler resultSetHandler) {
        Statement statement = null;
        ResultSet rsUniqueKeys = null;
        try {
            DatabaseMetaData md = connection.getMetaData();
            statement = connection.createStatement();
            if (this.m_catalogName != null && this.m_catalogName.isEmpty()) {
                this.m_catalogName = null;
            }
            if (this.m_schemaName != null && this.m_schemaName.isEmpty()) {
                this.m_schemaName = null;
            }
            rsUniqueKeys = md.getPrimaryKeys(this.m_catalogName, this.m_schemaName, tableName);
            RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsUniqueKeys, this.m_vendorAccessHandler);
            summary = this.m_schemaChildLevelExtraction.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, relmdResultSet, this, resultSetHandler, Database.EVendorType.generic);
            this.m_schemaChildLevelExtraction.close(rsUniqueKeys, statement);
        }
        catch (SQLException sQLException) {
            this.m_schemaChildLevelExtraction.close(rsUniqueKeys, statement);
            catch (Throwable throwable) {
                this.m_schemaChildLevelExtraction.close(rsUniqueKeys, statement);
                throw throwable;
            }
        }
        this.done();
        return summary;
    }
}

