/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions;

import com.ibm.cognos.internal.relmd.metadata._schema.ViewElem;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionElement;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.utilities.QualifierList;
import com.ibm.cognos.internal.relmd.utilities.TableTypeMapper;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.View;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.MetadataElementHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.elements.ViewHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ParentCatalogSchema;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.MetadataImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportMetadataFunction;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportRules;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.functions.ViewsImport;
import com.ibm.cognos.relmd.metadata.import_.rules.ViewsImportRules;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import com.ibm.cognos.relmd.session.SessionToolkit;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.access.SessionAccessToolkit;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public class ViewsImportElem
extends ExtractionElement
implements ViewsImport,
VendorAccessResultSetHandler,
I_ChildElementHandler {
    private ViewsImportRules m_viewsRules;
    private VendorAccessResultSet m_resultSet;
    private SessionAccess m_sessionAccess;
    private MetadataImportSelectionsChoice m_objectSelectionsChoice;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private Handler<SchemaPath> m_contextHandler;
    private Handler<View> m_objectHandler;
    private MetadataToolkit m_metadataToolkit;
    private SessionAccessToolkit m_sessionAccessToolkit;
    private ExtractionSummary m_importSummary;
    private Database.EVendorType m_vendorType;
    private Database.EVendorType m_rawVendorType;
    private boolean m_applyQualifierList = false;
    ArrayList<QualifierList.CatalogSchemaPath> m_qualifierList = null;
    QualifierList.CatalogSchemaPath m_qualifiedCatalogSchema = null;

    public ViewsImportElem(SessionAccess sessionAccess, MetadataImportSelectionsChoice objectSelectionsChoice, ViewsImportRules viewsRules, Handler<SchemaPath> contextHandler, Handler<View> objectHandler) {
        super(ImportMetadataFunction.EImportFunctionType.importViews);
        Relmd relmd = RelmdGateway.relmd();
        SessionToolkit sessionToolkit = relmd.sessionToolkit();
        this.m_sessionAccessToolkit = sessionToolkit.sessionAccessToolkit();
        this.m_metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = this.m_metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_viewsRules = viewsRules;
        this.m_sessionAccess = sessionAccess;
        this.m_objectSelectionsChoice = objectSelectionsChoice;
        this.m_contextHandler = contextHandler;
        this.m_objectHandler = objectHandler;
        this.m_importSummary = null;
    }

    public ViewsImportElem() {
        this(null, null, null, null, null);
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, ViewsImportRules viewsImportRules, MetadataObjectSelections objectSelections, final ViewHandler viewHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler) {
        this.m_importSummary = new ExtractionSummary(this.getClass().getName());
        this.m_importSummary.start();
        this.m_resultSet = null;
        this.m_objectHandler = new Handler<View>(){

            @Override
            public void handle(View obj) {
                View view = obj;
                viewHandler.handleView(view);
            }
        };
        this.m_viewsRules = viewsImportRules;
        this.m_sessionAccess = this.m_sessionAccessToolkit.sessionAccess(relmdConnection);
        this.m_objectSelectionsChoice = this.m_objectSelectionsToolkit.metadataImportSelectionsChoice(objectSelections);
        this.m_contextHandler = this.m_metadataToolkit.contextHandler(parentCatalogSchemaHandler);
        Connection connection = relmdConnection.jdbcConnection();
        this.run(connection);
        this.m_importSummary.stop();
        return this.m_importSummary;
    }

    @Override
    public ImportSummary run(VendorAccessConnection relmdConnection, MetadataImportRules extractionRules, MetadataObjectSelections objectSelections, MetadataElementHandler modelElementHandler) {
        ViewsImportRules viewsImportRules = extractionRules.viewsImportRules();
        return this.run(relmdConnection, viewsImportRules, objectSelections, modelElementHandler, modelElementHandler);
    }

    public ViewsImportRules viewImportRule() {
        return this.m_viewsRules;
    }

    @Override
    public void done() {
    }

    @Override
    public void cancel() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void handleParentObjectChanged() {
    }

    @Override
    public void handleResultSetRecord(VendorAccessResultSetValues resultSetValueRetrieval) {
        ViewElem view = new ViewElem(this.m_viewsRules, resultSetValueRetrieval);
        this.m_objectHandler.handle(view);
    }

    public void handleResultSetRecord(String desc, String viewName) {
        ViewElem view = new ViewElem(desc, viewName, true);
        this.m_objectHandler.handle(view);
    }

    public void run(Connection jdbcConnection, SessionAccess access, ViewsImportRules viewsImportRules, SqlObjectQueryPath sqlObjectQueryPath, Handler<View> viewHandler, Handler<ParentCatalogSchema> parentCatalogSchemaHandler) {
    }

    @Override
    public ImportRules<View> importRules() {
        ImportRules<View> viewsImportRules = this.m_viewsRules.viewsImportRules();
        return viewsImportRules;
    }

    @Override
    public MetadataImportSelectionsChoice metadataImportSelectionsChoice() {
        return this.m_objectSelectionsChoice;
    }

    @Override
    public SessionAccess sessionAccess() {
        return this.m_sessionAccess;
    }

    @Override
    public void run(Connection connection) {
        this.m_resultSet = null;
        VendorAccess m_extractionQuery = this.m_viewsRules.extractionQuery();
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (this.m_contextHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)this.m_viewsRules, this.m_contextHandler, (I_ChildElementHandler)this);
        }
        Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection = this.m_viewsRules.objectSelectionsInclusionCollection();
        if (null != this.m_vendorType && this.m_vendorType.toString().indexOf("generic") != -1) {
            this.runForGeneric(connection, resultSetSchemaLocator);
            this.m_importSummary.viewsCount(this.m_importSummary.rowsProcessed());
            return;
        }
        this.m_resultSet = m_extractionQuery.run(connection, this.m_sessionAccess, this.m_objectSelectionsChoice, objectSelectionsInclusionCollection);
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            this.m_importSummary.incrementRowCount();
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
            }
            this.handleResultSetRecord(resultSetValueRetrieval);
        }
        this.m_importSummary.viewsCount(this.m_importSummary.rowsProcessed());
    }

    @Override
    public void stop() {
    }

    @Override
    public Handler<SchemaPath> contextHandler() {
        return this.m_contextHandler;
    }

    @Override
    public Handler<View> objectHandler() {
        return this.m_objectHandler;
    }

    @Override
    public void setVendorType(Database.EVendorType vendorType) {
        this.m_vendorType = vendorType;
    }

    @Override
    public void setRawVendorType(Database.EVendorType rawVendorType) {
        this.m_rawVendorType = rawVendorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runForGeneric(Connection connection, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        Statement statement = null;
        ResultSet rsViews = null;
        try {
            statement = connection.createStatement();
            DatabaseMetaData md = connection.getMetaData();
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            MetadataObjectSelections metadataObjectSelections = this.m_objectSelectionsChoice.metadataObjectSelections();
            SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = metadataObjectSelections.catalogSelections();
            boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
            if (bAllCatalogsSelected) {
                rsViews = md instanceof IAdaptorDBMetadata ? md.getTables(null, null, null, tableTypeMapper.getListOfView_TableTypes()) : md.getTables(null, null, null, tableTypeMapper.defaultView_tableTypes);
                this.handleResultSet(statement, rsViews, resultSetSchemaLocator);
            } else {
                ReferenceableSet<CatalogSelection> selectedCatalogs = catalogSelections.selectedObjects();
                if (selectedCatalogs.isEmpty()) {
                    SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = metadataObjectSelections.schemaSelections();
                    this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, null);
                } else {
                    for (CatalogSelection selectedCatalog : selectedCatalogs) {
                        String catalogName = selectedCatalog.objectName();
                        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = selectedCatalog.schemaSelections();
                        this.handleSchemaSelections(statement, md, resultSetSchemaLocator, schemaSelections, catalogName);
                    }
                }
            }
            this.close(rsViews, statement);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
        finally {
            this.close(rsViews, statement);
        }
    }

    private void handleResultSet(Statement statement, ResultSet rsViews, ParentSchemaReferenceProcessor resultSetSchemaLocator) {
        ViewInfo viewInfo;
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsViews, vendorAccessHandler);
        this.m_resultSet = relmdResultSet;
        ArrayList<ViewInfo> viewInfoList = new ArrayList<ViewInfo>();
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            String catalogName = resultSetValueRetrieval.stringValue(this.m_viewsRules.parentCatalogNameRecordIndex());
            String schemaName = resultSetValueRetrieval.stringValue(this.m_viewsRules.parentSchemaNameRecordIndex());
            String tableName = resultSetValueRetrieval.stringValue(this.m_viewsRules.nameRecordIndex());
            String description = resultSetValueRetrieval.stringValue(this.m_viewsRules.descriptionRecordIndex());
            ViewInfo viewInfo2 = new ViewInfo(catalogName, schemaName, description, tableName);
            viewInfoList.add(viewInfo2);
        }
        ArrayList<QualifierList.CatalogSchemaPath> qualifierList = this.getQualifierList();
        if (null == qualifierList) {
            this.m_applyQualifierList = false;
        }
        if (this.m_applyQualifierList && null != (viewInfo = this.findViewInfoWithQualifierList(viewInfoList, qualifierList))) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(viewInfo.getCatalog(), viewInfo.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(viewInfo.getDescription(), viewInfo.getView());
            return;
        }
        for (ViewInfo viewInfo3 : viewInfoList) {
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(viewInfo3.getCatalog(), viewInfo3.getSchema());
            }
            this.m_importSummary.incrementRowCount();
            this.handleResultSetRecord(viewInfo3.getDescription(), viewInfo3.getView());
        }
    }

    @Override
    public ArrayList<QualifierList.CatalogSchemaPath> getQualifierList() {
        return this.m_qualifierList;
    }

    @Override
    public void setQualifierList(ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        this.m_qualifierList = qualifierList;
    }

    @Override
    public QualifierList.CatalogSchemaPath getQualifiedCatalogSchema() {
        return this.m_qualifiedCatalogSchema;
    }

    @Override
    public void setQualifiedCatalogSchema(QualifierList.CatalogSchemaPath qualifiedCatalogSchema) {
        this.m_qualifiedCatalogSchema = qualifiedCatalogSchema;
    }

    private ViewInfo findViewInfoWithQualifierList(ArrayList<ViewInfo> viewInfoList, ArrayList<QualifierList.CatalogSchemaPath> qualifierList) {
        if (1 == viewInfoList.size()) {
            ViewInfo viewInfo = viewInfoList.get(0);
            QualifierList.CatalogSchemaPath cs = new QualifierList.CatalogSchemaPath(viewInfo.getCatalog(), viewInfo.getSchema());
            this.setQualifiedCatalogSchema(cs);
            return viewInfo;
        }
        if (0 >= viewInfoList.size()) {
            return null;
        }
        boolean matching = false;
        for (QualifierList.CatalogSchemaPath qualifier : qualifierList) {
            String qualifierCatalogName = qualifier.getCatalog();
            String qualifierSchemaName = qualifier.getSchema();
            for (ViewInfo viewInfo : viewInfoList) {
                String catalogValue = viewInfo.getCatalog();
                String schemaValue = viewInfo.getSchema();
                if (null == qualifierCatalogName && null != qualifierSchemaName) {
                    matching = qualifierSchemaName.equals(schemaValue);
                } else if (null != qualifierCatalogName && null == qualifierSchemaName) {
                    matching = qualifierCatalogName.equals(catalogValue);
                } else if (null == qualifierCatalogName && null == qualifierSchemaName) {
                    matching = false;
                } else {
                    boolean bl = matching = qualifierSchemaName.equals(schemaValue) && qualifierCatalogName.equals(catalogValue);
                }
                if (!matching) continue;
                this.setQualifiedCatalogSchema(qualifier);
                return viewInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSchemaSelections(Statement statement, DatabaseMetaData md, ParentSchemaReferenceProcessor resultSetSchemaLocator, SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections, String catalogName) {
        boolean bAllSchemaSelected = this.m_objectSelectionsToolkit.allSelected(schemaSelections);
        ResultSet rsViews = null;
        try {
            TableTypeMapper tableTypeMapper = new TableTypeMapper(md);
            if (bAllSchemaSelected) {
                rsViews = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, null, null, tableTypeMapper.getListOfView_TableTypes()) : md.getTables(catalogName, null, null, tableTypeMapper.defaultView_tableTypes);
                this.handleResultSet(statement, rsViews, resultSetSchemaLocator);
            } else {
                ReferenceableSet<SchemaSelection> selectedSchemas = schemaSelections.selectedObjects();
                if (null != selectedSchemas) {
                    EscapeObjectName escapeObject = new EscapeObjectName(md);
                    for (SchemaSelection selectedSchema : selectedSchemas) {
                        String schemaName = selectedSchema.objectName();
                        String escapedSchemaName = escapeObject.escape(schemaName);
                        SelectionChoice<ViewSelection, AllViewsSelection> viewSelections = selectedSchema.viewSelections();
                        boolean bAllViewSelected = this.m_objectSelectionsToolkit.allSelected(viewSelections);
                        if (bAllViewSelected) {
                            rsViews = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.getListOfView_TableTypes()) : md.getTables(catalogName, escapedSchemaName, null, tableTypeMapper.defaultView_tableTypes);
                            this.handleResultSet(statement, rsViews, resultSetSchemaLocator);
                            continue;
                        }
                        ReferenceableSet<ViewSelection> selectedViews = viewSelections.selectedObjects();
                        if (null == selectedViews) continue;
                        for (ViewSelection selectedView : selectedViews) {
                            String viewName = selectedView.objectName();
                            String escapedViewName = escapeObject.escape(viewName);
                            if (catalogName != null && catalogName.isEmpty()) {
                                catalogName = null;
                                this.m_applyQualifierList = true;
                            }
                            if (escapedSchemaName != null && escapedSchemaName.isEmpty()) {
                                escapedSchemaName = null;
                                this.m_applyQualifierList = true;
                            }
                            rsViews = md instanceof IAdaptorDBMetadata ? md.getTables(catalogName, escapedSchemaName, escapedViewName, tableTypeMapper.getListOfView_TableTypes()) : md.getTables(catalogName, escapedSchemaName, escapedViewName, tableTypeMapper.defaultView_tableTypes);
                            this.handleResultSet(statement, rsViews, resultSetSchemaLocator);
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.close(rsViews, null);
        }
    }

    private void close(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private class ViewInfo
    extends QualifierList.CatalogSchemaPath {
        private String description;
        private String view;

        public ViewInfo(String catalog, String schema, String desc, String view) {
            super(catalog, schema);
            this.description = null;
            this.view = null;
            this.description = desc;
            this.view = view;
        }

        public String getDescription() {
            return this.description;
        }

        public String getView() {
            return this.view;
        }
    }
}

