/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions;

import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.ExtractionSummary;
import com.ibm.cognos.internal.relmd.metadata.import_.functions.extractions.ParentSchemaReferenceProcessor;
import com.ibm.cognos.internal.relmd.metadata.import_.handlers.I_ChildElementHandler;
import com.ibm.cognos.internal.relmd.utilities.EscapeObjectName;
import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentCatalogSchemaHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentRoutineHandler;
import com.ibm.cognos.relmd.metadata._schema._handlers.containment.ParentTableHandler;
import com.ibm.cognos.relmd.metadata._schema.properties.ColumnContainerObjectRef;
import com.ibm.cognos.relmd.metadata._schema.properties.SchemaLevelObjectRef;
import com.ibm.cognos.relmd.metadata.import_.functions.ImportSummary;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.QueryObjectChildIndexes;
import com.ibm.cognos.relmd.metadata.import_.rules.resultset.SchemaChildIndexes;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetHandler;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;

public class SchemaChildLevelExtraction
implements I_ChildElementHandler {
    private VendorAccessResultSetHandler m_resultSetHandler = null;
    private VendorAccessResultSet m_resultSet = null;
    private String m_currentSchemaObjectName = null;
    private Handler<SchemaLevelObjectRef> m_schemaLevelObjectRefHandler = null;
    private I_ChildElementHandler m_childElementHandler = null;

    public SchemaChildLevelExtraction(final ParentRoutineHandler parentRoutineHandler) {
        this.m_schemaLevelObjectRefHandler = new Handler<SchemaLevelObjectRef>(){

            @Override
            public void handle(SchemaLevelObjectRef obj) {
                if (null != parentRoutineHandler) {
                    String objectName = obj.objectName();
                    parentRoutineHandler.handleParentRoutineReference(objectName);
                }
            }
        };
    }

    public SchemaChildLevelExtraction(final ParentTableHandler parentTableHandler) {
        this.m_schemaLevelObjectRefHandler = new Handler<SchemaLevelObjectRef>(){

            @Override
            public void handle(SchemaLevelObjectRef obj) {
                if (null != parentTableHandler) {
                    String objectName = obj.objectName();
                    parentTableHandler.handleParentTableReference(objectName);
                }
            }
        };
    }

    public SchemaChildLevelExtraction(final Handler<ColumnContainerObjectRef> columnContainerObjectRefHandler) {
        Relmd relmd = RelmdGateway.relmd();
        final MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_schemaLevelObjectRefHandler = new Handler<SchemaLevelObjectRef>(){

            @Override
            public void handle(SchemaLevelObjectRef obj) {
                ColumnContainerObjectRef columnContainerObjectRef = metadataToolkit.columnContainerObjectRef(obj);
                columnContainerObjectRefHandler.handle(columnContainerObjectRef);
            }
        };
    }

    public ImportSummary run(Connection connection, QueryObjectChildIndexes queryObjectChildRules, VendorAccess extractionQuery, VendorAccessConnection relmdConnection, MetadataObjectSelections databaseObjectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionRulesCollection, VendorAccessResultSetHandler resultSetHandler, ParentCatalogSchemaHandler parentCatalogSchemaHandler, I_ChildElementHandler childElementHandler, Database.EVendorType vendorType) {
        this.m_resultSetHandler = resultSetHandler;
        this.m_childElementHandler = childElementHandler;
        String className = this.m_resultSetHandler.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        this.m_resultSet = extractionQuery.run(relmdConnection, databaseObjectSelections, objectSelectionsInclusionRulesCollection);
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (parentCatalogSchemaHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)queryObjectChildRules, parentCatalogSchemaHandler, (I_ChildElementHandler)this);
        }
        int rowCount = 0;
        VendorAccessResultSetIterator resultSetIterator = this.m_resultSet.iterator();
        while (resultSetIterator.next()) {
            ++rowCount;
            summary.incrementRowCount();
            VendorAccessResultSetValues resultSetValueRetrieval = this.m_resultSet.values();
            if (resultSetSchemaLocator != null) {
                resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
            }
            int queryObjectNameRecordIndex = queryObjectChildRules.queryObjectNameRecordIndex();
            final String schemaObjectName = resultSetValueRetrieval.stringValue(queryObjectNameRecordIndex);
            if (this.m_currentSchemaObjectName == null || !this.m_currentSchemaObjectName.equals(schemaObjectName)) {
                this.m_childElementHandler.handleParentObjectChanged();
                SchemaLevelObjectRef schemaObjectRef = new SchemaLevelObjectRef(){

                    @Override
                    public String objectName() {
                        return schemaObjectName;
                    }
                };
                this.m_schemaLevelObjectRefHandler.handle(schemaObjectRef);
                this.m_currentSchemaObjectName = schemaObjectName;
            }
            this.m_resultSetHandler.handleResultSetRecord(resultSetValueRetrieval);
        }
        this.done();
        summary.stop();
        return summary;
    }

    @Override
    public void done() {
        this.m_resultSetHandler.done();
    }

    public void cancel() {
        this.m_resultSet.close();
    }

    @Override
    public void handleParentObjectChanged() {
        this.m_childElementHandler.handleParentObjectChanged();
        this.m_currentSchemaObjectName = null;
    }

    public ImportSummary run(Connection connection, QueryObjectChildIndexes queryObjectChildRules, VendorAccess extractionQuery, SessionAccess relmdConnection, MetadataImportSelectionsChoice metadataImportSelectionsChoice, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection, Handler<SchemaPath> parentCatalogSchemaHandler, VendorAccessResultSetHandler resultSetHandler, I_ChildElementHandler childElementHandler, Database.EVendorType vendorType) {
        this.m_resultSetHandler = resultSetHandler;
        this.m_childElementHandler = childElementHandler;
        String className = this.m_resultSetHandler.getClass().getName();
        ExtractionSummary summary = new ExtractionSummary(className);
        summary.start();
        Statement statement = null;
        ResultSet rsColumns = null;
        try {
            if (null != vendorType && vendorType.toString().indexOf("generic") != -1) {
                DatabaseMetaData md = connection.getMetaData();
                statement = connection.createStatement();
                VendorAccessResults vendorAccessResults = relmdConnection.vendorAccessResults();
                VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
                MetadataImportSelectionsChoice.EChoice choice = metadataImportSelectionsChoice.choice();
                if (choice.equals((Object)MetadataImportSelectionsChoice.EChoice.sqlObjectQueryPath)) {
                    SqlObjectQueryPath sqlObjectQueryPath = metadataImportSelectionsChoice.sqlObjectQueryPath();
                    String catalogName = sqlObjectQueryPath.schemaPath().parentCatalogName();
                    String schemaName = sqlObjectQueryPath.schemaPath().parentSchemaName();
                    String objectName = sqlObjectQueryPath.objectName();
                    EscapeObjectName escapeObject = new EscapeObjectName(md);
                    String escapedSchemaName = escapeObject.escape(schemaName);
                    String escapedObjectName = escapeObject.escape(objectName);
                    rsColumns = md.getColumns(catalogName, escapedSchemaName, escapedObjectName, null);
                    RelmdResultSet relmdResultSet = new RelmdResultSet(statement, rsColumns, vendorAccessHandler);
                    this.m_resultSet = relmdResultSet;
                }
            } else {
                this.m_resultSet = extractionQuery.run(connection, relmdConnection, metadataImportSelectionsChoice, objectSelectionsInclusionCollection);
            }
        }
        catch (SQLException e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
        }
        summary = this.handleResultSet(parentCatalogSchemaHandler, queryObjectChildRules, summary, this.m_resultSet, this.m_childElementHandler, this.m_resultSetHandler, vendorType);
        this.done();
        summary.stop();
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
        return summary;
    }

    public ExtractionSummary handleResultSet(Handler<SchemaPath> parentCatalogSchemaHandler, QueryObjectChildIndexes queryObjectChildRules, ExtractionSummary summary, VendorAccessResultSet resultSet, I_ChildElementHandler childElementHandler, VendorAccessResultSetHandler resultSetHandler, Database.EVendorType vendorType) {
        this.m_resultSetHandler = resultSetHandler;
        this.m_childElementHandler = childElementHandler;
        ParentSchemaReferenceProcessor resultSetSchemaLocator = null;
        if (parentCatalogSchemaHandler != null) {
            resultSetSchemaLocator = new ParentSchemaReferenceProcessor((SchemaChildIndexes)queryObjectChildRules, parentCatalogSchemaHandler, (I_ChildElementHandler)this);
        }
        int rowCount = 0;
        if (resultSet != null) {
            VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
            while (resultSetIterator.next()) {
                ++rowCount;
                summary.incrementRowCount();
                VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
                if (resultSetSchemaLocator != null) {
                    resultSetSchemaLocator.handleResultSetRecord(resultSetValueRetrieval);
                }
                int queryObjectNameRecordIndex = queryObjectChildRules.queryObjectNameRecordIndex();
                if (null != vendorType && vendorType.toString().indexOf("generic") != -1) {
                    boolean bForeignKeysImport;
                    String className = this.m_resultSetHandler.getClass().getName();
                    boolean bl = bForeignKeysImport = className.indexOf("ForeignKeys") != -1;
                    if (bForeignKeysImport) {
                        queryObjectNameRecordIndex = 7;
                    }
                }
                final String schemaObjectName = resultSetValueRetrieval.stringValue(queryObjectNameRecordIndex);
                if (this.m_currentSchemaObjectName == null || !this.m_currentSchemaObjectName.equals(schemaObjectName)) {
                    childElementHandler.handleParentObjectChanged();
                    SchemaLevelObjectRef schemaObjectRef = new SchemaLevelObjectRef(){

                        @Override
                        public String objectName() {
                            return schemaObjectName;
                        }
                    };
                    this.m_schemaLevelObjectRefHandler.handle(schemaObjectRef);
                    this.m_currentSchemaObjectName = schemaObjectName;
                }
                resultSetHandler.handleResultSetRecord(resultSetValueRetrieval);
            }
        }
        return summary;
    }

    public void close(ResultSet rs, Statement stmt) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
            }
        }
    }
}

