/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.session.query.functions;

import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.RelmdSqlExecution;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdElement;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.Catalog;
import com.ibm.cognos.relmd.session.query.functions.CurrentCatalogSetup;
import com.ibm.cognos.relmd.session.query.rules.CatalogGranularityRules;
import com.ibm.cognos.relmd.session.query.rules.CurrentCatalogRetrievalRules;
import com.ibm.cognos.relmd.session.query.rules.CurrentCatalogSetRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginJava;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionInformation;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingInformation;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.vendor.access.rules.sql.CatalogGrainSql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.Sql;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;

public class CurrentCatalogSetupElem
implements CurrentCatalogSetup {
    private final CatalogGranularityRules m_catalogGranularityRules;
    private final String m_catalogName;
    private String m_originalCatalog;
    private VendorAccessConnection m_vendorAccessConnection;
    private final VendorAccessHandler m_vendorAccessHandler;
    private boolean m_ok = true;
    private VendorToolkit m_vendorToolkit;
    private VendorAccessToolkit m_vendorAccessToolkit;

    public CurrentCatalogSetupElem(CatalogGranularityRules catalogGranularityRules, String catalogName, final VendorAccessHandler vendorAccessHandler) {
        this.m_catalogGranularityRules = catalogGranularityRules;
        this.m_catalogName = catalogName;
        this.m_originalCatalog = null;
        this.m_vendorAccessConnection = null;
        final Handler<ExecutionError> orig = vendorAccessHandler.executionErrorHandler();
        final Handler<ExecutionError> executionErrorHandler = new Handler<ExecutionError>(){

            @Override
            public void handle(ExecutionError obj) {
                CurrentCatalogSetupElem.this.m_ok = false;
                orig.handle(obj);
            }
        };
        final Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = new Handler<ResultSetProcessingError>(){

            @Override
            public void handle(ResultSetProcessingError obj) {
                CurrentCatalogSetupElem.this.m_ok = false;
                Handler<ResultSetProcessingError> orig = CurrentCatalogSetupElem.this.m_vendorAccessHandler.resultSetProcessingErrorHandler();
                orig.handle(obj);
            }
        };
        this.m_vendorAccessHandler = new VendorAccessHandler(){
            private Handler<BeginJava> m_beginJavaHandler;
            private Handler<BeginSql> m_beginSqlHandler;
            private Handler<ExecutionInformation> m_executionInformationHandler;
            private Handler<ResultSetProcessingInformation> m_resultSetProcessingInformationHandler;
            {
                this.m_beginJavaHandler = vendorAccessHandler.beginJavaHandler();
                this.m_beginSqlHandler = vendorAccessHandler.beginSqlHandler();
                this.m_executionInformationHandler = vendorAccessHandler.executionInformationHandler();
                this.m_resultSetProcessingInformationHandler = vendorAccessHandler.resultSetProcessingInformationHandler();
            }

            @Override
            public Handler<BeginJava> beginJavaHandler() {
                return this.m_beginJavaHandler;
            }

            @Override
            public Handler<BeginSql> beginSqlHandler() {
                return this.m_beginSqlHandler;
            }

            @Override
            public Handler<ExecutionError> executionErrorHandler() {
                return executionErrorHandler;
            }

            @Override
            public Handler<ExecutionInformation> executionInformationHandler() {
                return this.m_executionInformationHandler;
            }

            @Override
            public Handler<ResultSetProcessingError> resultSetProcessingErrorHandler() {
                return resultSetProcessingErrorHandler;
            }

            @Override
            public Handler<ResultSetProcessingInformation> resultSetProcessingInformationHandler() {
                return this.m_resultSetProcessingInformationHandler;
            }
        };
        Relmd relmd = RelmdGateway.relmd();
        this.m_vendorToolkit = relmd.vendorToolkit();
        this.m_vendorAccessToolkit = this.m_vendorToolkit.vendorAccessToolkit();
    }

    @Override
    public void run(Connection connection) {
        this.m_ok = true;
        this.m_vendorAccessConnection = this.m_vendorToolkit.vendorAccessConnection(connection, this.m_vendorAccessHandler, null);
        if (null != this.m_catalogGranularityRules) {
            this.m_originalCatalog = this.currentCatalog();
            Handler<ExecutionInformation> executionInformationHandler = this.m_vendorAccessHandler.executionInformationHandler();
            ExecutionInformation executionInformationRunBegin = this.m_vendorAccessToolkit.executionInformation("CurrentCatalogSetupElem.run() m_catalogName: " + this.m_catalogName + "; m_originalCatalog: " + this.m_originalCatalog);
            executionInformationHandler.handle(executionInformationRunBegin);
            if (null != this.m_catalogName) {
                CurrentCatalogSetRules catalogSetRules = this.m_catalogGranularityRules.catalogSetRules();
                this.setCurrentCatalog(this.m_vendorAccessConnection, this.m_catalogName, catalogSetRules);
            }
        }
    }

    public boolean ok() {
        return this.m_ok;
    }

    @Override
    public void stop() {
        if (null != this.m_catalogGranularityRules) {
            Handler<ExecutionInformation> executionInformationHandler = this.m_vendorAccessHandler.executionInformationHandler();
            ExecutionInformation executionInformationRunBegin = this.m_vendorAccessToolkit.executionInformation("CurrentCatalogSetupElem.stop() m_catalogName: " + this.m_catalogName + "; m_originalCatalog: " + this.m_originalCatalog);
            executionInformationHandler.handle(executionInformationRunBegin);
            CurrentCatalogSetRules catalogSet = this.m_catalogGranularityRules.catalogSetRules();
            this.setCurrentCatalog(this.m_vendorAccessConnection, this.m_originalCatalog, catalogSet);
        }
    }

    private void setCurrentCatalog(VendorAccessConnection relmdConnection, String parentCatalogName, CurrentCatalogSetRules catalogSetRules) {
        if (null != parentCatalogName) {
            CatalogGrainSql catalogGrainSql = catalogSetRules.catalogGrainSql();
            RelmdSqlExecution sqlExecution = new RelmdSqlExecution(relmdConnection);
            String sqlText = catalogGrainSql.value();
            sqlText = sqlText.replace("catalogSubstitution", parentCatalogName);
            sqlExecution.run(sqlText);
        }
    }

    private String currentCatalog() {
        RelmdSqlExecution sqlExecution = new RelmdSqlExecution(this.m_vendorAccessConnection);
        CurrentCatalogRetrievalRules catalogRetrieval = this.m_catalogGranularityRules.catalogRetrievalRules();
        Sql sql = catalogRetrieval.sql();
        String sqlText = sql.value();
        VendorAccessResultSet resultSet = sqlExecution.run(sqlText);
        VendorAccessResultSetIterator resultSetIterator = resultSet.iterator();
        String catalog = null;
        if (resultSetIterator.next()) {
            VendorAccessResultSetValues resultSetValueRetrieval = resultSet.values();
            catalog = resultSetValueRetrieval.stringValue(1);
        }
        resultSet.close();
        return catalog;
    }

    @Override
    public CatalogGranularityRules catalogGranularityRules() {
        return this.m_catalogGranularityRules;
    }

    @Override
    public VendorAccessHandler vendorAccessHandler() {
        return this.m_vendorAccessHandler;
    }

    @Override
    public XmlElement asXml() {
        RelmdElement relmdElement = new RelmdElement("currentCatalogSetup");
        return relmdElement;
    }

    public void handle(Catalog obj) {
    }
}

