/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.utilities;

import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class QualifierList {
    VendorAccessConnection m_relmdConnection = null;
    ArrayList<CatalogSchemaPath> m_qualifierList = null;

    public QualifierList(VendorAccessConnection relmdConnection) {
        this.m_relmdConnection = relmdConnection;
    }

    public boolean hasQualifierListInConnection(VendorAccessConnection relmdConnection) {
        return relmdConnection instanceof IAdaptorConnection && ((IAdaptorConnection)relmdConnection).getQualifierList() != null;
    }

    public ArrayList<CatalogSchemaPath> getQualifierList() {
        Connection jdbcConnection = this.m_relmdConnection.jdbcConnection();
        if (!(jdbcConnection instanceof IAdaptorConnection) || ((IAdaptorConnection)jdbcConnection).getQualifierList() == null) {
            return null;
        }
        boolean schemaSupport = true;
        try {
            DatabaseMetaData md = this.m_relmdConnection.jdbcConnection().getMetaData();
            String schemaTerm = md.getSchemaTerm();
            if (schemaTerm == null || schemaTerm.isEmpty()) {
                schemaSupport = false;
            }
        }
        catch (SQLException schemaTerm) {
            // empty catch block
        }
        ArrayList<CatalogSchemaPath> qualifierList = new ArrayList<CatalogSchemaPath>();
        Database.ECatalogSupport catalogSupport = this.m_relmdConnection.sessionQueryRules().catalogSupport();
        List qualifierStringList = ((IAdaptorConnection)jdbcConnection).getQualifierList();
        if (null == qualifierStringList) {
            return null;
        }
        for (int i = 0; i < qualifierStringList.size(); ++i) {
            String schemaName = null;
            String catalogName = null;
            String[] token = ((String)qualifierStringList.get(i)).split("\\.");
            if (Database.ECatalogSupport.catalogsSupported == catalogSupport && schemaSupport) {
                if (token.length > 1) {
                    catalogName = token[0];
                    schemaName = token[1];
                } else {
                    schemaName = token[0];
                }
            } else if (Database.ECatalogSupport.catalogsNotSupported == catalogSupport) {
                schemaName = token.length > 1 ? token[1] : token[0];
            } else {
                catalogName = token[0];
            }
            CatalogSchemaPath aQualifier = new CatalogSchemaPath(catalogName, schemaName);
            qualifierList.add(aQualifier);
        }
        return qualifierList;
    }

    public static class CatalogSchemaPath {
        private String catalog = null;
        private String schema = null;

        public CatalogSchemaPath(String catalog, String schema) {
            this.catalog = catalog;
            this.schema = schema;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }
    }
}

