/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.utilities;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.relmd.metadata._schema.Database;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public final class RelmdConfiguration {
    private static final String ADVANCED_PROPERTIES = "advancedProperties";
    public static final String GENERIC_SUFFIX = ".generic";
    private static Database.EVendorType[] vendors = new Database.EVendorType[]{Database.EVendorType.db2, Database.EVendorType.oracle, Database.EVendorType.sqlserver, Database.EVendorType.teradata};
    private static final String RELMD_METADATA_PREFIX = "relmd.metadata.";
    private static final String VENDOR = "vendor";
    private static final String JDBC = "jdbc";
    private static final String RELMDCONFIG_NAME = "../configuration/relmdConfig.properties";
    public static final String JDBC_TRACE_FILTER = "JDBCTraceFilter";
    private static final long REFRESH_PERIOD = 60000L;
    private static long lastRefreshTime = 0L;
    private static long lastModificationTime = 0L;
    private static File relmdConfigFile = null;
    private static Properties properties;

    private static synchronized void refresh() {
        long now = System.currentTimeMillis();
        if (now - lastRefreshTime > 60000L) {
            if (relmdConfigFile == null) {
                relmdConfigFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(RELMDCONFIG_NAME));
            }
            if ((lastModificationTime = relmdConfigFile.lastModified()) != 0L && lastModificationTime > lastRefreshTime) {
                Properties props = new Properties();
                try {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(relmdConfigFile));
                    props.load(is);
                    is.close();
                }
                catch (Exception e) {
                    throw new CCLRuntimeException((Throwable)e, e.getMessage());
                }
                properties = props;
            }
            if (properties == null) {
                properties = new Properties();
            }
            ICCLConfiguration globalConfig = CCLConfigurationFactory.getInstance();
            try {
                globalConfig.init();
                for (Database.EVendorType eVendorType : vendors) {
                    String prop = globalConfig.getValue(RELMD_METADATA_PREFIX + eVendorType.toString(), false);
                    if (prop == null) continue;
                    if (prop.equals(VENDOR)) {
                        properties.put(eVendorType.toString() + GENERIC_SUFFIX, "false");
                        continue;
                    }
                    if (!prop.equals(JDBC)) continue;
                    properties.put(eVendorType.toString() + GENERIC_SUFFIX, "true");
                }
            }
            catch (CCLConfigurationException ex) {
                throw new CCLRuntimeException((Throwable)ex, ex.getMessage());
            }
            lastRefreshTime = now;
        }
    }

    public static String getStringProperty(String name) {
        RelmdConfiguration.refresh();
        return properties != null ? properties.getProperty(name) : null;
    }

    public static String getStringProperty(String name, String defaultValue) {
        String value = RelmdConfiguration.getStringProperty(name);
        return value != null ? value : defaultValue;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String rc = RelmdConfiguration.getStringProperty(name);
        return rc == null ? defaultValue : Boolean.parseBoolean(rc);
    }

    public static void setProperty(String property, String value) {
        properties.setProperty(property, value);
        if (property.equals("useGeneric") && value.equalsIgnoreCase("True")) {
            for (Database.EVendorType eVendorType : vendors) {
                properties.put(eVendorType.toString() + GENERIC_SUFFIX, "true");
            }
        }
        if (property.equals("useGeneric") && value.equalsIgnoreCase("False")) {
            for (Database.EVendorType eVendorType : vendors) {
                properties.put(eVendorType.toString() + GENERIC_SUFFIX, "false");
            }
        }
    }

    public static long getLastModificationTime() {
        RelmdConfiguration.refresh();
        return lastModificationTime;
    }
}

