/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.utilities;

import com.ibm.cognos.jdbc.adaptor.IAdaptorDBMetadata;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class TableTypeMapper {
    private String[] m_table_TableTypes = null;
    private String[] m_view_TableTypes = null;
    private String[] m_synonym_TableTypes = null;
    private String[] m_tableAndView_TableTypes = null;
    private String[] m_systemTable_TableTypes = null;
    private String[] m_systemView_TableTypes = null;
    private String[] m_systemSynonym_TableTypes = null;
    public final String[] defaultTable_tableTypes = new String[]{"TABLE", "MATERIALIZED QUERY TABLE", "AUXILIARY TABLE"};
    public final String[] defaultView_tableTypes = new String[]{"VIEW"};
    public final String[] defaultTableAndView_tableTypes = new String[]{"TABLE", "MATERIALIZED QUERY TABLE", "AUXILIARY TABLE", "VIEW"};
    public final String[] defaultSynonym_tableTypes = new String[]{"SYNONYM", "ALIAS", "NICKNAME"};
    public final String[] defaultSystemTable_tableTypes = new String[]{"SYSTEM TABLE"};
    public final String[] defaultSystemView_tableTypes = new String[]{"SYSTEM VIEW"};
    public final String[] defaultSystemSynonym_tableTypes = new String[]{"SYSTEM SYNONYM"};
    private static String TABLE = "TABLE";
    private static String VIEW = "VIEW";
    private static String SYNONYM = "SYNONYM";
    private static String IGNORE = "IGNORE";
    private static String SYSTEM_TABLE = "SYSTEM TABLE";
    private static String SYSTEM_VIEW = "SYSTEM VIEW";
    private static String SYSTEM_SYNONYM = "SYSTEM SYNONYM";
    private static int INDEX_TABLE_TYPE = 1;

    public TableTypeMapper(DatabaseMetaData md) throws SQLException {
        ArrayList<String> table_TableTypes = new ArrayList<String>();
        ArrayList<String> view_TableTypes = new ArrayList<String>();
        ArrayList<String> synonym_TableTypes = new ArrayList<String>();
        ArrayList<String> tableView_TableTypes = new ArrayList<String>();
        ArrayList<String> systemTable_TableTypes = new ArrayList<String>();
        ArrayList<String> systemView_TableTypes = new ArrayList<String>();
        ArrayList<String> systemSynonym_TableTypes = new ArrayList<String>();
        ArrayList<String> systemTableView_TableTypes = new ArrayList<String>();
        if (md instanceof IAdaptorDBMetadata) {
            try (ResultSet rsTableTypes = null;){
                rsTableTypes = md.getTableTypes();
                while (rsTableTypes != null && rsTableTypes.next()) {
                    String tableType = rsTableTypes.getString(INDEX_TABLE_TYPE);
                    tableType = tableType.trim();
                    String effectiveTableType = ((IAdaptorDBMetadata)md).getEffectiveTableType(tableType);
                    if ((effectiveTableType = effectiveTableType.trim()).equals(TABLE)) {
                        table_TableTypes.add(tableType);
                        tableView_TableTypes.add(tableType);
                        continue;
                    }
                    if (effectiveTableType.equals(VIEW)) {
                        view_TableTypes.add(tableType);
                        tableView_TableTypes.add(tableType);
                        continue;
                    }
                    if (effectiveTableType.equals(SYNONYM)) {
                        synonym_TableTypes.add(tableType);
                        continue;
                    }
                    if (effectiveTableType.equals(SYSTEM_TABLE)) {
                        systemTable_TableTypes.add(tableType);
                        systemTableView_TableTypes.add(tableType);
                        continue;
                    }
                    if (effectiveTableType.equals(SYSTEM_VIEW)) {
                        systemView_TableTypes.add(tableType);
                        systemTableView_TableTypes.add(tableType);
                        continue;
                    }
                    if (effectiveTableType.equals(SYSTEM_SYNONYM)) {
                        systemSynonym_TableTypes.add(tableType);
                        continue;
                    }
                    if (effectiveTableType.equals(IGNORE)) continue;
                    table_TableTypes.add(tableType);
                    tableView_TableTypes.add(tableType);
                }
            }
            if (!table_TableTypes.isEmpty()) {
                this.m_table_TableTypes = new String[table_TableTypes.size()];
                this.m_table_TableTypes = table_TableTypes.toArray(this.m_table_TableTypes);
            }
            if (!view_TableTypes.isEmpty()) {
                this.m_view_TableTypes = new String[view_TableTypes.size()];
                this.m_view_TableTypes = view_TableTypes.toArray(this.m_view_TableTypes);
            }
            if (!synonym_TableTypes.isEmpty()) {
                this.m_synonym_TableTypes = new String[synonym_TableTypes.size()];
                this.m_synonym_TableTypes = synonym_TableTypes.toArray(this.m_synonym_TableTypes);
            }
            if (!systemTable_TableTypes.isEmpty()) {
                this.m_systemTable_TableTypes = new String[systemTable_TableTypes.size()];
                this.m_systemTable_TableTypes = systemTable_TableTypes.toArray(this.m_systemTable_TableTypes);
            }
            if (!systemView_TableTypes.isEmpty()) {
                this.m_systemView_TableTypes = new String[systemView_TableTypes.size()];
                this.m_systemView_TableTypes = systemView_TableTypes.toArray(this.m_systemView_TableTypes);
            }
            if (!systemSynonym_TableTypes.isEmpty()) {
                this.m_systemSynonym_TableTypes = new String[systemSynonym_TableTypes.size()];
                this.m_systemSynonym_TableTypes = systemSynonym_TableTypes.toArray(this.m_systemSynonym_TableTypes);
            }
            if (!tableView_TableTypes.isEmpty()) {
                this.m_tableAndView_TableTypes = new String[tableView_TableTypes.size()];
                this.m_tableAndView_TableTypes = tableView_TableTypes.toArray(this.m_tableAndView_TableTypes);
            }
        }
    }

    public String[] getListOfTable_TableTypes() {
        if (this.m_table_TableTypes == null) {
            this.m_table_TableTypes = this.defaultTable_tableTypes;
        }
        return this.m_table_TableTypes;
    }

    public String[] getListOfView_TableTypes() {
        if (this.m_view_TableTypes == null) {
            this.m_view_TableTypes = this.defaultView_tableTypes;
        }
        return this.m_view_TableTypes;
    }

    public String[] getListOfSynonym_TableTypes() {
        if (this.m_synonym_TableTypes == null) {
            this.m_synonym_TableTypes = this.defaultSynonym_tableTypes;
        }
        return this.m_synonym_TableTypes;
    }

    public String[] getListOfTableAndView_TableTypes() {
        if (this.m_tableAndView_TableTypes == null) {
            this.m_tableAndView_TableTypes = this.defaultTableAndView_tableTypes;
        }
        return this.m_tableAndView_TableTypes;
    }

    public String[] getListOfSystemTable_TableTypes() {
        if (this.m_systemTable_TableTypes == null) {
            this.m_systemTable_TableTypes = this.defaultSystemTable_tableTypes;
        }
        return this.m_systemTable_TableTypes;
    }

    public String[] getListOfSystemView_TableTypes() {
        if (this.m_systemView_TableTypes == null) {
            this.m_systemView_TableTypes = this.defaultSystemView_tableTypes;
        }
        return this.m_systemView_TableTypes;
    }

    public String[] getListOfSystemSynonym_TableTypes() {
        if (this.m_systemSynonym_TableTypes == null) {
            this.m_systemSynonym_TableTypes = this.defaultSystemSynonym_tableTypes;
        }
        return this.m_systemSynonym_TableTypes;
    }
}

