/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.functions.sql;

import com.ibm.cognos.internal.relmd.vendor.access.resultset.RelmdResultSet;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.BeginSql;
import com.ibm.cognos.relmd.vendor.access._schema.ExecutionError;
import com.ibm.cognos.relmd.vendor.access.functions.sql.SqlExecution;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RelmdSqlExecution
implements SqlExecution {
    public final VendorAccessConnection m_vendorAccessConnection;

    public RelmdSqlExecution(VendorAccessConnection vendorAccessConnection) {
        this.m_vendorAccessConnection = vendorAccessConnection;
    }

    public RelmdSqlExecution(Connection connection, VendorAccessHandler vendorAccessHandler) {
        Relmd relmd = RelmdGateway.relmd();
        VendorToolkit vendorToolkit = relmd.vendorToolkit();
        this.m_vendorAccessConnection = vendorToolkit.vendorAccessConnection(connection, vendorAccessHandler, null);
    }

    @Override
    public VendorAccessResultSet run(String sqlText) {
        VendorAccessHandler vendorAccessHandler;
        Statement statement;
        ResultSet sqlResultSet;
        block5: {
            Relmd relmd = RelmdGateway.relmd();
            VendorToolkit vendorToolkit = relmd.vendorToolkit();
            sqlResultSet = null;
            statement = null;
            vendorAccessHandler = this.m_vendorAccessConnection.vendorAccessHandler();
            VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
            if (null != sqlText && sqlText.length() > 0 && !sqlText.equalsIgnoreCase("TBD")) {
                if (null != vendorAccessHandler) {
                    BeginSql beginSql = vendorAccessToolkit.beginSql(sqlText);
                    Handler<BeginSql> beginSqlHandler = vendorAccessHandler.beginSqlHandler();
                    beginSqlHandler.handle(beginSql);
                }
                Connection connection = this.m_vendorAccessConnection.jdbcConnection();
                try {
                    statement = connection.createStatement();
                    if (null != statement) {
                        sqlResultSet = statement.executeQuery(sqlText);
                    }
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (vendorAccessHandler == null) break block5;
                    Handler<ExecutionError> executionErrorHandler = vendorAccessHandler.executionErrorHandler();
                    ExecutionError executionError = vendorAccessToolkit.executionError(message);
                    executionErrorHandler.handle(executionError);
                }
            }
        }
        RelmdResultSet relmdResultSet = new RelmdResultSet(statement, sqlResultSet, vendorAccessHandler);
        return relmdResultSet;
    }
}

