/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.functions.sql;

import com.ibm.cognos.internal.relmd.metadata._schema.ReferenceableSetElem;
import com.ibm.cognos.internal.relmd.session.query.functions.CurrentCatalogSetupElem;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.RelmdSqlExecution;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.session._schema.AccessibleCatalogRef;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.session.query.rules.CatalogGranularityRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.functions.sql.SqlEvaluation;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SqlExecutionCatalogGrain
implements VendorAccessResultSet,
VendorAccessResultSetIterator,
Handler<AccessibleCatalogRef> {
    private final SessionAccess m_sessionAccess;
    private VendorAccessResultSet m_resultSet;
    private VendorAccessResultSetIterator m_resultSetIterator;
    private Connection m_jdbcConnection;
    private CatalogGranularityRules m_catalogGranularityRules;
    private SessionQueryRules m_sessionQueryRules;
    private final ReferenceableSet<AccessibleCatalogRef> m_accessibleCatalogRefSet;
    private Iterator<Map.Entry<String, SqlEvaluation>> m_mapIter;
    private VendorAccessConnection m_vendorAccessConnection;
    private VendorToolkit m_vendorToolkit;
    private VendorAccessHandler m_vendorAccessHandler;
    private CurrentCatalogSetupElem m_currentCatalogSetupElem;

    public SqlExecutionCatalogGrain(SessionAccess sessionAccess, Map<String, SqlEvaluation> sqlEvaluationMap) {
        Relmd relmd = RelmdGateway.relmd();
        this.m_vendorToolkit = relmd.vendorToolkit();
        this.m_sessionAccess = sessionAccess;
        this.m_accessibleCatalogRefSet = new ReferenceableSetElem<AccessibleCatalogRef>();
        this.m_resultSet = null;
        this.m_resultSetIterator = null;
        this.m_jdbcConnection = null;
        this.m_sessionQueryRules = this.m_sessionAccess.sessionQueryRules();
        this.m_catalogGranularityRules = null;
        if (null != this.m_sessionQueryRules) {
            this.m_catalogGranularityRules = this.m_sessionQueryRules.catalogGranularityRules();
        }
        Set<Map.Entry<String, SqlEvaluation>> values = sqlEvaluationMap.entrySet();
        this.m_mapIter = values.iterator();
        VendorAccessResults vendorAccessResults = this.m_sessionAccess.vendorAccessResults();
        this.m_vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        this.m_vendorAccessConnection = null;
    }

    public VendorAccessResultSet run(Connection jdbcConnection) {
        this.m_jdbcConnection = jdbcConnection;
        this.m_vendorAccessConnection = this.m_vendorToolkit.vendorAccessConnection(this.m_jdbcConnection, this.m_vendorAccessHandler, this.m_sessionQueryRules);
        return this;
    }

    @Override
    public void close() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public VendorAccessResultSetIterator iterator() {
        return this;
    }

    @Override
    public VendorAccessResultSetValues values() {
        VendorAccessResultSetValues values = this.m_resultSet.values();
        return values;
    }

    @Override
    public boolean next() {
        boolean next = false;
        if (null != this.m_resultSetIterator) {
            next = this.m_resultSetIterator.next();
        }
        while (!next && this.m_mapIter.hasNext()) {
            if (null != this.m_resultSet) {
                this.m_resultSet.close();
                if (null != this.m_currentCatalogSetupElem) {
                    this.m_currentCatalogSetupElem.stop();
                }
            }
            Map.Entry<String, SqlEvaluation> entry = this.m_mapIter.next();
            SqlEvaluation value = entry.getValue();
            String m_sqlValue = value.value();
            String catalog = entry.getKey();
            m_sqlValue = m_sqlValue.replaceAll("catalogSubstitution", catalog);
            if (null == this.m_catalogGranularityRules) {
                RelmdSqlExecution sqlExecution = new RelmdSqlExecution(this.m_vendorAccessConnection);
                this.m_resultSet = sqlExecution.run(m_sqlValue);
                if (null == this.m_resultSet) continue;
                this.m_resultSetIterator = this.m_resultSet.iterator();
                next = this.m_resultSetIterator.next();
                continue;
            }
            this.m_currentCatalogSetupElem = new CurrentCatalogSetupElem(this.m_catalogGranularityRules, catalog, this.m_vendorAccessHandler);
            this.m_currentCatalogSetupElem.run(this.m_jdbcConnection);
            boolean ok = this.m_currentCatalogSetupElem.ok();
            if (ok) {
                RelmdSqlExecution sqlExecution = new RelmdSqlExecution(this.m_vendorAccessConnection);
                this.m_resultSet = sqlExecution.run(m_sqlValue);
                if (null != this.m_resultSet) {
                    this.m_resultSetIterator = this.m_resultSet.iterator();
                    next = this.m_resultSetIterator.next();
                }
            }
            this.m_currentCatalogSetupElem.stop();
        }
        return next;
    }

    @Override
    public void handle(AccessibleCatalogRef obj) {
        this.m_accessibleCatalogRefSet.add(obj);
    }
}

