/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.functions.sql;

import com.ibm.cognos.internal.relmd.session.query.functions.CurrentCatalogSetupElem;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.CatalogGrainCaseSensitivity;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.RelmdSqlExecution;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.VendorAccessRuleElem;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.WhereClauseEvaluation;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.WhereClauseEvaluationMetadataObjectSelections;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.WhereClauseEvaluationSqlObjectQueryPath;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.import_.functions.MetadataImportSelectionsChoice;
import com.ibm.cognos.relmd.metadata.objectPaths.MetadataObjectPathsToolkit;
import com.ibm.cognos.relmd.metadata.objectPaths.SchemaPath;
import com.ibm.cognos.relmd.metadata.objectPaths.SqlObjectQueryPath;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.session.Session;
import com.ibm.cognos.relmd.session._schema.AccessibleCatalogRef;
import com.ibm.cognos.relmd.session.access.SessionAccess;
import com.ibm.cognos.relmd.session.query.SessionQueryRules;
import com.ibm.cognos.relmd.session.query.rules.CaseSensitivityRules;
import com.ibm.cognos.relmd.session.query.rules.CatalogGranularityRules;
import com.ibm.cognos.relmd.session.query.rules.CodePageRules;
import com.ibm.cognos.relmd.vendor.VendorAccessConnection;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccess;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessResults;
import com.ibm.cognos.relmd.vendor.access.VendorAccessRule;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access.functions.sql.VendorAccessSqlToolkit;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsInclusion;
import com.ibm.cognos.relmd.vendor.access.rules.sql.Sql;
import com.ibm.cognos.relmd.vendor.access.rules.sql.WhereClauseInsertionRule;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class VendorAccessSql
implements VendorAccess {
    private String m_sqlValue;
    private final VendorAccessSqlToolkit m_vendorAccessSqlToolkit;
    private final VendorToolkit m_vendorToolkit;
    private final MetadataToolkit m_metadataToolkit;
    private final VendorAccessRule.EGranularity m_granularity;

    public VendorAccessSql(VendorAccessRuleElem sqlRuleElem) {
        this.m_sqlValue = sqlRuleElem.value();
        this.m_granularity = sqlRuleElem.getGranularity();
        Relmd relmd = RelmdGateway.relmd();
        this.m_metadataToolkit = relmd.metadataToolkit();
        this.m_vendorToolkit = relmd.vendorToolkit();
        VendorAccessToolkit vendorAccessToolkit = this.m_vendorToolkit.vendorAccessToolkit();
        this.m_vendorAccessSqlToolkit = vendorAccessToolkit.vendorAccessSqlToolkit();
    }

    public static String surroundSingleQuotes(String stringValue) {
        String resultString = null;
        if (stringValue != null) {
            int length = stringValue.length() + 2;
            StringBuffer resultStringBuffer = new StringBuffer(length);
            resultStringBuffer.append("'");
            resultStringBuffer.append(stringValue);
            resultStringBuffer.append("'");
            resultString = resultStringBuffer.toString();
        }
        return resultString;
    }

    @Override
    public VendorAccessResultSet run(VendorAccessConnection relmdConnection, MetadataObjectSelections objectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionInclusionRules) {
        String sqlText = this.m_sqlValue;
        if (sqlText.length() > 0 && !sqlText.equalsIgnoreCase("TBD")) {
            if (null != objectSelections) {
                CaseSensitivityRules caseSensitivityRules = null;
                SessionQueryRules sessionQueryRules = relmdConnection.sessionQueryRules();
                CodePageRules codePageRules = sessionQueryRules.codePageRules();
                sessionQueryRules = this.m_vendorAccessSqlToolkit.sessionQueryRules(CaseSensitivityRules.EStorage.none);
                caseSensitivityRules = sessionQueryRules.caseSensitivityRules();
                Locale locale = null;
                WhereClauseEvaluationMetadataObjectSelections agent = new WhereClauseEvaluationMetadataObjectSelections(objectSelections, caseSensitivityRules, locale, codePageRules);
                Sql sql = this.m_vendorAccessSqlToolkit.sql(sqlText);
                WhereClauseEvaluation whereClauseInclusionEvaluation = new WhereClauseEvaluation(sql, objectSelectionInclusionRules, agent);
                sqlText = whereClauseInclusionEvaluation.value();
            }
        } else {
            sqlText = null;
        }
        RelmdSqlExecution sqlExecution = new RelmdSqlExecution(relmdConnection);
        VendorAccessResultSet resultSet = sqlExecution.run(sqlText);
        return resultSet;
    }

    public void insertSql(String insertText, String searchFragment, WhereClauseInsertionRule.EInsertLocation insertLocation) {
        String sqlText = this.m_sqlValue;
        int insertPosition = sqlText.indexOf(searchFragment);
        if (insertPosition < 0) {
            throw new NullPointerException();
        }
        if (WhereClauseInsertionRule.EInsertLocation.after.equals((Object)insertLocation)) {
            insertPosition += searchFragment.length();
        }
        if (insertPosition <= 0 || insertPosition >= sqlText.length()) {
            throw new IllegalArgumentException();
        }
        StringBuffer updatedSqlBuf = new StringBuffer(sqlText.length() + insertText.length() + 2);
        String beginPart = sqlText.substring(0, insertPosition);
        updatedSqlBuf.append(beginPart);
        updatedSqlBuf.append(" ");
        updatedSqlBuf.append(insertText);
        updatedSqlBuf.append(" ");
        if (insertPosition < sqlText.length() - 1) {
            String endPart = sqlText.substring(insertPosition);
            updatedSqlBuf.append(endPart);
        }
        this.m_sqlValue = updatedSqlBuf.toString();
    }

    @Override
    public VendorAccessResultSet runDatabaseLevel(VendorAccessConnection relmdConnection) {
        VendorAccessResultSet resultSet = this.run(relmdConnection, null, null);
        return resultSet;
    }

    @Override
    public VendorAccessResultSet runCatalogLevel(VendorAccessConnection relmdConnection, String parentCatalogName) {
        this.replaceFragment("catalogSubstitution", parentCatalogName);
        return this.run(relmdConnection, null, null);
    }

    @Override
    public VendorAccessResultSet runSchemaLevel(VendorAccessConnection relmdConnection, String parentCatalogName, String parentSchemaName) {
        this.replaceFragment("catalogSubstitution", parentCatalogName);
        this.replaceFragment("schemaSubstitution", parentSchemaName);
        return this.run(relmdConnection, null, null);
    }

    @Override
    public VendorAccessResultSet runObjectLevel(VendorAccessConnection relmdConnection, String parentCatalogName, String parentSchemaName, String parentObjectName) {
        this.replaceFragment("catalogSubstitution", parentCatalogName);
        this.replaceFragment("schemaSubstitution", parentSchemaName);
        this.replaceFragment("objectSubstitution", parentObjectName);
        return this.run(relmdConnection, null, null);
    }

    private void replaceFragment(String oldFragment, String newFragment) {
        String currentSqlValue = this.m_sqlValue;
        if (null != newFragment) {
            int index = newFragment.indexOf("$");
            if (index > -1) {
                newFragment = newFragment.substring(0, index) + "\\$" + newFragment.substring(index + 1, newFragment.length());
            }
            this.m_sqlValue = currentSqlValue.replaceAll(oldFragment, newFragment);
        }
    }

    @Override
    public VendorAccessResultSet run(Connection connection, SessionAccess sessionAccess, MetadataImportSelectionsChoice metadataImportSelectionsChoice, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
        MetadataImportSelectionsChoice.EChoice choice = metadataImportSelectionsChoice.choice();
        VendorAccessResultSet resultSet = null;
        SessionQueryRules sessionQueryRules = sessionAccess.sessionQueryRules();
        VendorAccessResults vendorAccessResults = sessionAccess.vendorAccessResults();
        VendorAccessHandler vendorAccessHandler = vendorAccessResults.vendorAccessHandler();
        MetadataObjectSelections metadataObjectSelections = metadataImportSelectionsChoice.metadataObjectSelections();
        VendorAccessConnection vendorAccessConnection = this.m_vendorToolkit.vendorAccessConnection(connection, vendorAccessHandler, sessionQueryRules);
        switch (choice) {
            case metadataObjectSelections: {
                resultSet = this.run(vendorAccessConnection, metadataObjectSelections, objectSelectionsInclusionCollection);
                break;
            }
            case sqlObjectQueryPath: {
                String origSqlText = this.m_sqlValue;
                if (origSqlText.length() <= 0 || origSqlText.equalsIgnoreCase("TBD")) break;
                SqlObjectQueryPath sqlObjectQueryPath = metadataImportSelectionsChoice.sqlObjectQueryPath();
                CaseSensitivityRules caseSensitivityRules = sessionQueryRules.caseSensitivityRules();
                ArrayList<SchemaPath> schemaPathList = new ArrayList<SchemaPath>();
                CatalogGranularityRules catalogGranularityRules = sessionQueryRules.catalogGranularityRules();
                SchemaPath schemaPathOrig = sqlObjectQueryPath.schemaPath();
                final String catalogNameOrig = schemaPathOrig.parentCatalogName();
                Sql sql = this.m_vendorAccessSqlToolkit.sql(origSqlText);
                Locale locale = null;
                CodePageRules codePageRules = vendorAccessConnection.sessionQueryRules().codePageRules();
                if (null == catalogGranularityRules) {
                    WhereClauseEvaluationSqlObjectQueryPath agent = new WhereClauseEvaluationSqlObjectQueryPath(sqlObjectQueryPath, caseSensitivityRules, locale, codePageRules);
                    WhereClauseEvaluation whereClauseEvaluation = new WhereClauseEvaluation(sql, objectSelectionsInclusionCollection, agent);
                    this.m_sqlValue = whereClauseEvaluation.value();
                    RelmdSqlExecution sqlExecution = new RelmdSqlExecution(vendorAccessConnection);
                    resultSet = sqlExecution.run(this.m_sqlValue);
                } else {
                    final String parentSchemaName = schemaPathOrig.parentSchemaName();
                    MetadataObjectPathsToolkit objectPathsToolkit = this.m_metadataToolkit.metadataObjectPathsToolkit();
                    if (null != catalogNameOrig && 0 < catalogNameOrig.length()) {
                        SchemaPath schemaPath = new SchemaPath(){

                            @Override
                            public String parentSchemaName() {
                                return parentSchemaName;
                            }

                            @Override
                            public boolean hasParentCatalog() {
                                return true;
                            }

                            @Override
                            public String parentCatalogName() {
                                return catalogNameOrig;
                            }
                        };
                        schemaPathList.add(schemaPath);
                    } else {
                        Session session = sessionAccess.session();
                        ReferenceableSet<AccessibleCatalogRef> accessibleCatalogsSet = session.accessibleCatalogsSet();
                        for (AccessibleCatalogRef accessibleCatalogRef : accessibleCatalogsSet) {
                            SchemaPath schemaPath = objectPathsToolkit.schemaPath(accessibleCatalogRef);
                            schemaPathList.add(schemaPath);
                        }
                    }
                    for (SchemaPath schemaPath : schemaPathList) {
                        String objectName = sqlObjectQueryPath.objectName();
                        String parentCatalogName = schemaPath.parentCatalogName();
                        CurrentCatalogSetupElem currentCatalogSetupElem = new CurrentCatalogSetupElem(catalogGranularityRules, parentCatalogName, vendorAccessHandler);
                        currentCatalogSetupElem.run(connection);
                        SqlObjectQueryPath catalogGrainSqlObjectQueryPath = objectPathsToolkit.sqlObjectQueryPath(schemaPath, objectName);
                        if (origSqlText.length() > 0 && !origSqlText.equalsIgnoreCase("TBD")) {
                            Database.EVendorType vendorType = sessionAccess.vendorType();
                            RelmdSqlExecution catalogGrainCaseSensitivitySqlExecution = new RelmdSqlExecution(vendorAccessConnection);
                            CatalogGrainCaseSensitivity catalogGrainCaseSensitivity = new CatalogGrainCaseSensitivity(parentCatalogName, vendorType, catalogGrainCaseSensitivitySqlExecution);
                            WhereClauseEvaluationSqlObjectQueryPath agent = new WhereClauseEvaluationSqlObjectQueryPath(catalogGrainSqlObjectQueryPath, catalogGrainCaseSensitivity, locale, codePageRules);
                            WhereClauseEvaluation whereClauseEvaluation = new WhereClauseEvaluation(sql, objectSelectionsInclusionCollection, agent);
                            this.m_sqlValue = whereClauseEvaluation.value();
                            this.replaceFragment("catalogSubstitution", parentCatalogName);
                            RelmdSqlExecution sqlExecution = new RelmdSqlExecution(vendorAccessConnection);
                            resultSet = sqlExecution.run(this.m_sqlValue);
                        }
                        currentCatalogSetupElem.stop();
                    }
                }
                this.m_sqlValue = origSqlText;
                break;
            }
        }
        return resultSet;
    }

    @Override
    @Deprecated
    public VendorAccessHandler vendorAccessHandler() {
        return null;
    }

    @Override
    public VendorAccessRule.EGranularity getGranularity() {
        return this.m_granularity;
    }

    @Override
    public VendorAccessResultSet runGeneric(VendorAccessConnection relmdConnection, MetadataObjectSelections objectSelections, Collection<? extends ObjectSelectionsInclusion> objectSelectionsInclusionCollection) {
        return null;
    }
}

