/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.functions.sql;

import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments.ObjectInclusionConditionExpressionEvaluation;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments.SqlFragmentAndCondition;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments.SqlFragmentConcatenationBase;
import com.ibm.cognos.internal.relmd.vendor.access.functions.sql.fragments.SqlFragmentOrCondition;
import com.ibm.cognos.relmd.Relmd;
import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.metadata.MetadataToolkit;
import com.ibm.cognos.relmd.metadata._schema.properties.ReferenceableSet;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelections;
import com.ibm.cognos.relmd.metadata.objectSelections.MetadataObjectSelectionsToolkit;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.SelectionChoice;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllCatalogsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllFunctionsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllProceduresSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSchemasSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllSynonymsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllTablesSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.AllViewsSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.all.SelectedAllObjects;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.CatalogSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.FunctionSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ProcedureSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SchemaSelectionsContainer;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SelectedObject;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.SynonymSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.TableSelection;
import com.ibm.cognos.relmd.metadata.objectSelections._schema.selected.ViewSelection;
import com.ibm.cognos.relmd.session.query.rules.CaseSensitivityRules;
import com.ibm.cognos.relmd.session.query.rules.CodePageRules;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access.functions.sql.VendorAccessSqlToolkit;
import com.ibm.cognos.relmd.vendor.access.functions.sql.WhereClauseInclusionConditionEvaluation;
import com.ibm.cognos.relmd.vendor.access.functions.sql.WhereClauseInclusionConditionEvaluationAgent;
import com.ibm.cognos.relmd.vendor.access.rules.sql.ObjectSelectionsCondition;
import com.ibm.cognos.relmd.vendor.access.rules.sql.SqlFragment;
import java.util.Locale;

public class WhereClauseEvaluationMetadataObjectSelections
implements WhereClauseInclusionConditionEvaluationAgent {
    private final MetadataObjectSelections m_objectSelections;
    private CaseSensitivityRules m_caseSensitivityRules;
    private VendorAccessSqlToolkit m_vendorAccessSqlToolkit;
    private Locale m_locale;
    private MetadataObjectSelectionsToolkit m_objectSelectionsToolkit;
    private CodePageRules m_codePageRules;

    public WhereClauseEvaluationMetadataObjectSelections(MetadataObjectSelections metadataObjectSelections, CaseSensitivityRules caseSensitivityRules, Locale locale, CodePageRules codePageRules) {
        this.m_locale = locale;
        Relmd relmd = RelmdGateway.relmd();
        VendorToolkit vendorToolkit = relmd.vendorToolkit();
        VendorAccessToolkit vendorAccessToolkit = vendorToolkit.vendorAccessToolkit();
        this.m_vendorAccessSqlToolkit = vendorAccessToolkit.vendorAccessSqlToolkit();
        this.m_objectSelections = metadataObjectSelections;
        this.m_caseSensitivityRules = caseSensitivityRules;
        MetadataToolkit metadataToolkit = relmd.metadataToolkit();
        this.m_objectSelectionsToolkit = metadataToolkit.metadataObjectSelectionsToolkit();
        this.m_codePageRules = codePageRules;
    }

    @Override
    public WhereClauseInclusionConditionEvaluation objectSelectionsConditionEvaluation(final ObjectSelectionsCondition objectSelectionsInclusionCondition) {
        WhereClauseInclusionConditionEvaluation objectSelectionsConditionEvaluation = new WhereClauseInclusionConditionEvaluation(){

            @Override
            public ObjectSelectionsCondition objectSelectionsCondition() {
                return objectSelectionsInclusionCondition;
            }

            @Override
            public String value() {
                SqlFragmentOrCondition orConcatenation = new SqlFragmentOrCondition();
                SqlFragment catalogConditions = WhereClauseEvaluationMetadataObjectSelections.this.catalogConditions(objectSelectionsInclusionCondition);
                orConcatenation.handle(catalogConditions);
                SqlFragment schemaConditions = WhereClauseEvaluationMetadataObjectSelections.this.buildSchemaConditions(WhereClauseEvaluationMetadataObjectSelections.this.m_objectSelections, objectSelectionsInclusionCondition);
                orConcatenation.handle(schemaConditions);
                String value = orConcatenation.value();
                return value;
            }
        };
        return objectSelectionsConditionEvaluation;
    }

    private SqlFragment catalogConditions(ObjectSelectionsCondition condition) {
        ReferenceableSet<CatalogSelection> selectedCatalogCollection;
        SelectionChoice<CatalogSelection, AllCatalogsSelection> catalogSelections = this.m_objectSelections.catalogSelections();
        boolean bAllCatalogsSelected = this.m_objectSelectionsToolkit.allSelected(catalogSelections);
        SqlFragmentOrCondition orCondition = new SqlFragmentOrCondition();
        if (!bAllCatalogsSelected && null != catalogSelections && null != (selectedCatalogCollection = catalogSelections.selectedObjects())) {
            for (CatalogSelection selectedCatalog : selectedCatalogCollection) {
                String catalogExpressionValue = condition.catalogExpression();
                SqlFragment catalogExpressionFragment = this.m_vendorAccessSqlToolkit.sqlFragment(catalogExpressionValue);
                ObjectInclusionConditionExpressionEvaluation catalogExpressionEvaluation = new ObjectInclusionConditionExpressionEvaluation(catalogExpressionFragment, this.m_caseSensitivityRules, this.m_locale);
                catalogExpressionEvaluation.setCodePageRules(this.m_codePageRules);
                if (null != catalogExpressionValue && 0 < catalogExpressionValue.length()) {
                    SqlFragment selectedCatalogFragment = this.m_vendorAccessSqlToolkit.sqlFragment(selectedCatalog);
                    catalogExpressionEvaluation.handle(selectedCatalogFragment);
                }
                SqlFragmentAndCondition andConcatenationCatalogSchema = new SqlFragmentAndCondition();
                SqlFragment schemaConditions = this.buildSchemaConditions(selectedCatalog, condition);
                andConcatenationCatalogSchema.handle(catalogExpressionEvaluation);
                andConcatenationCatalogSchema.handle(schemaConditions);
                orCondition.handle(andConcatenationCatalogSchema);
            }
        }
        return orCondition;
    }

    private SqlFragment buildSchemaConditions(SchemaSelectionsContainer schemaContainer, ObjectSelectionsCondition condition) {
        SelectionChoice<SchemaSelection, AllSchemasSelection> schemaSelections = schemaContainer.schemaSelections();
        ReferenceableSet<SchemaSelection> schemaSelectionsSet = schemaSelections.selectedObjects();
        SqlFragmentOrCondition orSchemasConcatenation = new SqlFragmentOrCondition();
        if (null != schemaSelectionsSet) {
            for (SchemaSelection selectedSchema : schemaSelectionsSet) {
                String schemaExpressionValue = condition.schemaExpression();
                SqlFragment schemaExpression = this.m_vendorAccessSqlToolkit.sqlFragment(schemaExpressionValue);
                SqlFragmentConcatenationBase schemaEqualsConcatenation = new SqlFragmentConcatenationBase(null);
                ObjectInclusionConditionExpressionEvaluation schemaCondition = new ObjectInclusionConditionExpressionEvaluation(schemaExpression, this.m_caseSensitivityRules, this.m_locale);
                schemaCondition.setCodePageRules(this.m_codePageRules);
                if (null != schemaExpressionValue && 0 < schemaExpressionValue.length()) {
                    SqlFragment selectedSchemaFragment = this.m_vendorAccessSqlToolkit.sqlFragment(selectedSchema);
                    schemaCondition.handle(selectedSchemaFragment);
                }
                schemaEqualsConcatenation.handle(schemaCondition);
                SqlFragmentAndCondition andConcatenationSchemaConditionObjectsConditions = new SqlFragmentAndCondition();
                andConcatenationSchemaConditionObjectsConditions.handle(schemaEqualsConcatenation);
                SqlFragment objectConditions = this.buildObjectConditions(selectedSchema, condition);
                andConcatenationSchemaConditionObjectsConditions.handle(objectConditions);
                orSchemasConcatenation.handle(andConcatenationSchemaConditionObjectsConditions);
            }
        }
        return orSchemasConcatenation;
    }

    private SqlFragment buildObjectConditions(SchemaSelection selectedSchema, ObjectSelectionsCondition condition) {
        String objectExpression = condition.objectExpression();
        ObjectInclusionConditionExpressionEvaluation evaluation = null;
        if (null != objectExpression && 0 < objectExpression.length()) {
            SqlFragment objectExpressionFragment = this.m_vendorAccessSqlToolkit.sqlFragment(objectExpression);
            evaluation = new ObjectInclusionConditionExpressionEvaluation(objectExpressionFragment, this.m_caseSensitivityRules, this.m_locale);
            evaluation.setCodePageRules(this.m_codePageRules);
            SelectionChoice<TableSelection, AllTablesSelection> tableSelections = selectedSchema.tableSelections();
            SelectionChoice<ViewSelection, AllViewsSelection> viewSelections = selectedSchema.viewSelections();
            SelectionChoice<SynonymSelection, AllSynonymsSelection> synonymSelections = selectedSchema.synonymSelections();
            SelectionChoice<ProcedureSelection, AllProceduresSelection> procedureSelections = selectedSchema.procedureSelections();
            SelectionChoice<FunctionSelection, AllFunctionsSelection> functionSelections = selectedSchema.functionSelections();
            boolean anySelected = this.anySelected(tableSelections, viewSelections, synonymSelections, procedureSelections, functionSelections);
            if (anySelected) {
                this.handleObjectSelectionsChoice(evaluation, tableSelections);
                this.handleObjectSelectionsChoice(evaluation, viewSelections);
                this.handleObjectSelectionsChoice(evaluation, functionSelections);
                this.handleObjectSelectionsChoice(evaluation, procedureSelections);
                this.handleObjectSelectionsChoice(evaluation, synonymSelections);
            }
        }
        return evaluation;
    }

    private void handleObjectSelectionsChoice(ObjectInclusionConditionExpressionEvaluation handler, SelectionChoice<? extends SelectedObject, ? extends SelectedAllObjects> objectSelectiosChoice) {
        ReferenceableSet<? extends SelectedObject> selectedObjectsCollection = objectSelectiosChoice.selectedObjects();
        if (null != selectedObjectsCollection) {
            for (SelectedObject selectedObject : selectedObjectsCollection) {
                SqlFragment objectNameEntry = this.m_vendorAccessSqlToolkit.sqlFragment(selectedObject);
                handler.handle(objectNameEntry);
            }
        }
    }

    private boolean anySelected(SelectionChoice<? extends SelectedObject, ? extends SelectedAllObjects> ... choices) {
        boolean bAnySelected = false;
        for (int choicesIdx = 0; !bAnySelected && choicesIdx < choices.length; ++choicesIdx) {
            SelectionChoice<? extends SelectedObject, ? extends SelectedAllObjects> choice = choices[choicesIdx];
            SelectionChoice.EChoice choiceValue = choice.choice();
            if (SelectionChoice.EChoice.selected.equals((Object)choiceValue)) {
                bAnySelected = choice.selectedObjects().size() > 0;
                continue;
            }
            if (!SelectionChoice.EChoice.all.equals((Object)choiceValue)) continue;
            bAnySelected = true;
        }
        return bAnySelected;
    }
}

