/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.access.resultset;

import com.ibm.cognos.relmd.RelmdGateway;
import com.ibm.cognos.relmd.vendor.VendorToolkit;
import com.ibm.cognos.relmd.vendor.access.VendorAccessHandler;
import com.ibm.cognos.relmd.vendor.access.VendorAccessToolkit;
import com.ibm.cognos.relmd.vendor.access._schema.ResultSetProcessingError;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSet;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetIterator;
import com.ibm.cognos.relmd.vendor.access.results.VendorAccessResultSetValues;
import com.ibm.cognos.relmd.xmlapi.Handler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class RelmdResultSet
implements VendorAccessResultSet,
VendorAccessResultSetValues,
VendorAccessResultSetIterator {
    private final Statement m_statement;
    private int m_columnCount;
    private static final String BLANK_STRING = "";
    private final ResultSet m_resultSet;
    private final VendorAccessHandler m_vendorAccessHandler;
    private int m_rowNum;
    private VendorToolkit m_vendorToolkit;

    public RelmdResultSet(ResultSet resultSet, VendorAccessHandler vendorAccessHandler) {
        this(null, resultSet, vendorAccessHandler);
    }

    public RelmdResultSet(Statement statement, ResultSet resultSet, VendorAccessHandler vendorAccessHandler) {
        this.m_resultSet = resultSet;
        this.m_vendorAccessHandler = vendorAccessHandler;
        this.m_columnCount = -1;
        this.m_rowNum = -1;
        this.m_vendorToolkit = RelmdGateway.relmd().vendorToolkit();
        if (null != resultSet) {
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                if (null != metaData) {
                    this.m_columnCount = metaData.getColumnCount();
                }
            }
            catch (SQLException e) {
                String message = e.getMessage();
                this.resultSetProcessingError(message);
            }
        }
        this.m_statement = statement;
    }

    private void resultSetProcessingError(String message) {
        VendorAccessToolkit vendorAccessToolkit = this.m_vendorToolkit.vendorAccessToolkit();
        ResultSetProcessingError resultSetProcessingError = vendorAccessToolkit.resultSetProcessingError(this.m_rowNum, message);
        if (null != this.m_vendorAccessHandler) {
            Handler<ResultSetProcessingError> resultSetProcessingErrorHandler = this.m_vendorAccessHandler.resultSetProcessingErrorHandler();
            resultSetProcessingErrorHandler.handle(resultSetProcessingError);
        }
    }

    @Override
    public VendorAccessResultSetValues values() {
        return this;
    }

    @Override
    public VendorAccessResultSetIterator iterator() {
        return this;
    }

    @Override
    public boolean next() {
        boolean next = false;
        if (null != this.m_resultSet && 0 < this.m_columnCount) {
            try {
                next = this.m_resultSet.next();
            }
            catch (SQLException e) {
                String errorMsg = e.getMessage();
                this.resultSetProcessingError(errorMsg);
            }
            if (!next) {
                this.close();
            }
        }
        return next;
    }

    @Override
    public void close() {
        if (null != this.m_resultSet) {
            try {
                this.m_resultSet.close();
            }
            catch (SQLException e) {
                this.resultSetProcessingError(e.getMessage());
            }
            if (null != this.m_statement) {
                try {
                    this.m_statement.close();
                }
                catch (NullPointerException e) {
                    this.resultSetProcessingError(e.getMessage());
                }
                catch (SQLException e) {
                    this.resultSetProcessingError(e.getMessage());
                }
            }
        }
    }

    @Override
    public String stringValue(int index) {
        String stringValue = null;
        if (index == -1 || this.m_columnCount < index) {
            stringValue = BLANK_STRING;
        } else {
            try {
                stringValue = this.m_resultSet.getString(index);
            }
            catch (SQLException e) {
                this.resultSetProcessingError("result set stringValue retrieval error: " + e.getMessage());
            }
        }
        if (null == stringValue) {
            stringValue = BLANK_STRING;
        }
        return stringValue;
    }

    @Override
    public Integer intValue(int index) {
        Integer intValue = null;
        if (index == -1 || this.m_columnCount < index) {
            intValue = -1;
        } else {
            try {
                intValue = this.m_resultSet.getInt(index);
            }
            catch (SQLException e) {
                this.resultSetProcessingError("result set intValue retrieval error: " + e.getMessage());
            }
        }
        return intValue;
    }
}

