/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.vendor.rules;

import com.ibm.cognos.internal.relmd.vendor.rules.VendorRulesElem;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.XmlContentHandler;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElementHandler;
import com.ibm.cognos.relmd.metadata._schema.Database;
import com.ibm.cognos.relmd.vendor.VendorRules;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class VendorRulesBuilder
implements XmlContentHandler {
    VendorRulesElem m_vendorRules;
    Stack<XmlElementHandler> m_elemStack = new Stack();
    private final Database.EVendorType m_vendorType;
    private final Database.ECatalogSupport m_catalogSupport;

    public VendorRulesBuilder(Database.EVendorType vendorType, Database.ECatalogSupport catalogSupport) throws SAXException, IOException, ParserConfigurationException {
        this.m_vendorType = vendorType;
        this.m_catalogSupport = catalogSupport;
    }

    public VendorRulesBuilder(Database.EVendorType vendorType) throws SAXException, IOException, ParserConfigurationException {
        this(vendorType, Database.ECatalogSupport.catalogsNotSupported);
    }

    @Override
    public XmlContentHandler.EElementRule elementBegin(String tagName, XmlAttributeGroup attributes) {
        XmlElementHandler newHandler = null;
        if ("systemObject".equals(tagName)) {
            String objectName = attributes.getAttribute("name").getValue();
            this.m_vendorRules.addSystemObject(objectName);
        }
        if (this.m_elemStack.empty()) {
            if ("vendorRules".equals(tagName)) {
                this.m_vendorRules = new VendorRulesElem(this.m_vendorType, this.m_catalogSupport, attributes);
                newHandler = this.m_vendorRules;
            }
        } else {
            XmlElementHandler handler = this.getCurrentHandler();
            newHandler = handler.createChild(tagName, attributes);
        }
        if (newHandler != null) {
            this.m_elemStack.push(newHandler);
        }
        return XmlContentHandler.EElementRule.accept;
    }

    private XmlElementHandler getCurrentHandler() {
        return this.m_elemStack.peek();
    }

    @Override
    public void elementEnd(String tagName) {
        XmlElementHandler handler = this.getCurrentHandler();
        String handlerTagName = handler.getTagName();
        if (tagName.equals(handlerTagName)) {
            this.m_elemStack.pop();
        }
    }

    public VendorRules getRulesProvider() {
        return this.m_vendorRules;
    }

    @Override
    public void elementText(String text) {
        XmlElementHandler currElementHandler = this.getCurrentHandler();
        if (currElementHandler != null) {
            currElementHandler.addText(text);
        }
    }
}

