/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.xmlapi;

import com.ibm.cognos.internal.relmd.xmlapi.XmlContentHandler;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttributeGroup;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader
extends DefaultHandler {
    private static final String DISALLOW_DOCTYPE_DEC1 = "http://apache.org/xml/features/disallow-doctype-decl";
    protected Stack<String> m_suppressedStack = new Stack();
    private XmlContentHandler m_relmdHandler = null;

    public XmlReader(XmlContentHandler relmdHandler) {
        this.m_relmdHandler = relmdHandler;
    }

    public void read(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature(DISALLOW_DOCTYPE_DEC1, true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(inputStream, (DefaultHandler)this);
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String tagName = this.getTagName(localName, qName);
        if (!this.m_suppressedStack.empty()) {
            this.m_suppressedStack.push(tagName);
        } else {
            RelmdAttributeGroup attributeGroup = new RelmdAttributeGroup(attributes, "relmd", true);
            XmlContentHandler.EElementRule handleStartElementStatus = this.m_relmdHandler.elementBegin(tagName, attributeGroup);
            if (XmlContentHandler.EElementRule.reject.equals((Object)handleStartElementStatus)) {
                this.m_suppressedStack.push(tagName);
            }
        }
    }

    private final String getTagName(String localName, String qName) {
        return localName != null && localName.length() > 0 ? localName : qName.substring(qName.indexOf(58) + 1);
    }

    @Override
    public final void endElement(String uri, String localName, String name) throws SAXException {
        String tagName = this.getTagName(localName, name);
        if (!this.m_suppressedStack.empty()) {
            String suppressedElem = this.m_suppressedStack.pop();
            if (!suppressedElem.equals(tagName)) {
                throw new IllegalArgumentException();
            }
        } else {
            this.m_relmdHandler.elementEnd(tagName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String textValue = new String(ch, start, length);
        this.m_relmdHandler.elementText(textValue);
    }
}

