/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.xmlapi.attributes;

import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttribute;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.xml.sax.Attributes;

public class RelmdAttributeGroup
implements XmlAttributeGroup {
    private static final char COLON_CHARACTER = ':';
    private LinkedHashMap<String, XmlAttribute> m_attributes = new LinkedHashMap();
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected static final String TRUE_1 = "1";
    protected static final String TRUE_Y = "Y";

    public RelmdAttributeGroup() {
    }

    public RelmdAttributeGroup(Attributes attributes, String nsPrefix, boolean isDefaultNs) {
        String searchPrefix = nsPrefix + ':';
        this.m_attributes = new LinkedHashMap();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String localName = null;
            String qName = attributes.getQName(i);
            if (qName.startsWith(searchPrefix)) {
                localName = qName.substring(searchPrefix.length());
            } else if (isDefaultNs && qName.indexOf(58) < 0) {
                localName = qName;
            }
            if (localName == null) continue;
            String value = attributes.getValue(i);
            this.m_attributes.put(localName, new RelmdAttribute(localName, value));
        }
    }

    @Override
    public XmlAttribute getAttribute(String name) {
        return this.m_attributes.get(name);
    }

    @Override
    public Collection<? extends XmlAttribute> attributes() {
        return this.m_attributes.values();
    }

    public final String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String newString = new String(writer.getBuffer());
        return newString;
    }

    public void write(Writer m_writer, String nsPrefix) throws IOException {
        Iterator<XmlAttribute> m_attributesIter = this.m_attributes.values().iterator();
        while (m_attributesIter.hasNext()) {
            m_writer.write(" ");
            m_attributesIter.next().write(m_writer, nsPrefix);
        }
    }

    public int attributeCount() {
        return this.m_attributes.size();
    }

    public String attributeValue(String attributeName) {
        XmlAttribute attribute = this.getAttribute(attributeName);
        return attribute == null ? (String)null : attribute.getValue();
    }

    @Override
    public void add(XmlAttribute attribute) {
        this.m_attributes.put(attribute.getName(), attribute);
    }
}

