/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.relmd.xmlapi.attributes;

import com.ibm.cognos.internal.relmd.xmlapi.XmlAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.XmlAttributeGroup;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElementHandler;
import com.ibm.cognos.internal.relmd.xmlapi.XmlWriter;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttribute;
import com.ibm.cognos.internal.relmd.xmlapi.attributes.RelmdAttributeGroup;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class RelmdElement
implements XmlElement {
    private static final long serialVersionUID = 1L;
    private static final String XMLSEPARATOR_COLON = ":";
    XmlElementHandler m_childElementHandler = null;
    String m_text;
    public String m_tagName;
    private XmlAttributeGroup m_attributes;

    public RelmdElement(String elemName, XmlAttributeGroup attributeGroup) {
        this.m_tagName = elemName;
        this.m_attributes = attributeGroup;
    }

    public RelmdElement(Element sourceElement) {
        this(sourceElement.getName());
        Iterator attributeIter = sourceElement.attributeIterator();
        while (attributeIter.hasNext()) {
            Attribute attribute = (Attribute)attributeIter.next();
            String qName = attribute.getName();
            int colonPos = qName.indexOf(XMLSEPARATOR_COLON);
            if (colonPos > 0) {
                qName = qName.substring(colonPos + 1);
            }
            this.addAttribute(qName, attribute.getValue());
        }
    }

    public RelmdElement(String elemName) {
        this(elemName, new RelmdAttributeGroup());
    }

    @Override
    public final String getTagName() {
        return this.m_tagName;
    }

    @Override
    public Collection<? extends XmlAttribute> attributes() {
        return this.m_attributes.attributes();
    }

    @Override
    public XmlAttribute getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    public XmlElement asXml() {
        return this;
    }

    @Override
    public Collection<? extends XmlElement> childElements() {
        return new ArrayList();
    }

    public final String toString() {
        String returnValue = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String m_reldNamespacePrefix = "relmd";
            XmlWriter writer = new XmlWriter(m_reldNamespacePrefix, "http://localhost/cognos8/relmd", "relmdApi.xsd");
            BufferedWriter m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            writer.writeElem((XmlElement)this, m_writer, m_reldNamespacePrefix);
            ((Writer)m_writer).flush();
            ((Writer)m_writer).close();
            baos.flush();
            baos.close();
            returnValue = baos.toString("UTF-8");
        }
        catch (IOException e) {
            returnValue = super.toString();
        }
        return returnValue;
    }

    @Override
    public void add(XmlAttribute attribute) {
        this.m_attributes.add(attribute);
    }

    public String attributeValue(String name) {
        XmlAttribute attribute = this.getAttribute(name);
        return attribute == null ? null : attribute.getValue();
    }

    public void addAttribute(String name, String value) {
        RelmdAttribute attribute = new RelmdAttribute(name, value);
        this.m_attributes.add(attribute);
    }

    public void addOptionalAttribute(String name, String value) {
        if (value != null && value.length() > 0) {
            this.addAttribute(name, value);
        }
    }
}

