/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jmdadaptor;

import com.ibm.cognos.internal.relmd.bibus.RelmdException;
import com.ibm.cognos.internal.relmd.bibus.RelmdServiceConnection;
import com.ibm.cognos.internal.relmd.dataSource.RelmdConnectionFactory;
import com.ibm.cognos.internal.relmd.dataSource._tools.DataSourceConnectionStringParser;
import com.ibm.cognos.internal.relmd.xmlapi.XmlElement;
import com.ibm.cognos.jdbc.adaptor.IAdaptorConnection;
import com.ibm.cognos.relmd.metadata.source.MetadataSource;
import com.ibm.cognos.relmd.vendor.connection.ConnectionParameters;
import java.sql.Driver;
import java.util.Properties;
import org.dom4j.Element;

public class JMDConnectionFactory {
    public static IAdaptorConnection createConnection(RelmdServiceConnection.IRequestEnvironment reqEnv, MetadataSource dataSource) {
        IAdaptorConnection con = null;
        try {
            ConnectionParameters cp = reqEnv.connectionParameters(dataSource);
            String driverClassName = cp.driverClass();
            Driver driver = (Driver)Class.forName(driverClassName).newInstance();
            Properties props = cp.getProperties();
            if (cp.userName() != null) {
                props.setProperty("user", cp.userName());
            }
            if (cp.password() != null) {
                props.setProperty("password", cp.password());
            }
            Properties properties = DataSourceConnectionStringParser.setPassportProperty(cp.jdbcConnectionString(), reqEnv.getAxisHeader(), cp.getProperties());
            con = (IAdaptorConnection)RelmdConnectionFactory.getAndWrapConnection(cp, driver, properties);
        }
        catch (Exception e) {
            throw new RelmdException(RelmdException.EErrorType.client, RelmdException.EErrorCode.jdbcSQLException, e);
        }
        return con;
    }

    public static MetadataSource getDataSource(Element commandElem) {
        Element dataSource = (Element)commandElem.selectSingleNode("//relmd:metadataSource");
        final String dataSourceName = dataSource.attribute(0).getStringValue();
        return new MetadataSource(){

            @Override
            public String dataSourceName() {
                return dataSourceName;
            }

            @Override
            public Boolean hasDataSourceConnectionName() {
                return null;
            }

            @Override
            public String dataSourceConnectionName() {
                return null;
            }

            @Override
            public Boolean hasDataSourceSignonName() {
                return null;
            }

            @Override
            public String dataSourceSignonName() {
                return null;
            }

            @Override
            public Boolean hasEncryptedCredentialsXml() {
                return null;
            }

            @Override
            public String encryptedCredentialsXml() {
                return null;
            }

            @Override
            public XmlElement asXml() {
                return null;
            }
        };
    }
}

