/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2pd.process_mta;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JMeterPIDFixupHandler
extends BasicHandler {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String JMETER_THREAD_TRANSPORT_VALUE = "d_jmeter_thread";
    private static final String JMETER_TID_PROPERTY = "jmeter.tid";
    private static final String DP_TRANSPORT_VALUE = "d_p";
    private static final String PROCESS_MTA_DP_PROPERTY = "process_mta.d_p";
    private final Map<String, String> jmeterFixup = Collections.synchronizedMap(new HashMap());

    public JMeterPIDFixupHandler() {
        super(log.getNativeLogger());
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String jmeterThreadId = request.getDispatcherTransportValue(JMETER_THREAD_TRANSPORT_VALUE);
        if (jmeterThreadId != null) {
            this.handleJMeterFixup(mc, request, jmeterThreadId);
        }
    }

    private void handleJMeterFixup(MessageContext mc, BIBusEnvelope request, String jmeterThreadId) {
        String savedThreadId = (String)mc.getProperty(JMETER_TID_PROPERTY);
        if (savedThreadId == null) {
            this.handleFirstInvocation(mc, request, jmeterThreadId);
        } else {
            this.saveProcessIdUsedByJMeterThread(mc, savedThreadId);
        }
    }

    private void handleFirstInvocation(MessageContext mc, BIBusEnvelope request, String jmeterThreadId) {
        mc.setProperty(JMETER_TID_PROPERTY, jmeterThreadId);
        String dp = request.getDispatcherTransportValue(DP_TRANSPORT_VALUE);
        if (dp != null) {
            this.replaceDP(request, jmeterThreadId, dp);
        }
    }

    private void replaceDP(BIBusEnvelope request, String jmeterThreadId, String oldDP) {
        String newDP = this.jmeterFixup.get(jmeterThreadId);
        request.setDispatcherTransport(DP_TRANSPORT_VALUE, newDP);
        log.debug("JMeter fixup for thread [", jmeterThreadId, "], changed d_p from: ", oldDP, " to: ", newDP);
    }

    private void saveProcessIdUsedByJMeterThread(MessageContext mc, String tid) {
        String dp = (String)mc.getProperty(PROCESS_MTA_DP_PROPERTY);
        this.jmeterFixup.put(tid, dp);
        log.debug("JMeter fixup for thread [", tid, "], save mapping of d_p to: ", dp);
    }
}

