/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2pd.util;

import com.cognos.p2pd.util.ChainLink;
import java.util.Enumeration;

public class Chain {
    protected ChainLink start = new ChainLink(null);
    protected ChainLink end = new ChainLink(null);
    protected int size = 0;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.start.next == this.end;
    }

    public Chain() {
        this.start.next = this.end;
        this.end.prev = this.start;
    }

    public ChainLink begin() {
        return this.start.next;
    }

    public ChainLink end() {
        return this.end;
    }

    public ChainLink popStart() {
        if (this.isEmpty()) {
            return null;
        }
        ChainLink c = this.start.next;
        this.remove(c);
        return c;
    }

    public ChainLink popEnd() {
        if (this.isEmpty()) {
            return null;
        }
        ChainLink c = this.end.prev;
        this.remove(c);
        return c;
    }

    public void addAfter(ChainLink c, ChainLink here) {
        c.insertBetween(here, here.next, this);
    }

    public void addBefore(ChainLink c, ChainLink here) {
        c.insertBetween(here.prev, here, this);
    }

    public void addEnd(ChainLink c) {
        c.insertBetween(this.end.prev, this.end, this);
    }

    public void addStart(ChainLink c) {
        c.insertBetween(this.start, this.start.next, this);
    }

    public void clear() {
        this.start.next = this.end;
        this.end.prev = this.start;
        this.size = 0;
    }

    public ChainLink remove(ChainLink c) {
        c.unlink();
        return c;
    }

    public Enumeration<Object> elements() {
        return new ChainEnumerator(this.start.next, this.end);
    }

    class ChainEnumerator
    implements Enumeration<Object> {
        protected ChainLink it;
        protected ChainLink end;

        ChainEnumerator(ChainLink it, ChainLink end) {
            this.it = it;
            this.end = end;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it != this.end;
        }

        @Override
        public Object nextElement() {
            this.it = this.it.next;
            return this.it.getObject();
        }
    }
}

