/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2pd.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class PropertyInserter {
    protected static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(PropertyInserter.class.getName());
    protected static Properties properties = new Properties();
    protected static final String SYSTEM_PREFIX = "system.";
    protected static SystemWrapper system = new PropertyInserter().new SystemWrapper();

    public static void setProperties(Properties props) {
        if (props != null) {
            properties = new Properties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                PropertyInserter.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            properties = null;
        }
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
        PropertyInserter.checkForSystemProperty(key, value);
    }

    private static void checkForSystemProperty(String key, String value) {
        if (key.startsWith(SYSTEM_PREFIX)) {
            String systemPropertyName = key.substring(SYSTEM_PREFIX.length());
            try {
                PropertyInserter.setSystemProperty(systemPropertyName, value);
            }
            catch (SecurityException e) {
                cat.warn("Security exception caught while trying to set system property [" + systemPropertyName + "]", (Throwable)e);
            }
        }
    }

    public static void setSystemProperty(String key, String value) throws SecurityException {
        system.setProperty(key, value);
    }

    public static String getProperty(String key) {
        String propertyValue = properties != null ? properties.getProperty(key) : null;
        return propertyValue != null ? propertyValue.trim() : null;
    }

    public static String getProperty(String key, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        return properties.getProperty(key, defaultValue);
    }

    public static int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(PropertyInserter.getProperty(key));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static long getLongProperty(String key, long defaultValue) {
        try {
            return Long.parseLong(PropertyInserter.getProperty(key));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static String insertProperties(String s) {
        if (s == null) {
            return null;
        }
        int is = 0;
        while ((is = s.indexOf("${", is)) != -1) {
            int ie = s.indexOf("}", is + 2);
            if (ie == -1) continue;
            String key = s.substring(is + 2, ie);
            if (key.length() == 0) {
                is += 2;
                continue;
            }
            String val = properties.getProperty(key);
            if (val == null) {
                if (cat.isDebugEnabled()) {
                    cat.debug("no value for key: " + key);
                }
                val = "";
            }
            StringBuffer sb = new StringBuffer(s);
            sb.replace(is, ie + 1, val);
            s = sb.toString();
        }
        return s;
    }

    public static void insertProperties(Element e) {
        Iterator it_attr = e.attributeIterator();
        while (it_attr.hasNext()) {
            Attribute a = (Attribute)it_attr.next();
            a.setValue(PropertyInserter.insertProperties(a.getValue()));
        }
        Iterator it = e.elementIterator();
        if (it != null && it.hasNext()) {
            while (it.hasNext()) {
                PropertyInserter.insertProperties((Element)it.next());
            }
        } else {
            String s = e.getText();
            String si = PropertyInserter.insertProperties(e.getText());
            if (si != s) {
                e.setText(si);
            }
        }
    }

    protected class SystemWrapper {
        protected SystemWrapper() {
        }

        public void setProperty(String key, String value) throws SecurityException {
            System.setProperty(key, value);
        }
    }
}

