/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.Announcer;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.core.MessageTimes;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeIdGuidMapper;
import com.cognos.p2plb.model.NodeTime;
import com.cognos.p2plb.model.NodeView;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class ActBalancedHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(ActBalancedHandler.class.getName());
    private ClusterManager clusterManager;
    private NodeViewPool node_pool;
    private Announcer announcer;
    private PogoEngine pogoEngine;
    private int action;

    public ActBalancedHandler() {
        super(cat);
    }

    public void reportResponseSendStart(SOAPEnvelope env_response, String result) throws SOAPException {
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
        String saction = this.getRequiredAttribute(cat, "action");
        if (saction.equals("prepare")) {
            this.action = 1;
        } else if (saction.equals("pre-send")) {
            this.action = 2;
        } else {
            throw new PogoException("invalid value for action.");
        }
    }

    @Override
    public void initialize() {
        this.clusterManager = (ClusterManager)this.pogoEngine.getContextAttribute("com.cognos.p2plb.clusterManager");
        if (this.clusterManager == null) {
            cat.error("ClusterManager required by ActBalancedHandler is missing from engine context.");
            return;
        }
        this.node_pool = this.clusterManager.getNodePool();
        this.announcer = (Announcer)this.pogoEngine.getContextAttribute("com.cognos.p2plb.announcer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.clusterManager == null) {
            cat.error("handler skipped because it could be not initialized.  Check the logs.");
            return;
        }
        BIBusEnvelope env_request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String cluster_name = env_request.getDispatcherTransportValue("cluster_name");
        if (cluster_name == null) {
            return;
        }
        switch (this.action) {
            case 1: {
                NodeView nv;
                this.announcer.suppressAnnounce();
                NodeID source_nid = null;
                String source = env_request.getDispatcherTransportValue("sourceGUID");
                boolean from_self = false;
                if (source != null) {
                    source_nid = NodeIdGuidMapper.getInstance().get(source);
                    boolean bl = from_self = source_nid != null && source_nid.isSelf();
                }
                if (!from_self && (nv = this.node_pool.get(source_nid)) != null) {
                    NodeTime node_time = nv.getNodeTime();
                    String s_node_time = env_request.getDispatcherTransportValue("p2plb_node_time");
                    if (s_node_time != null && s_node_time.length() > 0) {
                        NodeTime nodeTime = node_time;
                        synchronized (nodeTime) {
                            node_time.fromString(s_node_time);
                            node_time.flipPerspective();
                        }
                    }
                    this.node_pool.nodeIsWell(nv);
                    if (cat.isDebugEnabled()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Source node of forwarded request is up\n").append("\tsource nid: ").append(source_nid.toString()).append(" clock offset: ").append(node_time.getClockOffset());
                        cat.debug(sb.toString());
                    }
                }
                MessageTimes message_times = new MessageTimes();
                message_times.fromString(env_request.getDispatcherTransportValue("p2plb_messagetimes"));
                message_times.setDestIn(mc.getArrivalTime());
                mc.setProperty("actbal.message_times", message_times);
                break;
            }
            case 2: {
                BIBusEnvelope env_response = (BIBusEnvelope)mc.getProperty("response.envelope");
                if (env_response == null) {
                    String responseEnvName;
                    cat.debug("No response envelope named \"response.envelope\", so get name from context");
                    String responseContextName = (String)mc.getProperty("responseContextName");
                    if (responseContextName == null) {
                        cat.debug("no responseContextName property in mc, so give up.");
                    }
                    if ((env_response = (BIBusEnvelope)mc.getProperty(responseEnvName = responseContextName + ".envelope")) == null) {
                        cat.debug("No response envelope named \"" + responseEnvName + "\", give up.");
                        break;
                    }
                }
                MessageTimes message_times = (MessageTimes)mc.getProperty("actbal.message_times");
                message_times.setDestOut();
                env_response.setDispatcherTransport("p2plb_messagetimes", message_times.toString());
                env_response.setDispatcherTransport("p2plb_result", "ok");
            }
        }
    }
}

