/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.Pinger;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeView;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.threads.SafeTimerTask;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class Announcer
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(Announcer.class.getName());
    static final Logger catAnnouncer = Hierarchy.getDefaultHierarchy().getLoggerFor(AnnouncerTask.class.getName());
    private AnnouncerTask announcerTask;
    private PogoEngine pogoEngine;
    private Timer timer;
    private int period;
    private ClusterManager clusterManager;
    private NodeViewPool nodePool;
    private String myServerGroup = "";

    public Announcer() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        cat.warn("Unexpected invoke.");
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.pogoEngine = engine;
        this.pogoEngine.getContext().setAttribute("com.cognos.p2plb.announcer", this);
    }

    public void suppressAnnounce() {
        if (this.announcerTask != null) {
            this.announcerTask.resetMark();
        }
    }

    @Override
    public void initialize() {
        this.clusterManager = (ClusterManager)this.pogoEngine.getContext().getAttribute("com.cognos.p2plb.clusterManager");
        if (this.clusterManager == null) {
            cat.error("Expected ClusterManager in context.");
        }
        this.nodePool = (NodeViewPool)this.pogoEngine.getContext().getAttribute("com.cognos.p2plb.nodepool");
        if (this.nodePool == null) {
            cat.error("Expected NodeViewPool in context.");
        }
        this.timer = (Timer)this.pogoEngine.getContext().getAttribute("com.cognos.p2plb.housekeepingtimer");
        if (this.timer == null) {
            cat.error("Expected timer in context.");
        }
        try {
            this.period = Integer.parseInt(this.getRequiredAttribute(cat, "period_ms"));
        }
        catch (Exception x) {
            cat.error("required attribute \"period_ms \" is missing or not a valid number.");
        }
    }

    @Override
    public void start() {
        if (this.timer != null && this.period > 0) {
            cat.debug("starting announcer task");
            this.announcerTask = new AnnouncerTask(this);
            this.timer.schedule((TimerTask)this.announcerTask, 60000L, (long)this.period);
        }
    }

    @Override
    public void stop() {
        if (this.announcerTask != null) {
            cat.debug("stopping announcer task.");
            this.announcerTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Configuration configuration) {
        String string = this.myServerGroup;
        synchronized (string) {
            this.myServerGroup = configuration.getLocalServerGroup();
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean announce() {
        ClusterView cv;
        String string = this.myServerGroup;
        synchronized (string) {
            cv = this.clusterManager.getClusterView(this.myServerGroup);
        }
        if (cv == null || cv.isRetired()) {
            cat.debug("skip announce because cluster is not yet initialized.");
            return false;
        }
        cat.debug("Announcing...");
        Pinger pinger = new Pinger();
        Iterator<Map.Entry<NodeID, ClusterNodeView>> itCNV = cv.iterator();
        boolean hasNodesOtherThanSelf = false;
        while (itCNV.hasNext()) {
            Map.Entry<NodeID, ClusterNodeView> me = itCNV.next();
            ClusterNodeView cnv = me.getValue();
            NodeView nv = cnv.getNodeView();
            NodeID nid = nv.getNodeID();
            if (nid.isSelf()) continue;
            if (nv.getState() != 1) {
                if (!cat.isDebugEnabled()) continue;
                cat.debug("Skip announcing to down node: " + nid.toString());
                continue;
            }
            hasNodesOtherThanSelf = true;
            if (nid.getHostInetAddress() == null) {
                this.nodePool.nodeIsSick(nv);
                cat.info("host unknown for node " + nid.toString());
                continue;
            }
            if (pinger.ping(nv, null)) {
                this.nodePool.nodeIsWell(nv);
                cat.info("successfully pinged node " + nid.toString());
                return true;
            }
            this.nodePool.nodeIsSick(nv);
            cat.info("failed to ping node " + nid.toString());
        }
        cat.debug("Finished announcing...");
        return !hasNodesOtherThanSelf;
    }

    static class AnnouncerTask
    extends SafeTimerTask {
        Announcer announcer;
        private int tic_limit = 12;
        private int tics = 8;
        boolean needToAnnounce = true;

        public void resetMark() {
            this.needToAnnounce = false;
        }

        AnnouncerTask(Announcer announcer) {
            this.announcer = announcer;
        }

        @Override
        public void safeRun() {
            if (this.announcer != null) {
                try {
                    if (this.needToAnnounce && ++this.tics >= this.tic_limit) {
                        this.announcer.announce();
                        this.tics = 0;
                    }
                    this.needToAnnounce = true;
                }
                catch (RuntimeException e) {
                    catAnnouncer.error("Swallowed unexpected exception:", (Throwable)e);
                }
            }
        }
    }
}

