/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.LoadBalanceHandler;
import com.cognos.pogo.bibus.SOAPAction;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class DoLocallyIfNoCandidatesHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(DoLocallyIfNoCandidatesHandler.class.getName());
    private LoadBalanceHandler lbHandler;
    private String serviceName;

    public DoLocallyIfNoCandidatesHandler() {
        super(cat);
    }

    @Override
    public void contextualize(Element config) throws PogoException {
        super.contextualize(config);
        this.serviceName = config.attributeValue("serviceName");
        if (this.serviceName == null) {
            this.serviceName = "presentationService";
        }
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.lbHandler = (LoadBalanceHandler)engine.getHandlerPool().find("bal.lb_forwarder");
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (!mc.isFaulted()) {
            return;
        }
        boolean debug = cat.isDebugEnabled();
        Fault fault = mc.getFault();
        String msgCode = fault.getMessageCode();
        if (debug) {
            cat.debug("testing fault with message code: " + msgCode);
        }
        if (!"NO_NODES_TO_FORWARD_TO".equals(msgCode) && !"NO_CANDIDATES".equals(msgCode)) {
            cat.debug("Fault is not NO_CANDIDATES or NO_NODES_TO_FORWARD_TO so do not force local processing.");
            return;
        }
        if (this.lbHandler == null) {
            cat.debug("Cannot find LoadBalanceHandler.  Cannot try local handler");
            return;
        }
        String reqSoapAction = mc.getStrProperty("request.soapaction");
        SOAPAction sAction = new SOAPAction(reqSoapAction);
        String requestServiceName = this.lbHandler.lookupServiceName(sAction);
        if (!this.serviceName.equals(requestServiceName)) {
            if (debug) {
                cat.debug("request SOAPAction: " + reqSoapAction + " does not map to " + this.serviceName + " so do not force local processing.");
            }
            return;
        }
        if (debug) {
            cat.debug("Forcing local processing for request. SOAPAction is " + reqSoapAction + ", fault code is: " + msgCode);
        }
        String localSOAPAction = LoadBalanceHandler.makeLocal(reqSoapAction);
        mc.setProperty("request.soapaction", localSOAPAction);
        ((InternetHeaders)mc.getProperty("request.headers")).setHeader("SOAPAction", localSOAPAction);
        if (cat.isDebugEnabled()) {
            cat.debug("remapped load balanced request to: " + localSOAPAction);
        }
        mc.setProperty("processLocally", Boolean.TRUE);
        mc.setFault(null);
    }
}

