/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.p2plb.clerver.AdditionalServicesFactory;
import com.cognos.p2plb.clerver.AdditionalServicesUpdater;
import com.cognos.p2plb.clerver.CheckForMonitorServiceParameter;
import com.cognos.p2plb.clerver.ConnectionPoolMap;
import com.cognos.p2plb.clerver.LoadBalanceConfigurationParameter;
import com.cognos.p2plb.clerver.actions.BalancingParameters;
import com.cognos.p2plb.clerver.actions.ForwardingParams;
import com.cognos.p2plb.clerver.actions.MapSoapActionToService;
import com.cognos.p2plb.clerver.actions.MapSoapActionToServiceUpdater;
import com.cognos.p2plb.clerver.balancer.LoadBalanceRequest;
import com.cognos.p2plb.clerver.balancer.LoadBalanceRequestParameters;
import com.cognos.p2plb.clerver.balancer.RequestForwarder;
import com.cognos.p2plb.clerver.balancer.RequestForwarderFactory;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.p2plb.model.NodeHospital;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeViewPool;
import com.cognos.p2plb.util.ActionQueue;
import com.cognos.pogo.bibus.SOAPAction;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.cognos.pogo.transport.RemoteDispatcherPool;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import java.util.Timer;
import javax.management.MalformedObjectNameException;
import org.dom4j.Element;

public class LoadBalanceHandler
extends BasicHandler
implements RemoteDispatcherPool,
PogoTimerOwner {
    private static final int STARTUP_DELAY = 40000;
    private static final PogoLogger cat = PogoLogger.getLogger();
    private ClusterManager clusterManager;
    private PogoEngine pogoEngine;
    private boolean enabled;
    private boolean hasStarted;
    private MapSoapActionToService mapSOAPActionToService;
    private Handler loadBalanceServiceHandler;
    private NodeHospital node_hospital;
    private boolean clusterCompatibleMode = false;
    private String myServerGroup = "";
    private final ConnectionPoolMap connectionPoolMap;
    private final AdditionalServicesFactory factory;
    private AdditionalServicesUpdater additionalServicesupdater;
    private final PogoMBeanServer pogoMBeanServer;
    private Element balXmlServices;
    private MapSoapActionToServiceUpdater updater;
    private final RequestForwarderFactory requestForwarderFactory;
    private LoadBalanceConfigurationParameter loadBalanceConfigurationParameter = new LoadBalanceConfigurationParameter();
    private CheckForMonitorServiceParameter checkForMonitorServiceParameter = new CheckForMonitorServiceParameter();
    private double partialSaxReaderMBLimit;
    private boolean checkForMonitorService = false;
    public static boolean kubernetesMode = Boolean.parseBoolean(System.getenv("KUBERNETES_MODE"));

    public LoadBalanceHandler() {
        this(new AdditionalServicesFactory(), new ConnectionPoolMap(), PogoMBeanServer.getInstance(), new RequestForwarderFactory());
    }

    public LoadBalanceHandler(AdditionalServicesFactory factory, ConnectionPoolMap connectionPoolMap, PogoMBeanServer pogoMBeanServer, RequestForwarderFactory requestForwarderFactory) {
        super(cat.getNativeLogger());
        this.factory = factory;
        this.connectionPoolMap = connectionPoolMap;
        this.pogoMBeanServer = pogoMBeanServer;
        this.requestForwarderFactory = requestForwarderFactory;
        this.enabled = true;
        if (kubernetesMode) {
            this.enabled = false;
        }
    }

    public boolean waitForStarted() {
        if (!this.hasStarted && this.enabled) {
            this.waitForDelayedStartup();
        }
        return this.hasStarted;
    }

    private synchronized void waitForDelayedStartup() {
        cat.debug("waiting for delayed startup");
        try {
            this.wait(40000L);
        }
        catch (InterruptedException e) {
            cat.warn("interrupted while waiting for delayed startup", e);
        }
        cat.debug("finished waiting for delayed startup");
    }

    protected void setStarted() {
        new PogoTimer(this, null, 40000L);
    }

    @Override
    public synchronized void handleTimeoutEvent(Object parameter) throws Exception {
        cat.debug("starting after delay");
        this.hasStarted = true;
        this.notifyAll();
    }

    @Override
    public void compose_impl(PogoEngine engine) throws PogoException {
        this.setPogoEngine(engine);
        if (kubernetesMode) {
            this.enabled = false;
            cat.info("Load Balancing is not enabled by ENV KUBERNETES_MODE=true");
        } else {
            this.enabled = "true".equalsIgnoreCase(this.getRequiredAttribute(cat.getNativeLogger(), "enabled"));
            if (!this.enabled) {
                cat.info("LoadBalancing is not enabled.");
            }
        }
        String loadBalanceServiceHandlerName = this.getRequiredAttribute(cat.getNativeLogger(), "loadBalanceServiceHandlerName");
        this.loadBalanceServiceHandler = engine.lookupHandler(loadBalanceServiceHandlerName);
        if (this.loadBalanceServiceHandler == null) {
            cat.error(this.getFullName(), " config error: loadBalanceServiceHandler named \"", loadBalanceServiceHandlerName, "\"not found");
            throw new PogoException(this.getFullName() + " config error: channel handler not found");
        }
        if (this.mapSOAPActionToService == null) {
            this.mapSOAPActionToService = new MapSoapActionToService(this.loadBalanceServiceHandler, this.pogoEngine.getDispatcherServices());
        }
        NodeViewPool node_pool = new NodeViewPool();
        Timer timer = (Timer)this.pogoEngine.getContextAttribute("com.cognos.p2plb.housekeepingtimer");
        ActionQueue action_queue = (ActionQueue)engine.getContextAttribute("com.cognos.p2plb.action_queue");
        this.node_hospital = new NodeHospital(action_queue, timer);
        this.node_hospital.setThePool(node_pool);
        this.node_hospital.init(this.getConfig());
        node_pool.setNodeHospital(this.node_hospital);
        this.pogoEngine.getContext().setAttribute("com.cognos.p2plb.nodepool", node_pool);
        this.node_hospital.start();
        this.clusterManager = new ClusterManager(node_pool, action_queue);
        this.pogoEngine.getContext().setAttribute("com.cognos.p2plb.clusterManager", this.clusterManager);
        this.additionalServicesupdater = this.createAdditionalServiceUpdater();
        this.connectionPoolMap.configure(this.getConfig());
        this.connectionPoolMap.startTimer();
        DispatcherConnectionManager.registerRemoteDispatcherPool(this);
        this.updater = new MapSoapActionToServiceUpdater(this.mapSOAPActionToService, this.pogoMBeanServer);
        if (this.enabled) {
            this.registerUpdaters();
        }
    }

    private AdditionalServicesUpdater createAdditionalServiceUpdater() {
        return this.factory.createAdditionalServicesUpdater(this.clusterManager);
    }

    AdditionalServicesUpdater getAdditionalServiceUpdater() {
        return this.additionalServicesupdater;
    }

    private void setPogoEngine(PogoEngine engine) {
        this.pogoEngine = engine;
    }

    @Deprecated
    public void setPogoEngineForTesting(PogoEngine engine) {
        this.setPogoEngine(engine);
    }

    public void setAdditionalServicesUpdaterForTesting(AdditionalServicesUpdater updater) {
        this.additionalServicesupdater = updater;
    }

    @Override
    public void configure(Configuration configuration) {
        this.configureAdvancedParamaters(configuration);
        this.configureLB(configuration);
        this.myServerGroup = configuration.getLocalServerGroup();
        this.getNodeHospital().configure(configuration);
        this.setAdditionalServicesUpdaterConfiguration(configuration);
    }

    private void configureAdvancedParamaters(Configuration configuration) {
        this.loadBalanceConfigurationParameter.updateConfiguration(configuration);
        this.partialSaxReaderMBLimit = this.loadBalanceConfigurationParameter.getPartialSaxReaderMBLimit();
        this.checkForMonitorService = this.checkForMonitorServiceParameter.isCheckForMonitorService();
    }

    private void configureLB(Configuration configuration) {
        String loadBalancingMode = configuration.getLocalLoadBalancingMode();
        cat.debug("loadBalancingMode is ", loadBalancingMode);
        this.clusterCompatibleMode = "clusterCompatible".equals(loadBalancingMode);
        if (!this.enabled) {
            this.clusterCompatibleMode = true;
        }
        this.setAdditionalServicesUpdaterConfiguration(configuration);
    }

    private void setAdditionalServicesUpdaterConfiguration(Configuration configuration) {
        if (this.additionalServicesupdater != null) {
            this.additionalServicesupdater.setConfiguration(configuration);
        }
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configureAdvancedParamaters(configuration);
        this.configureLB(configuration);
        this.checkRemoteSoapActions();
        this.myServerGroup = configuration.getLocalServerGroup();
        this.getNodeHospital().reconfigure(configuration);
    }

    @Override
    public void initialize() {
        this.balXmlServices = this.getConfig().element("balanceThese");
        if (this.balXmlServices == null) {
            cat.debug("no services configured for load balancing");
            return;
        }
        this.mapSOAPActionToService.interceptSoapActions(this.balXmlServices);
    }

    public String lookupServiceName(SOAPAction soapAction) {
        return this.mapSOAPActionToService.get(soapAction.getRoot());
    }

    public static String makeLocal(String soapAction) {
        int pos = soapAction.indexOf("#");
        if (pos == -1) {
            return new StringBuffer("local.").append(soapAction).toString();
        }
        StringBuffer sb = new StringBuffer(soapAction);
        sb.insert(pos + 1, "local.");
        return sb.toString();
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        LoadBalanceRequest loadBalanceRequest = new LoadBalanceRequest(new LoadBalanceRequestParameters(this.myServerGroup, this.mapSOAPActionToService, this.clusterManager, this.clusterCompatibleMode, mc));
        RequestForwarder requestForwarder = this.requestForwarderFactory.createRequestForwarder(this, this.pogoEngine);
        requestForwarder.setCheckForMonitorService(this.checkForMonitorService);
        if (!this.enabled && mc != null) {
            requestForwarder.forwardToSelf((String)mc.getProperty("request.soapaction"), mc, true);
        } else {
            loadBalanceRequest.processRequest(requestForwarder);
        }
    }

    @Override
    public void start() {
        cat.debug("starting");
        this.checkRemoteSoapActions();
        this.setStarted();
    }

    private void checkRemoteSoapActions() {
        try {
            if (this.enabled) {
                this.checkForRemoteBalancing();
            }
            this.checkForAdditionalServices();
        }
        catch (Exception e) {
            cat.warn("Unable to check for remote soap action updates ", e);
        }
    }

    private void registerUpdaters() {
        if (this.updater != null) {
            this.updater.register();
        }
        if (this.additionalServicesupdater != null) {
            this.additionalServicesupdater.register();
        }
    }

    void checkForRemoteBalancing() throws MalformedObjectNameException {
        if (this.updater != null) {
            cat.debug("checkForRemoteBalancing");
            this.updater.getMBeanActions();
        }
    }

    void checkForAdditionalServices() throws MalformedObjectNameException {
        cat.debug("checkForAdditionalServices");
        this.additionalServicesupdater.createClusterFromConfiguration();
    }

    @Override
    public void stop() {
        if (this.connectionPoolMap != null) {
            this.connectionPoolMap.destroy();
        }
    }

    public String getSoapActionToServiceMapping() {
        return this.mapSOAPActionToService.toString();
    }

    @Override
    public ServerConnection getConnection(NodeID nid) {
        return this.connectionPoolMap.getConnection(nid);
    }

    ClusterView getGlobalClusterView() {
        return this.clusterManager.getGlobalClusterView();
    }

    public void addBalancingParameters(BalancingParameters balancingParameters) {
        this.mapSOAPActionToService.addBalancing(balancingParameters);
    }

    public ForwardingParams getForwardingParams(String serviceName) {
        return this.mapSOAPActionToService.getForwardingParams(serviceName);
    }

    public boolean isSoapActionSupported(String soapAction, NodeID nodeID) {
        return this.mapSOAPActionToService != null && this.mapSOAPActionToService.isSoapActionSupported(soapAction, nodeID.getHostPortAndContext());
    }

    public void setMapSOAPActionToServiceForTesting(MapSoapActionToService mapSOAPActionToService) {
        this.mapSOAPActionToService = mapSOAPActionToService;
    }

    public void setMapSoapActionToServiceUpdaterForTest(MapSoapActionToServiceUpdater updater) {
        this.updater = updater;
    }

    double getPartialSaxReaderMBLimit() {
        return this.partialSaxReaderMBLimit;
    }

    private NodeHospital getNodeHospital() {
        return this.node_hospital;
    }

    void setNodeHospital(NodeHospital node_hospital) {
        this.node_hospital = node_hospital;
    }
}

