/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RevertToNonAffineHandler
extends BasicHandler {
    static final Logger cat = Hierarchy.getDefaultHierarchy().getLoggerFor(RevertToNonAffineHandler.class.getName());
    private static final String dotServer = ".server";
    private static final int dsLen = ".server".length();

    public RevertToNonAffineHandler() {
        super(cat);
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String soapAction = (String)mc.getProperty("request.soapaction");
        if (!soapAction.endsWith(dotServer)) {
            return;
        }
        BIBusEnvelope request_env = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (request_env == null) {
            return;
        }
        String targetGuid = request_env.getConversationContextNodeID();
        if (targetGuid == null || targetGuid.length() == 0) {
            String saNonAffine = soapAction.substring(0, soapAction.length() - dsLen);
            mc.setProperty("request.soapaction", saNonAffine);
            request_env.clearConversationContext();
            if (cat.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Request with \".server\" affinity without nodeID in conversationContext.  Reverted to non-affine. ");
                sb.append("Changed SOAPAction from ").append(soapAction).append(" to ").append(saNonAffine);
                cat.debug(sb.toString());
            }
        }
    }
}

