/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.balancer;

import com.cognos.p2plb.clerver.actions.ForwardingParams;
import com.cognos.p2plb.clerver.actions.MapSoapActionToService;
import com.cognos.p2plb.config.ClusterManager;
import com.cognos.p2plb.model.ClusterView;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;

public class LoadBalanceRequestParameters {
    private static final PogoLogger cat = PogoLogger.getLogger();
    private ClusterManager clusterManager;
    private BIBusEnvelope requestEnvelope;
    private MapSoapActionToService mapSOAPActionToService;
    private String soapAction;
    private String serviceName;
    private boolean clusterCompatibleMode;
    private MessageContext mc;
    private final int partialSaxReaderMBLimit;

    public LoadBalanceRequestParameters(String myServerGroup, MapSoapActionToService mapSOAPActionToService, ClusterManager clusterManager, boolean clusterCompatibleMode, MessageContext mc) {
        this(myServerGroup, mapSOAPActionToService, clusterManager, clusterCompatibleMode, mc, 0);
    }

    public LoadBalanceRequestParameters(String myServerGroup, MapSoapActionToService mapSOAPActionToService, ClusterManager clusterManager, boolean clusterCompatibleMode, MessageContext mc, int partialSaxReaderMBLimit) {
        this.mapSOAPActionToService = mapSOAPActionToService;
        this.clusterManager = clusterManager;
        this.clusterCompatibleMode = clusterCompatibleMode;
        this.mc = mc;
        this.partialSaxReaderMBLimit = partialSaxReaderMBLimit;
    }

    public void setRequestEnvelope(BIBusEnvelope request_env) {
        this.requestEnvelope = request_env;
    }

    public void clearConversationContext() {
        this.requestEnvelope.clearConversationContext();
    }

    public String extractSoapActionFromMessageContext() {
        String soapAction = (String)this.mc.getProperty("request.soapaction");
        int pos = soapAction.indexOf(35);
        if (pos != -1) {
            soapAction = soapAction.substring(pos + 1);
        }
        this.soapAction = soapAction;
        return soapAction;
    }

    public boolean isClusterCompatibleMode() {
        return this.clusterCompatibleMode;
    }

    public ClusterView getClusterViewForServerGroup() {
        String requestedServerGroup = this.getServerGroupFromRequest();
        ClusterView cv = requestedServerGroup == null ? this.clusterManager.getGlobalClusterView() : this.clusterManager.getClusterView(requestedServerGroup);
        if (cv == null) {
            this.faultDueToUnknownServerGroup(this.mc, requestedServerGroup);
            return null;
        }
        cat.debug("Using cluster ", cv.getClusterName(), " based on the serverGroup information");
        return cv;
    }

    void faultDueToUnknownServerGroup(MessageContext mc, String requestedServerGroup) {
        cat.error("The request asked for an unknown serverGroup: ", requestedServerGroup);
        this.setFault("LoadBalanceHandler.unknownServerGroup", requestedServerGroup);
    }

    public String getConversationContextNodeID() {
        return this.requestEnvelope.getConversationContextNodeID();
    }

    public ForwardingParams getForwardingParameters() {
        return this.mapSOAPActionToService.getForwardingParams(this.serviceName);
    }

    public ClusterView getGlobalClusterView() {
        return this.clusterManager.getGlobalClusterView();
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public BIBusEnvelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    public boolean isPreferLocal() {
        return this.getForwardingParameters() == null ? false : this.getForwardingParameters().isPreferLocal();
    }

    public String getRequestRoutingServerGroup() {
        return this.requestEnvelope.getRoutingServerGroup();
    }

    String getServerGroupFromRequest() {
        String requestedServerGroup = this.requestEnvelope.getRoutingServerGroup();
        if (requestedServerGroup == null) {
            cat.debug("No routing server group, using global group");
        } else {
            cat.debug("The request contains routingServerGroup=", requestedServerGroup);
        }
        return requestedServerGroup;
    }

    public String getServiceNameFromSoapAction() {
        this.serviceName = this.mapSOAPActionToService.get(this.soapAction);
        return this.serviceName;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void resetFault() {
        this.mc.setFault(null);
    }

    public void setFault(String faultName, String faultParameter) {
        Fault f = new Fault(faultName);
        f.setMessageParameters(new Object[]{faultParameter});
        this.mc.setFault(f);
    }

    public void setFault(String faultMessage) {
        Fault f = new Fault(faultMessage);
        this.mc.setFault(f);
    }

    public void setMessageContextProperty(String propertyName, Object property) {
        this.mc.setProperty(propertyName, property);
    }

    public boolean isRetryOnNoProcess() {
        ForwardingParams fwdParam = this.getForwardingParameters();
        return fwdParam.getRetryOnNoProcess();
    }

    public int getPartialSaxReaderMBLimit() {
        return this.partialSaxReaderMBLimit;
    }

    void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

