/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.p2plb.clerver.balancer;

import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.p2plb.clerver.Announcer;
import com.cognos.p2plb.clerver.LBForwardingPassThroughCommand;
import com.cognos.p2plb.clerver.LBForwardingPassThroughGETCommand;
import com.cognos.p2plb.clerver.LoadBalanceHandler;
import com.cognos.p2plb.clerver.PerfIndicationHelper;
import com.cognos.p2plb.clerver.balancer.LoadBalanceRequestParameters;
import com.cognos.p2plb.clerver.balancer.OMBridgeHelper;
import com.cognos.p2plb.clerver.balancer.RequestForwardingResult;
import com.cognos.p2plb.core.MessageTimes;
import com.cognos.p2plb.model.ClusterNodeView;
import com.cognos.p2plb.model.NodeID;
import com.cognos.p2plb.model.NodeTime;
import com.cognos.p2plb.model.NodeView;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.CommandExecutionIOException;
import com.cognos.pogo.bibus.RequestAffinity;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MCUtils;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BodyFaultDetail;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.reqlog.RequestLog;
import com.cognos.pogo.transport.FormRequestProcessor;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.Version;
import com.ibm.cognos.internal.ombridge.BibusSoapAction;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.lang.StringUtils;

public class RequestForwarder {
    private static final PogoLogger cat = PogoLogger.getLogger();
    public static final String SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/rxBalancedRequest" + FormRequestProcessor.C10_SERVICE_VERSION_SUFFIX;
    public static final String CASPIAN_SOAP_ACTION = "http://www.ibm.com/xmlns/prod/cognos/rxBalancedRequest/201301/";
    public static final String COLORADO_SOAP_ACTION = "rxBalancedRequest";
    private static final String NO_LOCAL_HANDLER = "NO_LOCAL_HANDLER";
    private static final String MONITOR_SERVICE = "MonitorServiceRequest";
    private static LogTypedLogger perflogger = LogTypedLogger.getInstance((String)"Perf.dispatcher.lb", LogPerfIndication.class);
    private final LoadBalanceHandler loadBalanceHandler;
    private final PogoEngine pogoEngine;
    private LoadBalanceRequestParameters parameters;
    private final OMBridgeHelper omBridgeHelper;
    private boolean checkForMonitorService = true;

    public RequestForwarder(LoadBalanceHandler loadBalanceHandler, PogoEngine pogoEngine) {
        this(loadBalanceHandler, pogoEngine, new OMBridgeHelper());
    }

    public RequestForwarder(LoadBalanceHandler loadBalanceHandler, PogoEngine pogoEngine, OMBridgeHelper omBridgeHelper) {
        this.loadBalanceHandler = loadBalanceHandler;
        this.pogoEngine = pogoEngine;
        this.omBridgeHelper = omBridgeHelper;
    }

    public RequestForwardingResult forwardRequest(ClusterNodeView cnv, LoadBalanceRequestParameters parameters) {
        this.parameters = parameters;
        String soapAction = parameters.getSoapAction();
        if (this.isNotSupported(soapAction, cnv)) {
            cat.debug(cnv.getNodeID(), " does not support soap action [", soapAction, "]. ");
            return RequestForwardingResult.FAILURE;
        }
        BIBusEnvelope request_env = parameters.getRequestEnvelope();
        MessageContext mc = parameters.getMessageContext();
        NodeID nid = cnv.getNodeID();
        if (nid.isSelf()) {
            return this.forwardToSelf(soapAction, mc, cnv.getNodeView());
        }
        NodeTime node_time = cnv.getNodeView().getNodeTime();
        if (!node_time.isBogus()) {
            request_env.setDispatcherTransport("p2plb_node_time", node_time.toString());
        }
        request_env.setDispatcherTransport("targetGUID", nid.getGuid());
        request_env.setDispatcherTransport("sourceGUID", NodeID.getSelf().getGuid());
        MessageTimes message_times = new MessageTimes();
        RequestForwardingResult forwardErrorCode = this.forward(cnv.getNodeView(), request_env, mc, message_times);
        if (!forwardErrorCode.isSuccess()) {
            cat.debug("Failed to forward to node");
            if (forwardErrorCode.isAvailable()) {
                cat.debug("Node is just out of processes, don't set as sick");
            } else {
                cnv.getClusterView().getNodePool().nodeIsSick(cnv.getNodeView());
            }
            return forwardErrorCode;
        }
        String statusCode = (String)mc.getProperty("response.status_code");
        if ("304".equals(statusCode)) {
            cat.debug("got a 304 response");
            return forwardErrorCode;
        }
        BIBusEnvelope response_env = (BIBusEnvelope)mc.getProperty("response.envelope");
        if (response_env == null) {
            cat.error("failed to forward to node, no response envelope, node is ", nid.toString());
            return RequestForwardingResult.FAILURE;
        }
        cat.debug("forward succeeded");
        this.processResponse(response_env, nid, cnv, message_times);
        return forwardErrorCode;
    }

    private boolean isNotSupported(String soapAction, ClusterNodeView cnv) {
        return this.loadBalanceHandler != null && !this.loadBalanceHandler.isSoapActionSupported(soapAction, cnv.getNodeID());
    }

    private void processResponse(BIBusEnvelope response_env, NodeID nid, ClusterNodeView cnv, MessageTimes message_times) {
        String s = response_env.getDispatcherTransportValue("affine");
        boolean processed_as_affine = "true".equals(s);
        NodeTime node_time = cnv.getNodeView().getNodeTime();
        node_time.set(message_times);
        cnv.getClusterView().reviseNodeView(nid, node_time, null, processed_as_affine);
        Announcer announcer = (Announcer)this.pogoEngine.getContextAttribute("com.cognos.p2plb.announcer");
        announcer.suppressAnnounce();
    }

    private RequestForwardingResult forwardToSelf(String soapAction, MessageContext mc, NodeView nv) {
        cat.debug("forwarding to self, and bumping the in-progress request count.");
        this.incrementInProgressRequests(mc, nv);
        return this.forwardToSelf(soapAction, mc, true);
    }

    void incrementInProgressRequests(MessageContext mc, NodeView nv) {
        List<Cleanable> cleanables = MCUtils.getCleanables(mc);
        InProgressRequestHash inProgressRequestHash = (InProgressRequestHash)mc.getProperty("inProgressRequests");
        if (inProgressRequestHash == null) {
            inProgressRequestHash = new InProgressRequestHash();
            mc.setProperty("inProgressRequests", inProgressRequestHash);
        }
        inProgressRequestHash.increment(nv);
        if (!cleanables.contains(inProgressRequestHash)) {
            cleanables.add(inProgressRequestHash);
        }
    }

    public RequestForwardingResult forwardToSelf(String soapAction, MessageContext mc, boolean raiseFaultIfNoLocalHandler) {
        RequestForwardingResult res;
        RequestLog rlog = (RequestLog)mc.getProperty("reqlog");
        if (rlog != null) {
            rlog.splitTime("preForwardToSelf");
        }
        if (perflogger.isEnabled(1)) {
            PerfIndicationHelper pind = new PerfIndicationHelper(mc, 1, "LoadBalancer", "forwardToSelf");
            pind.start(perflogger);
            res = this.rawForwardToSelf(soapAction, mc, raiseFaultIfNoLocalHandler);
            pind.stop(perflogger, "local");
        } else {
            res = this.rawForwardToSelf(soapAction, mc, raiseFaultIfNoLocalHandler);
        }
        if (rlog != null) {
            rlog.splitTime("postForwardToSelf");
        }
        return res;
    }

    private RequestForwardingResult rawForwardToSelf(String soapAction, MessageContext mc, boolean raiseFaultIfNoLocalHandler) {
        cat.debug("\"forward\" to self via local handler");
        Handler local_handler = this.getLocalHandlerForSoapAction(soapAction);
        if (local_handler == null) {
            if (raiseFaultIfNoLocalHandler) {
                cat.info("local handler for request aimed at: ", soapAction, " is unknown.");
                Fault f = new Fault(NO_LOCAL_HANDLER);
                f.setMessageParameters(new Object[]{LoadBalanceHandler.makeLocal(soapAction)});
                mc.setFault(f);
            }
            return RequestForwardingResult.FAILURE;
        }
        mc.setProperty("jmeter.target_nid", NodeID.getSelf());
        try {
            this.pogoEngine.invokeHandler(local_handler, mc);
            return this.successForMonitorService(mc) ? RequestForwardingResult.SUCCESS : this.getRequestForwardingResult(mc);
        }
        catch (PogoException x) {
            cat.error("Exception while \"forwarding\" to local handler:", x);
            Fault fault = mc.getFault();
            if (fault == null || fault.getMessageCode().equals("AbortIfSuspendedHandler.serviceStopped")) {
                Fault noLocalFault = new Fault(NO_LOCAL_HANDLER);
                noLocalFault.setMessageParameters(new Object[]{LoadBalanceHandler.makeLocal(soapAction)});
                mc.setFault(noLocalFault);
            }
            return RequestForwardingResult.FAILURE;
        }
    }

    private boolean successForMonitorService(MessageContext mc) {
        return this.checkForMonitorService && this.isFromMonitorService(mc);
    }

    private boolean isFromMonitorService(MessageContext mc) {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        return requestEnvelope.isFromService(MONITOR_SERVICE);
    }

    public void setCheckForMonitorService(boolean check) {
        cat.debug("checkForMonitorService set to: ", check);
        this.checkForMonitorService = check;
    }

    private RequestForwardingResult getRequestForwardingResult(MessageContext mc) {
        Fault fault = mc.getFault();
        if (fault != null && fault.isCreatedFromSOAPEnvelope()) {
            SOAPEnvelope env = fault.generateEnvelope();
            if (env instanceof BIBusEnvelope) {
                return this.createRequestForwardingResult((BIBusEnvelope)env);
            }
        } else if (fault != null && fault.getMessageCode() != null) {
            String faultstr = fault.getMessageCode();
            try {
                RequestForwardingResult result = RequestForwardingResult.valueOf(faultstr.replace(".", ""));
                cat.debug("getRequestForwardingResult() - RequestForwardingResult is - ", result.toString());
                return result;
            }
            catch (IllegalArgumentException e) {
                cat.debug("getRequestForwardingResult() - IllegalArgumentException - Unknown error code : ", faultstr);
                return RequestForwardingResult.FAILURE;
            }
        }
        return fault == null ? RequestForwardingResult.SUCCESS : RequestForwardingResult.FAILURE;
    }

    Handler getLocalHandlerForSoapAction(String soapAction) {
        String localTarget = LoadBalanceHandler.makeLocal(soapAction);
        return this.pogoEngine.lookupService(localTarget);
    }

    protected RequestForwardingResult forward(NodeView nv, BIBusEnvelope request_env, MessageContext mc, MessageTimes message_times) {
        RequestForwardingResult res;
        RequestLog rlog = (RequestLog)mc.getProperty("reqlog");
        if (rlog != null) {
            rlog.splitTime("preForward");
        }
        this.loadBalanceHandler.waitForStarted();
        if (perflogger.isEnabled(1)) {
            PerfIndicationHelper pind = new PerfIndicationHelper(mc, 1, "LoadBalancer", "forward");
            pind.start(perflogger);
            res = this.rawForward(nv, request_env, mc, message_times);
            pind.stop(perflogger, nv.getNodeID().toInetString());
        } else {
            res = this.rawForward(nv, request_env, mc, message_times);
        }
        if (rlog != null) {
            rlog.splitTime("postForward");
            if (res.isSuccess()) {
                rlog.addNote("lbtarget", nv.getNodeID().getHost());
            }
        }
        return res;
    }

    private RequestForwardingResult rawForward(NodeView nv, BIBusEnvelope request_env, MessageContext mc, MessageTimes message_times) {
        NodeID nid = nv.getNodeID();
        if (nid.getHostInetAddress() == null || nid.getPort() == 0) {
            return RequestForwardingResult.UNAVAILABLE;
        }
        this.updateHeaders(mc, nv.getEdition(), request_env);
        request_env = this.maybeBridgeRequest(mc, nv.getEdition(), request_env);
        ServerConnection connection = this.loadBalanceHandler.getConnection(nid);
        String htmlErrorPageFlag = this.obtainHtmlFlag(request_env);
        request_env.setDispatcherTransport("balancedRequest", "true");
        String pathInfo = mc.getStrProperty("path_info");
        String path = pathInfo != null && pathInfo.length() > 0 ? nid.getPath() + pathInfo : nid.getPath();
        LBForwardingPassThroughCommand cmd = this.createLbForwardingPassthroughCommand(request_env, mc, connection, path);
        Iterator<InputStream> attachments = this.getRequestAttachments(mc);
        if (attachments != null) {
            cmd.setRequestAttachments(attachments);
        }
        List<Cleanable> cleanables = MCUtils.getCleanables(mc);
        message_times.setSrcOut();
        request_env.setDispatcherTransport("p2plb_messagetimes", message_times.toString());
        RequestForwardingResult result = RequestForwardingResult.FAILURE;
        try {
            BIBusEnvelope response_env;
            this.incrementInProgressRequests(mc, nv);
            try {
                cmd.execute();
            }
            catch (SoapFaultException sfx) {
                cat.debug("Reply to forwarded request was a SOAP fault: ", sfx.getMessage());
                response_env = cmd.getResponseEnvelope();
                RequestForwardingResult errorCode = this.createRequestForwardingResult(response_env);
                if (!errorCode.isSuccess()) {
                    cat.debug(new Object[]{"Failed to forward to node ", nid.toString(), " because of a (potentially) recoverable fault: ", errorCode});
                    cmd.clean(mc);
                    return errorCode;
                }
                mc.setFault(new Fault(response_env.getFaultCode(), response_env));
            }
            int statusCode = cmd.getStatusCode();
            if (statusCode == 304) {
                cat.debug("got a 304 response from the other node.");
                mc.setProperty("response.status_code", "304");
                mc.setProperty("response.status_msg", cmd.getStatusString());
                mc.setProperty("response.t_resp_in", new Long(System.currentTimeMillis()));
                mc.setProperty("response.headers", cmd.getResponseMIMEHeaders());
                cleanables.add(cmd);
                return RequestForwardingResult.SUCCESS;
            }
            response_env = cmd.getResponseEnvelope();
            if (response_env != null || !cmd.supportsResponseEnvelope()) {
                if (response_env == null) {
                    response_env = new BIBusEnvelope();
                }
                message_times.fromString(response_env.getDispatcherTransportValue("p2plb_messagetimes"));
                message_times.setSrcIn();
                request_env.setDispatcherTransport("html", htmlErrorPageFlag);
                mc.setProperty("response.t_resp_in", new Long(System.currentTimeMillis()));
                mc.setProperty("response.headers", cmd.getResponseMIMEHeaders());
                mc.setProperty("response.envelope", response_env);
                mc.setProperty("response.attachments", cmd.getAttachments());
                mc.setProperty("response.boundary", cmd.getBoundary());
                mc.setProperty("response.status_code", Integer.toString(cmd.getStatusCode()));
                mc.setProperty("response.status_msg", cmd.getStatusString());
                cleanables.add(cmd);
                this.maybeBridgeResponse(mc, nv.getEdition(), response_env);
                return RequestForwardingResult.SUCCESS;
            }
        }
        catch (CommandExecutionIOException cxx) {
            this.debugCommandExecutionException(cxx);
            result = RequestForwardingResult.UNAVAILABLE;
        }
        catch (CommandExecutionException cxx) {
            this.debugCommandExecutionException(cxx);
        }
        catch (Exception x) {
            cat.debug("error forwarding", x);
        }
        cmd.clean(mc);
        return result;
    }

    private Iterator<InputStream> getRequestAttachments(MessageContext mc) {
        return (Iterator)mc.getProperty("request.attachments");
    }

    RequestForwardingResult createRequestForwardingResult(BIBusEnvelope response) {
        BodyFaultDetail faultDetail = response.getBodyFault().getDetail();
        if (cat.isDebugEnabled()) {
            this.logFaultDetail(faultDetail, response);
        }
        return this.checkErrorCode(faultDetail);
    }

    private void logFaultDetail(BodyFaultDetail faultDetail, BIBusEnvelope response) {
        if (faultDetail.isPresent()) {
            cat.debug("Response fault detail: ", faultDetail);
        } else {
            cat.debug("Response with fault: ", response);
        }
    }

    private RequestForwardingResult checkErrorCode(BodyFaultDetail faultDetail) {
        cat.debug("checkErrorCode() - start: ", faultDetail.toString());
        if (!faultDetail.isPresent()) {
            return RequestForwardingResult.SUCCESS;
        }
        List<BodyFaultException> exceptions = faultDetail.getExceptions();
        if (exceptions.isEmpty()) {
            return RequestForwardingResult.SUCCESS;
        }
        String errorCode = this.getFirstErrorCode(exceptions);
        cat.debug("Testing errorcode: ", errorCode);
        return RequestForwarder.createResultFromErrorCode(errorCode, this.parameters == null ? true : this.parameters.isRetryOnNoProcess());
    }

    private String getFirstErrorCode(List<BodyFaultException> exceptions) {
        for (BodyFaultException exception : exceptions) {
            if (!exception.isPresent()) continue;
            return exception.getErrorCode();
        }
        return null;
    }

    LBForwardingPassThroughCommand createLbForwardingPassthroughCommand(BIBusEnvelope request_env, MessageContext mc, ServerConnection connection, String path) {
        LBForwardingPassThroughCommand cmd = null;
        String soapAction = this.parameters.getSoapAction();
        if (soapAction != null && RequestAffinity.determineAffinity(soapAction) == RequestAffinity.GET) {
            cmd = new LBForwardingPassThroughGETCommand(request_env, mc, connection, path);
        } else {
            cmd = new LBForwardingPassThroughCommand(request_env, mc, connection, path);
            cmd.setLargeResponseHint(this.parameters.getPartialSaxReaderMBLimit());
        }
        return cmd;
    }

    String obtainHtmlFlag(BIBusEnvelope request_env) {
        String htmlErrorPageFlag = request_env.getDispatcherTransportValue("html");
        if (htmlErrorPageFlag == null) {
            htmlErrorPageFlag = "false";
        }
        return htmlErrorPageFlag;
    }

    BIBusEnvelope maybeBridgeRequest(MessageContext mc, String edition, BIBusEnvelope request_env) {
        if (RequestForwarder.isCurrent(edition)) {
            return request_env;
        }
        return this.bridgeRequest(mc, edition);
    }

    private BIBusEnvelope bridgeRequest(MessageContext mc, String edition) {
        BIBusEnvelope envelope = this.omBridgeHelper.bridgeRequest(mc, edition);
        cat.debug("Envelope bridged to: ", envelope);
        return envelope;
    }

    void maybeBridgeResponse(MessageContext mc, String edition, BIBusEnvelope response_env) {
        if (!RequestForwarder.isCurrent(edition)) {
            if (response_env != null && response_env.getDispatcherTransportValue("originalSOAPAction") != null && response_env.getDispatcherTransportValue("originalSOAPAction").indexOf("powerPlayService") != -1) {
                this.omBridgeHelper.bridgeResponse(mc, edition);
            } else {
                this.omBridgeHelper.bridgeResponse(mc);
            }
        }
    }

    void updateHeaders(MessageContext mc, String edition, BIBusEnvelope env) {
        String soapAction = RequestForwarder.getSoapActionForEdition(edition);
        String originalSoapAction = env.getDispatcherTransportValue("originalSOAPAction");
        if (!RequestForwarder.isCurrent(edition)) {
            originalSoapAction = this.updateOriginalSoapAction(originalSoapAction, soapAction);
            env.setDispatcherTransport("originalSOAPAction", originalSoapAction);
        }
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        headers.setHeader("SOAPAction", soapAction);
        headers.setHeader("OriginalSOAPAction", originalSoapAction);
    }

    private String updateOriginalSoapAction(String originalSoapAction, String soapAction) {
        BibusSoapAction bibusSoapAction = new BibusSoapAction(soapAction);
        BibusSoapAction bibusOriginalSoapAction = new BibusSoapAction(originalSoapAction);
        String version = bibusSoapAction.getVersion();
        if (version != null && BibusSoapAction.Format.IBM == bibusOriginalSoapAction.getFormat()) {
            bibusOriginalSoapAction.setVersion(version);
        }
        return bibusOriginalSoapAction.toString();
    }

    private void debugCommandExecutionException(CommandExecutionException cxx) {
        if (cat.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("error forwarding, message: ").append(cxx.getMessage()).append(" cause: ");
            if (cxx.getTargetException() != null) {
                sb.append(cxx.getTargetException().getMessage());
                cat.debug(sb.toString(), cxx.getTargetException());
            } else {
                sb.append("--unknown--");
                cat.debug(sb.toString(), cxx);
            }
        }
    }

    static RequestForwardingResult createResultFromErrorCode(String errorCode, boolean retryOnNoProcess) {
        RequestForwardingResult result;
        if (errorCode == null) {
            return RequestForwardingResult.SUCCESS;
        }
        try {
            result = RequestForwardingResult.valueOf(errorCode.replace(".", ""));
        }
        catch (IllegalArgumentException e) {
            return RequestForwardingResult.SUCCESS;
        }
        if (result == RequestForwardingResult.NO_PROCESS && !retryOnNoProcess) {
            return RequestForwardingResult.SUCCESS;
        }
        return result;
    }

    private static String getSoapActionForEdition(String edition) {
        if (RequestForwarder.isCurrent(edition)) {
            return SOAP_ACTION;
        }
        if (RequestForwarder.isColorado(edition)) {
            return COLORADO_SOAP_ACTION;
        }
        return CASPIAN_SOAP_ACTION;
    }

    private static boolean isCurrent(String edition) {
        return Version.isCurrent(edition);
    }

    static boolean isColorado(String edition) {
        return StringUtils.isEmpty((String)edition);
    }

    void setParametersForTest(LoadBalanceRequestParameters parameters) {
        this.parameters = parameters;
    }

    private class InProgressRequestHash
    implements Cleanable {
        HashMap<NodeView, Integer> nodeVievRequestCount = new HashMap();

        private InProgressRequestHash() {
        }

        public void increment(NodeView nv) {
            nv.incrementInProgressRequestCount();
            Integer count = this.nodeVievRequestCount.get(nv);
            if (count == null) {
                count = 0;
            }
            this.nodeVievRequestCount.put(nv, count + 1);
        }

        @Override
        public void clean(MessageContext mc) {
            for (Map.Entry<NodeView, Integer> entry : this.nodeVievRequestCount.entrySet()) {
                entry.getKey().decrementInProgressRequestCount(entry.getValue());
            }
        }
    }
}

